/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.ParallelFileProcessingResult;
import org.apache.tika.batch.fs.FSBatchTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OutputStreamFactoryTest
extends FSBatchTestBase {
    @Test
    public void testIllegalState() throws Exception {
        boolean illegalState;
        block2: {
            Path outputDir = this.getNewOutputDir("os-factory-illegal-state-");
            Map<String, String> args = this.getDefaultArgs("basic", outputDir);
            BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
            this.run(runner);
            Assertions.assertEquals((int)1, (int)OutputStreamFactoryTest.countChildren(outputDir));
            illegalState = false;
            try {
                ParallelFileProcessingResult parallelFileProcessingResult = this.run(runner);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof IllegalStateException)) break block2;
                illegalState = true;
            }
        }
        Assertions.assertTrue((boolean)illegalState, (String)"Should have been an illegal state exception");
    }

    @Test
    public void testSkip() throws Exception {
        Path outputDir = this.getNewOutputDir("os-factory-skip-");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("handleExisting", "skip");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Assertions.assertEquals((int)1, (int)OutputStreamFactoryTest.countChildren(outputDir));
        runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        result = this.run(runner);
        Assertions.assertEquals((int)1, (int)OutputStreamFactoryTest.countChildren(outputDir));
    }
}

