/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.ParallelFileProcessingResult;
import org.apache.tika.batch.fs.FSBatchTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HandlerBuilderTest
extends FSBatchTestBase {
    @Test
    public void testXML() throws Exception {
        Path outputDir = this.getNewOutputDir("handler-xml-");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("basicHandlerType", "xml");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Path outputFile = outputDir.resolve("test0.xml.xml");
        String resultString = HandlerBuilderTest.readFileToString(outputFile, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)resultString.contains("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        Assertions.assertTrue((boolean)resultString.contains("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assertions.assertTrue((boolean)resultString.contains("This is tika-batch's first test file"));
    }

    @Test
    public void testHTML() throws Exception {
        Path outputDir = this.getNewOutputDir("handler-html-");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("basicHandlerType", "html");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Path outputFile = outputDir.resolve("test0.xml.html");
        String resultString = HandlerBuilderTest.readFileToString(outputFile, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)resultString.contains("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        Assertions.assertFalse((boolean)resultString.contains("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assertions.assertTrue((boolean)resultString.contains("This is tika-batch's first test file"));
    }

    @Test
    public void testText() throws Exception {
        Path outputDir = this.getNewOutputDir("handler-txt-");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("basicHandlerType", "txt");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Path outputFile = outputDir.resolve("test0.xml.txt");
        String resultString = HandlerBuilderTest.readFileToString(outputFile, StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)resultString.contains("<html xmlns=\"http://www.w3.org/1999/xhtml\">"));
        Assertions.assertFalse((boolean)resultString.contains("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assertions.assertTrue((boolean)resultString.contains("This is tika-batch's first test file"));
    }

    @Test
    public void testXMLWithWriteLimit() throws Exception {
        Path outputDir = this.getNewOutputDir("handler-xml-write-limit-");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("writeLimit", "5");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Path outputFile = outputDir.resolve("test0.xml.xml");
        String resultString = HandlerBuilderTest.readFileToString(outputFile, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)resultString.equals(""));
    }

    @Test
    public void testRecursiveParserWrapper() throws Exception {
        Path outputDir = this.getNewOutputDir("handler-recursive-parser");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("basicHandlerType", "txt");
        args.put("recursiveParserWrapper", "true");
        BatchProcess runner = this.getNewBatchRunner("/tika-batch-config-test.xml", args);
        ParallelFileProcessingResult result = this.run(runner);
        Path outputFile = outputDir.resolve("test0.xml.json");
        String resultString = HandlerBuilderTest.readFileToString(outputFile, StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)resultString.contains("\"author\":\"Nikolai Lobachevsky\""));
        Assertions.assertTrue((boolean)resultString.contains("tika-batch's first test file"));
    }
}

