/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tika.batch.fs.FSFileResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FSFileResourceTest {
    @Test
    public void testRelativization() throws Exception {
        Path root = Paths.get("root/abc/def", new String[0]).toAbsolutePath();
        Path allegedChild = Paths.get(root.getParent().getParent().toAbsolutePath().toString(), new String[0]);
        try {
            FSFileResource r = new FSFileResource(root, allegedChild);
            Assertions.fail((String)"should have had assertion error: alleged child not actually child of root");
        }
        catch (AssertionError r) {
            // empty catch block
        }
        root = Paths.get("root/abc/def", new String[0]);
        Path child = Paths.get(root.toString(), "ghi/jkl/lmnop.doc");
        FSFileResource r = new FSFileResource(root, child);
        String id = r.getResourceId();
        Assertions.assertTrue((boolean)id.startsWith("ghi"));
        Assertions.assertTrue((boolean)id.endsWith("lmnop.doc"));
    }
}

