/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.tika.TikaTest;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.BatchProcessDriverCLI;
import org.apache.tika.batch.ParallelFileProcessingResult;
import org.apache.tika.batch.builders.BatchProcessBuilder;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;

public abstract class FSBatchTestBase
extends TikaTest {
    @TempDir
    private static Path OUTPUT_ROOT = null;

    @BeforeAll
    public static void setUp() throws Exception {
        Path testOutput = Paths.get("target/test-classes/test-output", new String[0]);
        Files.createDirectories(testOutput, new FileAttribute[0]);
        OUTPUT_ROOT = Files.createTempDirectory(testOutput, "tika-batch-output-root-", new FileAttribute[0]);
    }

    public static int countChildren(Path p) throws IOException {
        int i = 0;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(p);){
            for (Path d : ds) {
                ++i;
            }
        }
        return i;
    }

    public static String readFileToString(Path p, Charset cs) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader r = Files.newBufferedReader(p, cs);){
            String line = r.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = r.readLine();
            }
        }
        return sb.toString();
    }

    public static List<Path> listPaths(Path p) throws IOException {
        ArrayList<Path> list = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(p);){
            for (Path d : ds) {
                list.add(d);
            }
        }
        return list;
    }

    protected void destroyProcess(Process p) {
        if (p == null) {
            return;
        }
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            p.destroy();
        }
    }

    Path getNewOutputDir(String subdirPrefix) throws IOException {
        Path outputDir = Files.createTempDirectory(OUTPUT_ROOT, subdirPrefix, new FileAttribute[0]);
        assert (FSBatchTestBase.countChildren(outputDir) == 0);
        return outputDir;
    }

    Map<String, String> getDefaultArgs(String inputSubDir, Path outputDir) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("inputDir", "\"" + this.getInputRoot(inputSubDir).toString() + "\"");
        if (outputDir != null) {
            args.put("outputDir", "\"" + outputDir.toString() + "\"");
        }
        return args;
    }

    public String[] getDefaultCommandLineArgsArr(String inputSubDir, Path outputDir, Map<String, String> commandLine) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (inputSubDir != null) {
            args.add("-inputDir");
            args.add(this.getInputRoot(inputSubDir).toAbsolutePath().toString());
        }
        if (outputDir != null) {
            args.add("-outputDir");
            args.add(outputDir.toAbsolutePath().toString());
        }
        if (commandLine != null) {
            for (Map.Entry<String, String> e : commandLine.entrySet()) {
                args.add(e.getKey());
                args.add(e.getValue());
            }
        }
        return args.toArray(new String[0]);
    }

    public Path getInputRoot(String subdir) throws Exception {
        String path = subdir == null || subdir.length() == 0 ? "/test-input" : "/test-input/" + subdir;
        return Paths.get(this.getResourceAsUri(path));
    }

    BatchProcess getNewBatchRunner(String testConfig, Map<String, String> args) throws IOException {
        InputStream is = this.getResourceAsStream(testConfig);
        BatchProcessBuilder b = new BatchProcessBuilder();
        BatchProcess runner = b.build(is, args);
        IOUtils.closeQuietly((InputStream)is);
        return runner;
    }

    public ProcessBuilder getNewBatchRunnerProcess(String testConfig, String loggerProps, Map<String, String> args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Map.Entry<String, String> e : args.entrySet()) {
            argList.add("-" + e.getKey());
            argList.add(e.getValue());
        }
        String[] fullCommandLine = this.commandLine(testConfig, loggerProps, argList.toArray(new String[0]));
        return new ProcessBuilder(fullCommandLine);
    }

    private String[] commandLine(String testConfig, String loggerProps, String[] args) {
        ArrayList<Object> commandLine = new ArrayList<Object>();
        commandLine.add("java");
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Dlog4j.configuration=file:" + this.getResourceAsUrl(loggerProps).getFile());
        commandLine.add("-Xmx128m");
        commandLine.add("-cp");
        String cp = System.getProperty("java.class.path");
        cp = ProcessUtils.escapeCommandLine((String)cp);
        commandLine.add(cp);
        commandLine.add("org.apache.tika.batch.fs.FSBatchProcessCLI");
        String configFile = null;
        try {
            configFile = Paths.get(this.getResourceAsUri(testConfig)).toAbsolutePath().toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        commandLine.add("-bc");
        commandLine.add(configFile);
        commandLine.addAll(Arrays.asList(args));
        return commandLine.toArray(new String[0]);
    }

    public BatchProcessDriverCLI getNewDriver(String testConfig, String[] args) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("java");
        commandLine.add("-Djava.awt.headless=true");
        commandLine.add("-Xmx128m");
        commandLine.add("-cp");
        String cp = System.getProperty("java.class.path");
        cp = ProcessUtils.escapeCommandLine((String)cp);
        commandLine.add(cp);
        commandLine.add("org.apache.tika.batch.fs.FSBatchProcessCLI");
        String configFile = Paths.get(this.getResourceAsUri(testConfig)).toAbsolutePath().toString();
        commandLine.add("-bc");
        commandLine.add(configFile);
        commandLine.addAll(Arrays.asList(args));
        BatchProcessDriverCLI driver = new BatchProcessDriverCLI(commandLine.toArray(new String[0]));
        driver.setRedirectForkedProcessToStdOut(false);
        return driver;
    }

    protected ParallelFileProcessingResult run(BatchProcess process) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future futureResult = executor.submit(process);
        return (ParallelFileProcessingResult)futureResult.get(10L, TimeUnit.SECONDS);
    }
}

