/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.tika.batch.BatchProcess;
import org.apache.tika.batch.fs.FSBatchTestBase;
import org.apache.tika.batch.fs.StringStreamGobbler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Disabled(value="Batch Driver is the integration test")
public class BatchProcessTest
extends FSBatchTestBase {
    @Test
    @Timeout(value=15000L)
    public void oneHeavyHangTest() throws Exception {
        Path outputDir = this.getNewOutputDir("one_heavy_hang-");
        Map<String, String> args = this.getDefaultArgs("one_heavy_hang", outputDir);
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)5, (int)BatchProcessTest.countChildren(outputDir));
        Path hvyHang = outputDir.resolve("test0_heavy_hang.xml.xml");
        Assertions.assertTrue((boolean)Files.exists(hvyHang, new LinkOption[0]));
        Assertions.assertEquals((long)0L, (long)Files.size(hvyHang));
        BatchProcessTest.assertNotContained((String)BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString(), (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=15000L)
    public void allHeavyHangsTest() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangs-");
        Map<String, String> args = this.getDefaultArgs("heavy_heavy_hangs", outputDir);
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)3, (int)BatchProcessTest.countChildren(outputDir));
        for (Path hvyHang : BatchProcessTest.listPaths(outputDir)) {
            Assertions.assertTrue((boolean)Files.exists(hvyHang, new LinkOption[0]));
            Assertions.assertEquals((long)0L, (long)Files.size(hvyHang), (String)("file length for " + hvyHang.getFileName() + " should be 0, but is: " + Files.size(hvyHang)));
        }
        BatchProcessTest.assertContains((String)BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString(), (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=30000L)
    public void allHeavyHangsTestWithExcessiveNumberConsumersTest() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangsExcessiveNumberConsumers-");
        Map<String, String> args = this.getDefaultArgs("heavy_heavy_hangs", outputDir);
        args.put("numConsumers", "100");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)7, (int)BatchProcessTest.countChildren(outputDir));
        for (int i = 0; i < 6; ++i) {
            Path hvyHang = outputDir.resolve("test" + i + "_heavy_hang.xml.xml");
            Assertions.assertTrue((boolean)Files.exists(hvyHang, new LinkOption[0]));
            Assertions.assertEquals((long)0L, (long)Files.size(hvyHang));
        }
        BatchProcessTest.assertContains((String)"This is tika-batch's first test file", (String)BatchProcessTest.readFileToString(outputDir.resolve("test6_ok.xml.xml"), StandardCharsets.UTF_8));
        BatchProcessTest.assertNotContained((String)BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString(), (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=30000L)
    public void allHeavyHangsTestWithStarvedCrawler() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangsStarvedCrawler-");
        Map<String, String> args = this.getDefaultArgs("heavy_heavy_hangs", outputDir);
        args.put("numConsumers", "2");
        args.put("maxQueueSize", "2");
        args.put("timeoutThresholdMillis", "100000000");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)2, (int)BatchProcessTest.countChildren(outputDir));
        for (int i = 0; i < 2; ++i) {
            Path hvyHang = outputDir.resolve("test" + i + "_heavy_hang.xml.xml");
            Assertions.assertTrue((boolean)Files.exists(hvyHang, new LinkOption[0]));
            Assertions.assertEquals((long)0L, (long)Files.size(hvyHang));
        }
        BatchProcessTest.assertContains((String)BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString(), (String)streamStrings.getErrString());
        BatchProcessTest.assertContains((String)"Crawler timed out", (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=15000L)
    public void outOfMemory() throws Exception {
        Path outputDir = this.getNewOutputDir("oom-");
        Map<String, String> args = this.getDefaultArgs("oom", outputDir);
        args.put("numConsumers", "3");
        args.put("timeoutThresholdMillis", "30000");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)4, (int)BatchProcessTest.countChildren(outputDir));
        BatchProcessTest.assertContains((String)"This is tika-batch's first test file", (String)BatchProcessTest.readFileToString(outputDir.resolve("test2_ok.xml.xml"), StandardCharsets.UTF_8));
        BatchProcessTest.assertContains((String)BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString(), (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=15000L)
    public void noRestart() throws Exception {
        Path outputDir = this.getNewOutputDir("no_restart");
        Map<String, String> args = this.getDefaultArgs("no_restart", outputDir);
        args.put("numConsumers", "1");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Path test2 = outputDir.resolve("test2_norestart.xml.xml");
        Assertions.assertTrue((boolean)Files.exists(test2, new LinkOption[0]), (String)"test2_norestart.xml");
        Path test3 = outputDir.resolve("test3_ok.xml.xml");
        Assertions.assertFalse((boolean)Files.exists(test3, new LinkOption[0]), (String)"test3_ok.xml");
        BatchProcessTest.assertContains((String)"exitStatus=254", (String)streamStrings.getOutString());
        BatchProcessTest.assertContains((String)"causeForTermination='MAIN_LOOP_EXCEPTION_NO_RESTART'", (String)streamStrings.getOutString());
    }

    @Test
    @Timeout(value=60000L)
    public void testWaitAfterEarlyTermination() throws Exception {
        Path outputDir = this.getNewOutputDir("wait_after_early_termination");
        Map<String, String> args = this.getDefaultArgs("wait_after_early_termination", outputDir);
        args.put("numConsumers", "1");
        args.put("maxAliveTimeSeconds", "5");
        args.put("timeoutThresholdMillis", "300000");
        args.put("pauseOnEarlyTerminationMillis", "20000");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)1, (int)BatchProcessTest.countChildren(outputDir));
        BatchProcessTest.assertContains((String)"<p>some content</p>", (String)BatchProcessTest.readFileToString(outputDir.resolve("test0_sleep.xml.xml"), StandardCharsets.UTF_8));
        BatchProcessTest.assertContains((String)"exitStatus=253", (String)streamStrings.getOutString());
        BatchProcessTest.assertContains((String)"causeForTermination='BATCH_PROCESS_ALIVE_TOO_LONG'", (String)streamStrings.getOutString());
    }

    @Test
    @Timeout(value=60000L)
    public void testTimeOutAfterBeingAskedToShutdown() throws Exception {
        Path outputDir = this.getNewOutputDir("timeout_after_early_termination");
        Map<String, String> args = this.getDefaultArgs("timeout_after_early_termination", outputDir);
        args.put("numConsumers", "1");
        args.put("maxAliveTimeSeconds", "5");
        args.put("timeoutThresholdMillis", "10000");
        args.put("pauseOnEarlyTerminationMillis", "20000");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        List<Path> paths = BatchProcessTest.listPaths(outputDir);
        Assertions.assertEquals((int)1, (int)paths.size());
        Assertions.assertEquals((long)0L, (long)Files.size(paths.get(0)));
        BatchProcessTest.assertContains((String)"exitStatus=253", (String)streamStrings.getOutString());
        BatchProcessTest.assertContains((String)"causeForTermination='BATCH_PROCESS_ALIVE_TOO_LONG'", (String)streamStrings.getOutString());
    }

    @Test
    @Timeout(value=10000L)
    public void testRedirectionOfStreams() throws Exception {
        Path outputDir = this.getNewOutputDir("noisy_parsers");
        Map<String, String> args = this.getDefaultArgs("noisy_parsers", outputDir);
        args.put("numConsumers", "1");
        args.put("maxAliveTimeSeconds", "20");
        String stderr = "writing something to System.err";
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args);
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)1, (int)BatchProcessTest.countChildren(outputDir));
        BatchProcessTest.assertContains((String)"System.out", (String)streamStrings.getOutString());
        BatchProcessTest.assertContains((String)stderr, (String)streamStrings.getOutString());
        BatchProcessTest.assertNotContained((String)stderr, (String)streamStrings.getErrString());
    }

    @Test
    @Timeout(value=10000L)
    public void testConsumersManagerInitHang() throws Exception {
        Path outputDir = this.getNewOutputDir("init_hang");
        Map<String, String> args = this.getDefaultArgs("noisy_parsers", outputDir);
        args.put("numConsumers", "1");
        args.put("hangOnInit", "true");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args, "/tika-batch-config-MockConsumersBuilder.xml");
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)254, (int)ex.getExitValue());
        BatchProcessTest.assertContains((String)"causeForTermination='CONSUMERS_MANAGER_DIDNT_INIT_IN_TIME_NO_RESTART'", (String)streamStrings.getOutString());
    }

    @Test
    @Timeout(value=10000L)
    public void testConsumersManagerShutdownHang() throws Exception {
        Path outputDir = this.getNewOutputDir("shutdown_hang");
        Map<String, String> args = this.getDefaultArgs("noisy_parsers", outputDir);
        args.put("numConsumers", "1");
        args.put("hangOnShutdown", "true");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args, "/tika-batch-config-MockConsumersBuilder.xml");
        StreamStrings streamStrings = ex.execute();
        Assertions.assertEquals((int)254, (int)ex.getExitValue());
        BatchProcessTest.assertContains((String)"ConsumersManager did not shutdown within", (String)streamStrings.getOutString());
    }

    @Test
    public void testHierarchicalWFileList() throws Exception {
        Path outputDir = this.getNewOutputDir("hierarchical_file_list");
        Map<String, String> args = this.getDefaultArgs("hierarchical", outputDir);
        args.put("numConsumers", "1");
        args.put("fileList", Paths.get(this.getResourceAsUri("/testFileList.txt")).toString());
        args.put("recursiveParserWrapper", "true");
        args.put("basicHandlerType", "text");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args, "/tika-batch-config-MockConsumersBuilder.xml");
        ex.execute();
        Path test1 = outputDir.resolve("test1.xml.json");
        Path test2 = outputDir.resolve("sub1a/test2.xml.json");
        Path test3 = outputDir.resolve("sub1a/sub2a/test3.xml.json");
        Assertions.assertTrue((boolean)Files.exists(test1, new LinkOption[0]), (String)"test1 exists");
        Assertions.assertTrue((Files.size(test1) > 10L ? 1 : 0) != 0, (String)"test1 length > 10");
        Assertions.assertTrue((Files.exists(test3, new LinkOption[0]) && Files.size(test3) > 10L ? 1 : 0) != 0);
        Path test2Dir = outputDir.resolve("sub1a");
        Assertions.assertEquals((int)1, (int)BatchProcessTest.countChildren(test2Dir));
        Assertions.assertFalse((boolean)Files.exists(test2, new LinkOption[0]));
    }

    @Test
    public void testHandlingOfIllegalXMLCharsInException() throws Exception {
        Path outputDir = this.getNewOutputDir("illegal_xml_chars_in_exception");
        Map<String, String> args = this.getDefaultArgs("illegal_xml_chars_in_exception", outputDir);
        args.put("numConsumers", "1");
        args.put("recursiveParserWrapper", "true");
        args.put("basicHandlerType", "text");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args, "/tika-batch-config-MockConsumersBuilder.xml", "/log4j2-on.properties");
        StreamStrings ss = ex.execute();
        Assertions.assertFalse((boolean)ss.getOutString().contains("error writing xml stream for"));
        BatchProcessTest.assertContains((String)"parse_ex resourceId=\"test0_bad_chars.xml\"", (String)ss.getOutString());
    }

    @Test
    public void testOverrideOutputSuffix() throws Exception {
        Path outputDir = this.getNewOutputDir("outputSuffixTest");
        Map<String, String> args = this.getDefaultArgs("basic", outputDir);
        args.put("numConsumers", "1");
        args.put("recursiveParserWrapper", "true");
        args.put("basicHandlerType", "text");
        BatchProcessTestExecutor ex = new BatchProcessTestExecutor(args, "/tika-batch-config-test-suffix-override.xml", "/log4j2-on.properties");
        ex.execute();
        Path targ = outputDir.resolve("test0.xml.mysuffix");
        Assertions.assertTrue((boolean)Files.isRegularFile(targ, new LinkOption[0]));
    }

    private class BatchProcessTestExecutor {
        private final Map<String, String> args;
        private final String configPath;
        private final String loggerProps;
        private int exitValue = Integer.MIN_VALUE;

        public BatchProcessTestExecutor(Map<String, String> args) {
            this(args, "/tika-batch-config-test.xml");
        }

        public BatchProcessTestExecutor(Map<String, String> args, String configPath) {
            this(args, configPath, "/log4j2_process.properties");
        }

        public BatchProcessTestExecutor(Map<String, String> args, String configPath, String loggerProps) {
            this.args = args;
            this.configPath = configPath;
            this.loggerProps = loggerProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StreamStrings execute() {
            Process p = null;
            try {
                ProcessBuilder b = BatchProcessTest.this.getNewBatchRunnerProcess(this.configPath, this.loggerProps, this.args);
                p = b.start();
                StringStreamGobbler errorGobbler = new StringStreamGobbler(p.getErrorStream());
                StringStreamGobbler outGobbler = new StringStreamGobbler(p.getInputStream());
                Thread errorThread = new Thread(errorGobbler);
                Thread outThread = new Thread(outGobbler);
                errorThread.start();
                outThread.start();
                while (true) {
                    try {
                        this.exitValue = p.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        continue;
                    }
                    break;
                }
                errorGobbler.stopGobblingAndDie();
                outGobbler.stopGobblingAndDie();
                errorThread.interrupt();
                outThread.interrupt();
                StreamStrings streamStrings = new StreamStrings(outGobbler.toString(), errorGobbler.toString());
                BatchProcessTest.this.destroyProcess(p);
                return streamStrings;
            }
            catch (IOException e) {
                Assertions.fail();
            }
            finally {
                BatchProcessTest.this.destroyProcess(p);
            }
            return null;
        }

        private int getExitValue() {
            return this.exitValue;
        }
    }

    private static class StreamStrings {
        private final String outString;
        private final String errString;

        private StreamStrings(String outString, String errString) {
            this.outString = outString;
            this.errString = errString;
        }

        private String getOutString() {
            return this.outString;
        }

        private String getErrString() {
            return this.errString;
        }

        public String toString() {
            return "OUT>>" + this.outString + "<<\nERR>>" + this.errString + "<<\n";
        }
    }
}

