/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tika.batch.BatchProcessDriverCLI;
import org.apache.tika.batch.fs.FSBatchTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class BatchDriverTest
extends FSBatchTestBase {
    @Test
    @Timeout(value=15000L)
    public void oneHeavyHangTest() throws Exception {
        Path outputDir = this.getNewOutputDir("daemon-");
        Assertions.assertTrue((boolean)Files.isDirectory(outputDir, new LinkOption[0]));
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        String[] args = this.getDefaultCommandLineArgsArr("one_heavy_hang", outputDir, null);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", args);
        driver.execute();
        Assertions.assertEquals((int)0, (int)driver.getNumRestarts());
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        Assertions.assertEquals((int)5, (int)BatchDriverTest.countChildren(outputDir));
        BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test2_ok.xml.xml"), StandardCharsets.UTF_8));
    }

    @Test
    @Timeout(value=30000L)
    public void restartOnFullHangTest() throws Exception {
        Path outputDir = this.getNewOutputDir("daemon-");
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        String[] args = this.getDefaultCommandLineArgsArr("heavy_heavy_hangs", outputDir, null);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", args);
        driver.execute();
        Assertions.assertTrue((driver.getNumRestarts() > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test6_ok.xml.xml"), StandardCharsets.UTF_8));
    }

    @Test
    @Timeout(value=15000L)
    public void noRestartTest() throws Exception {
        Path outputDir = this.getNewOutputDir("daemon-");
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        String[] args = this.getDefaultCommandLineArgsArr("no_restart", outputDir, null);
        String[] mod = Arrays.copyOf(args, args.length + 2);
        mod[args.length] = "-numConsumers";
        mod[args.length + 1] = "1";
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", mod);
        driver.execute();
        Assertions.assertEquals((int)0, (int)driver.getNumRestarts());
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        Assertions.assertEquals((int)2, (int)BatchDriverTest.countChildren(outputDir));
        Path test2 = outputDir.resolve("test2_norestart.xml.xml");
        Assertions.assertTrue((boolean)Files.exists(test2, new LinkOption[0]), (String)"test2_norestart.xml");
        Path test3 = outputDir.resolve("test3_ok.xml.xml");
        Assertions.assertFalse((boolean)Files.exists(test3, new LinkOption[0]), (String)"test3_ok.xml");
    }

    @Test
    @Timeout(value=15000L)
    public void restartOnOOMTest() throws Exception {
        Path outputDir = this.getNewOutputDir("daemon-");
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        String[] args = this.getDefaultCommandLineArgsArr("oom", outputDir, null);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", args);
        driver.execute();
        Assertions.assertEquals((int)1, (int)driver.getNumRestarts());
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test2_ok.xml.xml"), StandardCharsets.UTF_8));
    }

    @Test
    @Timeout(value=60000L)
    public void allHeavyHangsTestWithStarvedCrawler() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangsStarvedCrawler-");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "2");
        args.put("-maxQueueSize", "2");
        String[] commandLine = this.getDefaultCommandLineArgsArr("heavy_heavy_hangs", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)3, (int)driver.getNumRestarts());
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test6_ok.xml.xml"), StandardCharsets.UTF_8));
    }

    @Test
    @Timeout(value=30000L)
    public void maxRestarts() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangsStarvedCrawler-");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        args.put("-maxQueueSize", "10");
        args.put("-maxRestarts", "2");
        String[] commandLine = this.getDefaultCommandLineArgsArr("max_restarts", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)2, (int)driver.getNumRestarts());
        Assertions.assertFalse((boolean)driver.isUserInterrupted());
        Assertions.assertEquals((int)3, (int)BatchDriverTest.countChildren(outputDir));
    }

    @Test
    @Timeout(value=30000L)
    public void maxRestartsBadParameter() throws Exception {
        Path outputDir = this.getNewOutputDir("allHeavyHangsStarvedCrawler-");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        args.put("-maxQueueSize", "10");
        args.put("-maxRestarts", "zebra");
        String[] commandLine = this.getDefaultCommandLineArgsArr("max_restarts", outputDir, args);
        boolean ex = false;
        try {
            BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
            driver.execute();
        }
        catch (IllegalArgumentException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"IllegalArgumentException should have been thrown");
    }

    @Test
    @Timeout(value=30000L)
    public void testNoRestartIfProcessFails() throws Exception {
        Path outputDir = this.getNewOutputDir("nostart-norestart-");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        args.put("-maxQueueSize", "10");
        String[] commandLine = this.getDefaultCommandLineArgsArr("basic", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-broken.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        Assertions.assertEquals((int)0, (int)driver.getNumRestarts());
    }

    @Test
    @Timeout(value=30000L)
    public void testNoRestartIfProcessFailsTake2() throws Exception {
        Path outputDir = this.getNewOutputDir("nostart-norestart-");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        args.put("-maxQueueSize", "10");
        args.put("-somethingOrOther", "I don't Know");
        String[] commandLine = this.getDefaultCommandLineArgsArr("basic", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)0, (int)BatchDriverTest.countChildren(outputDir));
        Assertions.assertEquals((int)0, (int)driver.getNumRestarts());
    }

    @Test
    @Timeout(value=60000L)
    public void testSystemExit() throws Exception {
        int i;
        Path outputDir = this.getNewOutputDir("system-exit");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        String[] commandLine = this.getDefaultCommandLineArgsArr("system_exit", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)6, (int)BatchDriverTest.countChildren(outputDir));
        Assertions.assertTrue((driver.getNumRestarts() > 1 ? 1 : 0) != 0);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((long)0L, (long)Files.size(outputDir.resolve("test" + i + "_system_exit.xml.xml")), (String)("problem with " + i));
        }
        for (i = 5; i < 6; ++i) {
            BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test" + i + "_ok.xml.xml"), StandardCharsets.UTF_8));
        }
    }

    @Test
    @Disabled(value="Java 11-ea+23 makes outputstreams uninterruptible")
    @Timeout(value=60000L)
    public void testThreadInterrupt() throws Exception {
        int i;
        Path outputDir = this.getNewOutputDir("thread-interrupt");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("-numConsumers", "1");
        String[] commandLine = this.getDefaultCommandLineArgsArr("thread_interrupt", outputDir, args);
        BatchProcessDriverCLI driver = this.getNewDriver("/tika-batch-config-test.xml", commandLine);
        driver.execute();
        Assertions.assertEquals((int)6, (int)BatchDriverTest.countChildren(outputDir));
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((long)0L, (long)Files.size(outputDir.resolve("test" + i + "_thread_interrupt.xml.xml")), (String)("problem with " + i));
        }
        for (i = 5; i < 6; ++i) {
            BatchDriverTest.assertContains((String)"first test file", (String)BatchDriverTest.readFileToString(outputDir.resolve("test" + i + "_ok.xml.xml"), StandardCharsets.UTF_8));
        }
    }
}

