/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.TikaTest;
import org.apache.tika.batch.AutoDetectParserFactory;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.PoisonFileResource;
import org.apache.tika.batch.fs.RecursiveParserWrapperFSConsumer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.metadata.filter.NoOpFilter;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.serialization.JsonMetadataList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecursiveParserWrapperFSConsumerTest
extends TikaTest {
    @Test
    public void testEmbeddedWithNPE() throws Exception {
        String path = "/test-documents/embedded_with_npe.xml";
        final Metadata metadata = new Metadata();
        metadata.add("resourceName", "embedded_with_npe.xml");
        ArrayBlockingQueue<1> queue = new ArrayBlockingQueue<1>(2);
        queue.add(new FileResource(){

            public String getResourceId() {
                return "testFile";
            }

            public Metadata getMetadata() {
                return metadata;
            }

            public InputStream openInputStream() throws IOException {
                return RecursiveParserWrapperFSConsumerTest.this.getResourceAsStream("/test-documents/embedded_with_npe.xml");
            }
        });
        queue.add(new PoisonFileResource());
        MockOSFactory mockOSFactory = new MockOSFactory();
        RecursiveParserWrapper p = new RecursiveParserWrapper(new AutoDetectParserFactory().getParser(new TikaConfig()));
        RecursiveParserWrapperFSConsumer consumer = new RecursiveParserWrapperFSConsumer(queue, (Parser)p, (ContentHandlerFactory)new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.TEXT, -1), (OutputStreamFactory)mockOSFactory, (MetadataFilter)NoOpFilter.NOOP_FILTER);
        IFileProcessorFutureResult result = consumer.call();
        mockOSFactory.getStreams().get(0).flush();
        byte[] bytes = mockOSFactory.getStreams().get(0).toByteArray();
        List results = JsonMetadataList.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)4, (int)results.size());
        RecursiveParserWrapperFSConsumerTest.assertContains((String)"another null pointer", (String)((Metadata)results.get(2)).get(TikaCoreProperties.EMBEDDED_EXCEPTION));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)results.get(0)).get("author"));
        for (int i = 1; i < 4; ++i) {
            Assertions.assertEquals((Object)("embeddedAuthor" + i), (Object)((Metadata)results.get(i)).get("author"));
            RecursiveParserWrapperFSConsumerTest.assertContains((String)("some_embedded_content" + i), (String)((Metadata)results.get(i)).get(TikaCoreProperties.TIKA_CONTENT));
        }
    }

    @Test
    public void testEmbeddedThenNPE() throws Exception {
        String path = "/test-documents/embedded_then_npe.xml";
        final Metadata metadata = new Metadata();
        metadata.add("resourceName", "embedded_then_npe.xml");
        ArrayBlockingQueue<2> queue = new ArrayBlockingQueue<2>(2);
        queue.add(new FileResource(){

            public String getResourceId() {
                return "testFile";
            }

            public Metadata getMetadata() {
                return metadata;
            }

            public InputStream openInputStream() throws IOException {
                return RecursiveParserWrapperFSConsumerTest.this.getResourceAsStream("/test-documents/embedded_then_npe.xml");
            }
        });
        queue.add(new PoisonFileResource());
        MockOSFactory mockOSFactory = new MockOSFactory();
        RecursiveParserWrapper p = new RecursiveParserWrapper(new AutoDetectParserFactory().getParser(new TikaConfig()));
        RecursiveParserWrapperFSConsumer consumer = new RecursiveParserWrapperFSConsumer(queue, (Parser)p, (ContentHandlerFactory)new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.TEXT, -1), (OutputStreamFactory)mockOSFactory, (MetadataFilter)NoOpFilter.NOOP_FILTER);
        IFileProcessorFutureResult result = consumer.call();
        mockOSFactory.getStreams().get(0).flush();
        byte[] bytes = mockOSFactory.getStreams().get(0).toByteArray();
        List results = JsonMetadataList.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)2, (int)results.size());
        RecursiveParserWrapperFSConsumerTest.assertContains((String)"another null pointer", (String)((Metadata)results.get(0)).get(TikaCoreProperties.CONTAINER_EXCEPTION));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)results.get(0)).get("author"));
        Assertions.assertEquals((Object)"embeddedAuthor", (Object)((Metadata)results.get(1)).get("author"));
        RecursiveParserWrapperFSConsumerTest.assertContains((String)"some_embedded_content", (String)((Metadata)results.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    private static class MockOSFactory
    implements OutputStreamFactory {
        List<ByteArrayOutputStream> streams = new ArrayList<ByteArrayOutputStream>();

        private MockOSFactory() {
        }

        public OutputStream getOutputStream(Metadata metadata) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.streams.add(bos);
            return bos;
        }

        public List<ByteArrayOutputStream> getStreams() {
            return this.streams;
        }
    }
}

