/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.tika.cli.TikaCLITest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TikaCLIAsyncTest
extends TikaCLITest {
    private static Path ASYNC_CONFIG;
    @TempDir
    private static Path ASYNC_OUTPUT_DIR;

    @BeforeAll
    public static void setUpClass() throws Exception {
        ASYNC_CONFIG = Files.createTempFile(ASYNC_OUTPUT_DIR, "async-config-", ".xml", new FileAttribute[0]);
        String xml = "<properties><async><numClients>3</numClients><tikaConfig>" + ASYNC_CONFIG.toAbsolutePath() + "</tikaConfig></async><fetchers><fetcher class=\"org.apache.tika.pipes.fetcher.fs.FileSystemFetcher\"><name>fsf</name><basePath>" + TEST_DATA_FILE.getAbsolutePath() + "</basePath></fetcher></fetchers><emitters><emitter class=\"org.apache.tika.pipes.emitter.fs.FileSystemEmitter\"><name>fse</name><basePath>" + ASYNC_OUTPUT_DIR.toAbsolutePath() + "</basePath><prettyPrint>true</prettyPrint></emitter></emitters><pipesIterator class=\"org.apache.tika.pipes.pipesiterator.fs.FileSystemPipesIterator\"><basePath>" + TEST_DATA_FILE.getAbsolutePath() + "</basePath><fetcherName>fsf</fetcherName><emitterName>fse</emitterName></pipesIterator></properties>";
        Files.write(ASYNC_CONFIG, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Test
    public void testAsync() throws Exception {
        String content = this.getParamOutContent("-a", "--config=" + ASYNC_CONFIG.toAbsolutePath());
        int json = 0;
        for (File f : ASYNC_OUTPUT_DIR.toFile().listFiles()) {
            if (!f.getName().endsWith(".json")) continue;
            if (f.getName().equals("coffee.xls.json")) {
                this.checkForPrettyPrint(f);
            }
            ++json;
        }
        Assertions.assertEquals((int)18, (int)json);
    }

    private void checkForPrettyPrint(File f) throws IOException {
        String json = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
        int previous = json.indexOf("Content-Length");
        Assertions.assertTrue((previous > -1 ? 1 : 0) != 0);
        for (String k : new String[]{"Content-Type", "dc:creator", "dcterms:created", "dcterms:modified", "X-TIKA:content\""}) {
            int i = json.indexOf(k);
            Assertions.assertTrue((i > -1 ? 1 : 0) != 0, (String)("should have found " + k));
            Assertions.assertTrue((i > previous ? 1 : 0) != 0, (String)("bad order: " + k + " at " + i + " not less than " + previous));
            previous = i;
        }
    }
}

