/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import org.apache.tika.batch.DigestingAutoDetectParserFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.parser.csv.TextAndCSVParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEmbeddedDocumentUtil {
    @Test
    public void testSimple() {
        AutoDetectParser p = new AutoDetectParser();
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, (Object)p);
        Parser txtParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(TextAndCSVParser.class, (ParseContext)parseContext);
        Assertions.assertNotNull((Object)txtParser);
        Assertions.assertEquals(TextAndCSVParser.class, txtParser.getClass());
    }

    @Test
    public void testDoublyDecorated() {
        Parser d = new DigestingAutoDetectParserFactory().getParser(TikaConfig.getDefaultConfig());
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(d, true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, (Object)wrapper);
        Parser txtParser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(TextAndCSVParser.class, (ParseContext)parseContext);
        Assertions.assertNotNull((Object)txtParser);
        Assertions.assertEquals(TextAndCSVParser.class, txtParser.getClass());
    }
}

