/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.tika.cli.TikaCLI;
import org.apache.tika.exception.TikaException;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TikaCLITest {
    private static final File TEST_DATA_FILE = new File("src/test/resources/test-data");
    private static Path ASYNC_CONFIG;
    @TempDir
    private static Path ASYNC_OUTPUT_DIR;
    @TempDir
    private Path extractDir;
    private final URI testDataURI = TEST_DATA_FILE.toURI();
    private ByteArrayOutputStream outContent = null;
    private ByteArrayOutputStream errContent = null;
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private String resourcePrefix;

    @BeforeAll
    public static void setUpClass() throws Exception {
        ASYNC_CONFIG = Files.createTempFile(ASYNC_OUTPUT_DIR, "async-config-", ".xml", new FileAttribute[0]);
        String xml = "<properties><async><numClients>3</numClients><tikaConfig>" + ASYNC_CONFIG.toAbsolutePath() + "</tikaConfig></async><fetchers><fetcher class=\"org.apache.tika.pipes.fetcher.fs.FileSystemFetcher\"><name>fsf</name><basePath>" + TEST_DATA_FILE.getAbsolutePath() + "</basePath></fetcher></fetchers><emitters><emitter class=\"org.apache.tika.pipes.emitter.fs.FileSystemEmitter\"><name>fse</name><basePath>" + ASYNC_OUTPUT_DIR.toAbsolutePath() + "</basePath><prettyPrint>true</prettyPrint></emitter></emitters><pipesIterator class=\"org.apache.tika.pipes.pipesiterator.fs.FileSystemPipesIterator\"><basePath>" + TEST_DATA_FILE.getAbsolutePath() + "</basePath><fetcherName>fsf</fetcherName><emitterName>fse</emitterName></pipesIterator></properties>";
        Files.write(ASYNC_CONFIG, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    protected static void assertExtracted(Path p, String allFiles) throws IOException {
        Assertions.assertTrue((boolean)Files.exists(p, new LinkOption[0]), (String)("File " + p.getFileName() + " not found in " + allFiles));
        Assertions.assertFalse((boolean)Files.isDirectory(p, new LinkOption[0]), (String)("File " + p.getFileName() + " is a directory!"));
        Assertions.assertTrue((Files.size(p) > 0L ? 1 : 0) != 0, (String)("File " + p.getFileName() + " wasn't extracted with contents"));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.resourcePrefix = this.testDataURI.toString();
        this.stdout = System.out;
        this.stderr = System.err;
        this.resetContent();
    }

    @AfterEach
    public void tearDown() {
        System.setOut(this.stdout);
        System.setErr(this.stderr);
    }

    private void resetContent() throws Exception {
        if (this.outContent == null || this.outContent.size() > 0) {
            this.outContent = new ByteArrayOutputStream();
            System.setOut(new PrintStream((OutputStream)this.outContent, true, StandardCharsets.UTF_8.name()));
        }
        if (this.errContent == null || this.errContent.size() > 0) {
            this.errContent = new ByteArrayOutputStream();
            System.setErr(new PrintStream((OutputStream)this.errContent, true, StandardCharsets.UTF_8.name()));
        }
    }

    @Test
    public void testListParserDetail() throws Exception {
        String content = this.getParamOutContent("--list-parser-detail");
        Assertions.assertTrue((boolean)content.contains("application/vnd.oasis.opendocument.text-web"));
        content = this.getParamOutContent("--list-parser-details");
        Assertions.assertTrue((boolean)content.contains("application/vnd.oasis.opendocument.text-web"));
    }

    @Test
    public void testListParsers() throws Exception {
        String content = this.getParamOutContent("--list-parser");
        Assertions.assertTrue((boolean)content.contains("org.apache.tika.parser.iwork.IWorkPackageParser"));
    }

    @Test
    public void testXMLOutput() throws Exception {
        String content = this.getParamOutContent("-x", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("?xml version=\"1.0\" encoding=\"UTF-8\"?"));
        content = this.getParamOutContent("-x", "--digest=SHA256", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("<meta name=\"X-TIKA:digest:SHA256\" content=\"e90779adbac09c4ee"));
    }

    @Test
    public void testHTMLOutput() throws Exception {
        String content = this.getParamOutContent("-h", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("html xmlns=\"http://www.w3.org/1999/xhtml"));
        Assertions.assertTrue((boolean)content.contains("<title></title>"), (String)"Expanded <title></title> element should be present");
        content = this.getParamOutContent("-h", "--digest=SHA384", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("<meta name=\"X-TIKA:digest:SHA384\" content=\"c69ea023f5da95a026"));
    }

    @Test
    public void testTextOutput() throws Exception {
        String content = this.getParamOutContent("-t", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("finished off the cake"));
    }

    @Test
    public void testContentAllOutput() throws Exception {
        String[] params = new String[]{"-A", this.resourcePrefix + "testJsonMultipleInts.html"};
        TikaCLI.main((String[])params);
        String out = this.outContent.toString(StandardCharsets.UTF_8.name());
        Assertions.assertTrue((boolean)out.contains("this is a title"));
        Assertions.assertTrue((boolean)out.contains("body"));
    }

    @Test
    public void testForkParser() throws Exception {
        String content = this.getParamOutContent("-f", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("finished off the cake"));
    }

    @Test
    public void testMetadataOutput() throws Exception {
        String content = this.getParamOutContent("-m", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("text/plain"));
        content = this.getParamOutContent("-m", "--digest=SHA512", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("text/plain"));
        Assertions.assertTrue((boolean)content.contains("X-TIKA:digest:SHA512: dd459d99bc19ff78fd31fbae46e0"));
    }

    @Test
    public void testJsonMetadataOutput() throws Exception {
        String json = this.getParamOutContent("--json", "--digest=MD2", this.resourcePrefix + "testJsonMultipleInts.html");
        Assertions.assertTrue((boolean)json.contains("\"fb:admins\":\"1,2,3,4\","));
        int enc = json.indexOf("\"Content-Encoding\"");
        int fb = json.indexOf("fb:admins");
        int title = json.indexOf("\"dc:title\"");
        Assertions.assertTrue((enc > -1 && fb > -1 && enc < fb ? 1 : 0) != 0);
        Assertions.assertTrue((fb > -1 && title > -1 && fb > title ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)json.contains("\"X-TIKA:digest:MD2\":"));
    }

    @Test
    public void testJsonMetadataPrettyPrintOutput() throws Exception {
        String json = this.getParamOutContent("--json", "-r", this.resourcePrefix + "testJsonMultipleInts.html");
        Assertions.assertTrue((boolean)json.contains("\"X-TIKA:Parsed-By\" : [ \"org.apache.tika.parser.DefaultParser\", \"org.apache.tika.parser.html.HtmlParser\" ],"));
        int enc = json.indexOf("\"Content-Encoding\"");
        int fb = json.indexOf("fb:admins");
        int title = json.indexOf("\"dc:title\"");
        Assertions.assertTrue((enc > -1 && fb > -1 && enc < fb ? 1 : 0) != 0);
        Assertions.assertTrue((fb > -1 && title > -1 && fb > title ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultPDFIncrementalUpdateSettings() throws Exception {
        String json = this.getParamOutContent("-J", this.resourcePrefix + "testPDF_incrementalUpdates.pdf");
        Assertions.assertTrue((boolean)json.contains("pdf:incrementalUpdateCount\":\"2\""));
        Assertions.assertTrue((boolean)json.contains("embeddedResourceType\":\"VERSION\""));
    }

    @Test
    public void testLanguageOutput() throws Exception {
        String content = this.getParamOutContent("-l", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("en"));
    }

    @Test
    public void testDetectOutput() throws Exception {
        String content = this.getParamOutContent("-d", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("text/plain"));
    }

    @Test
    public void testListMetModels() throws Exception {
        String content = this.getParamOutContent("--list-met-models", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("text/plain"));
    }

    @Test
    public void testListSupportedTypes() throws Exception {
        String content = this.getParamOutContent("--list-supported-types", this.resourcePrefix + "alice.cli.test");
        Assertions.assertTrue((boolean)content.contains("supertype: application/octet-stream"));
    }

    @Test
    public void testExtractSimple() throws Exception {
        String[] expectedChildren = new String[]{"MBD002B040A.cdx", "file4.png", "MBD002B0FA6.bin", "MBD00262FE3.txt", "file0.emf"};
        this.testExtract("/coffee.xls", expectedChildren, 8);
    }

    @Test
    public void testExtractAbsolute() throws Exception {
        String[] expectedChildren = new String[]{"dangerous/dont/touch.pl"};
        this.testExtract("testZip_absolutePath.zip", expectedChildren, 2);
    }

    @Test
    public void testExtractRelative() throws Exception {
        String[] expectedChildren = new String[]{"touch.pl"};
        this.testExtract("testZip_relative.zip", expectedChildren);
    }

    @Test
    public void testExtractOverlapping() throws Exception {
        String[] expectedChildren = new String[]{"f1.txt"};
        this.testExtract("testZip_overlappingNames.zip", expectedChildren, 2);
    }

    @Test
    public void testExtract0x00() throws Exception {
        String[] expectedChildren = new String[]{"dang erous.pl"};
        this.testExtract("testZip_zeroByte.zip", expectedChildren);
    }

    private void testExtract(String targetFile, String[] expectedChildrenFileNames) throws Exception {
        this.testExtract(targetFile, expectedChildrenFileNames, expectedChildrenFileNames.length);
    }

    private void testExtract(String targetFile, String[] expectedChildrenFileNames, int expectedLength) throws Exception {
        String[] params = new String[]{"--extract-dir=" + ProcessUtils.escapeCommandLine((String)this.extractDir.toAbsolutePath().toString()), "-z", this.resourcePrefix + "/" + targetFile};
        TikaCLI.main((String[])params);
        CharSequence[] tempFileNames = this.extractDir.toFile().list();
        Assertions.assertNotNull((Object)tempFileNames);
        Assertions.assertEquals((int)expectedLength, (int)tempFileNames.length);
        String allFiles = String.join((CharSequence)" : ", tempFileNames);
        for (String expectedChildName : expectedChildrenFileNames) {
            TikaCLITest.assertExtracted(this.extractDir.resolve(expectedChildName), allFiles);
        }
    }

    @Test
    public void testExtractTgz() throws Exception {
        String[] params = new String[]{"--extract-dir=" + this.extractDir.toAbsolutePath(), "-z", this.resourcePrefix + "/test-documents.tgz"};
        TikaCLI.main((String[])params);
        CharSequence[] tempFileNames = this.extractDir.toFile().list();
        Assertions.assertNotNull((Object)tempFileNames);
        String allFiles = String.join((CharSequence)" : ", tempFileNames);
        Path expectedTAR = this.extractDir.resolve("test-documents.tar");
        TikaCLITest.assertExtracted(expectedTAR, allFiles);
    }

    @Test
    public void testMultiValuedMetadata() throws Exception {
        String content = this.getParamOutContent("-m", this.resourcePrefix + "testMultipleSheets.numbers");
        Assertions.assertTrue((boolean)content.contains("sheetNames: Checking"));
        Assertions.assertTrue((boolean)content.contains("sheetNames: Secon sheet"));
        Assertions.assertTrue((boolean)content.contains("sheetNames: Logical Sheet 3"));
        Assertions.assertTrue((boolean)content.contains("sheetNames: Sheet 4"));
    }

    @Test
    public void testZipWithSubdirs() throws Exception {
        new File("subdir/foo.txt").delete();
        new File("subdir").delete();
        String content = this.getParamOutContent("-z", "--extract-dir=target", this.resourcePrefix + "testWithSubdirs.zip");
        Assertions.assertTrue((boolean)content.contains("Extracting 'subdir/foo.txt'"));
        new File("target/subdir/foo.txt").delete();
        new File("target/subdir").delete();
    }

    @Test
    public void testExtractInlineImages() throws Exception {
        String[] params = new String[]{"--extract-dir=" + this.extractDir.toAbsolutePath(), "-z", this.resourcePrefix + "/testPDF_childAttachments.pdf"};
        TikaCLI.main((String[])params);
        CharSequence[] tempFileNames = this.extractDir.toFile().list();
        Assertions.assertNotNull((Object)tempFileNames);
        String allFiles = String.join((CharSequence)" : ", tempFileNames);
        Path jpeg = this.extractDir.resolve("image0.jpg");
        Path jobOptions = this.extractDir.resolve("Press Quality(1).joboptions");
        Path doc = this.extractDir.resolve("Unit10.doc");
        TikaCLITest.assertExtracted(jpeg, allFiles);
        TikaCLITest.assertExtracted(jobOptions, allFiles);
        TikaCLITest.assertExtracted(doc, allFiles);
    }

    @Test
    public void testDefaultConfigException() throws Exception {
        String[] params = new String[]{this.resourcePrefix + "bad_xml.xml"};
        boolean tikaEx = false;
        try {
            TikaCLI.main((String[])params);
        }
        catch (TikaException e) {
            tikaEx = true;
        }
        Assertions.assertTrue((boolean)tikaEx);
    }

    @Test
    public void testConfig() throws Exception {
        String content = this.getParamOutContent("--config=" + TEST_DATA_FILE.toString() + "/tika-config1.xml", this.resourcePrefix + "bad_xml.xml");
        Assertions.assertTrue((boolean)content.contains("apple"));
        Assertions.assertTrue((boolean)content.contains("org.apache.tika.parser.html.HtmlParser"));
    }

    @Test
    public void testConfigIgnoreInit() throws Exception {
        String content = this.getParamOutContent("--config=" + TEST_DATA_FILE.toString() + "/TIKA-2389-ignore-init-problems.xml", this.resourcePrefix + "test_recursive_embedded.docx");
        Assertions.assertTrue((boolean)content.contains("embed_1a"));
    }

    @Test
    public void testJsonRecursiveMetadataParserMetadataOnly() throws Exception {
        String content = this.getParamOutContent("-m", "-J", "-r", this.resourcePrefix + "test_recursive_embedded.docx");
        Assertions.assertTrue((boolean)content.contains("\"extended-properties:AppVersion\" : \"15.0000\","));
        Assertions.assertTrue((boolean)content.contains("\"extended-properties:Application\" : \"Microsoft Office Word\","));
        Assertions.assertTrue((boolean)content.contains("\"X-TIKA:embedded_resource_path\" : \"/embed1.zip\""));
        Assertions.assertFalse((boolean)content.contains("X-TIKA:content"));
    }

    @Test
    public void testJsonRecursiveMetadataParserDefault() throws Exception {
        String content = this.getParamOutContent("-J", "-r", this.resourcePrefix + "test_recursive_embedded.docx");
        Assertions.assertTrue((boolean)content.contains("\"X-TIKA:content\" : \"<html xmlns=\\\"http://www.w3.org/1999/xhtml"));
    }

    @Test
    public void testJsonRecursiveMetadataParserText() throws Exception {
        String content = this.getParamOutContent("-J", "-r", "-t", this.resourcePrefix + "test_recursive_embedded.docx");
        Assertions.assertTrue((boolean)content.contains("\\n\\nembed_4\\n"));
        Assertions.assertTrue((boolean)content.contains("\\n\\nembed_0"));
    }

    @Test
    public void testDigestInJson() throws Exception {
        String content = this.getParamOutContent("-J", "-r", "-t", "--digest=MD5", this.resourcePrefix + "test_recursive_embedded.docx");
        Assertions.assertTrue((boolean)content.contains("\"X-TIKA:digest:MD5\" : \"59f626e09a8c16ab6dbc2800c685f772\","));
        Assertions.assertTrue((boolean)content.contains("\"X-TIKA:digest:MD5\" : \"f9627095ef86c482e61d99f0cc1cf87d\""));
    }

    @Test
    public void testConfigSerializationStaticAndCurrent() throws Exception {
        String content = this.getParamOutContent("--dump-static-config");
        Assertions.assertTrue((boolean)content.contains("<detector class=\"org.apache.tika.detect.microsoft.POIFSContainerDetector\"/>"));
        Assertions.assertTrue((boolean)content.contains("<parser class=\"org.apache.tika.parser.executable.ExecutableParser\"/>"));
        content = this.getParamOutContent("--dump-current-config");
        Assertions.assertTrue((boolean)content.contains("<detector class=\"org.apache.tika.detect.DefaultDetector\"/>"));
        Assertions.assertTrue((boolean)content.contains("<parser class=\"org.apache.tika.parser.DefaultParser\"/>"));
    }

    @Test
    public void testConfigSerializationCustomMinimal() throws Exception {
        String content = this.getParamOutContent("--config=" + TEST_DATA_FILE.toString() + "/tika-config2.xml", "--dump-minimal-config").replaceAll("[\r\n\t ]+", " ");
        String expected = "<parser class=\"org.apache.tika.parser.DefaultParser\"> <mime-exclude>application/pdf</mime-exclude> <mime-exclude>image/jpeg</mime-exclude> </parser> <parser class=\"org.apache.tika.parser.EmptyParser\"> <mime>application/pdf</mime> </parser>";
        Assertions.assertTrue((boolean)content.contains(expected));
    }

    @Test
    public void testConfigSerializationCustomStatic() throws Exception {
        String content = this.getParamOutContent("--config=" + TEST_DATA_FILE.toString() + "/tika-config2.xml", "--dump-static-config");
        Assertions.assertFalse((boolean)content.contains("org.apache.tika.parser.executable.Executable"));
    }

    @Test
    public void testListDetectors() throws Exception {
        String content = this.getParamOutContent("--list-detector");
        Assertions.assertTrue((boolean)content.contains("org.apache.tika.detect.DefaultDetector"));
        content = this.getParamOutContent("--list-detectors");
        Assertions.assertTrue((boolean)content.contains("org.apache.tika.detect.DefaultDetector"));
    }

    @Test
    public void testListParserDetailApt() throws Exception {
        String content = this.getParamOutContent("--list-parser-detail-apt");
        Assertions.assertTrue((boolean)content.contains("application/vnd.oasis.opendocument.text-web"));
        content = this.getParamOutContent("--list-parser-details-apt");
        Assertions.assertTrue((boolean)content.contains("application/vnd.oasis.opendocument.text-web"));
    }

    @Test
    public void testAsync() throws Exception {
        String content = this.getParamOutContent("-a", "--config=" + ASYNC_CONFIG.toAbsolutePath());
        int json = 0;
        for (File f : ASYNC_OUTPUT_DIR.toFile().listFiles()) {
            if (!f.getName().endsWith(".json")) continue;
            if (f.getName().equals("coffee.xls.json")) {
                this.checkForPrettyPrint(f);
            }
            ++json;
        }
        Assertions.assertEquals((int)18, (int)json);
    }

    private void checkForPrettyPrint(File f) throws IOException {
        String json = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
        int previous = json.indexOf("Content-Length");
        Assertions.assertTrue((previous > -1 ? 1 : 0) != 0);
        for (String k : new String[]{"Content-Type", "dc:creator", "dcterms:created", "dcterms:modified", "X-TIKA:content\""}) {
            int i = json.indexOf(k);
            Assertions.assertTrue((i > -1 ? 1 : 0) != 0, (String)("should have found " + k));
            Assertions.assertTrue((i > previous ? 1 : 0) != 0, (String)("bad order: " + k + " at " + i + " not less than " + previous));
            previous = i;
        }
    }

    private String getParamOutContent(String ... params) throws Exception {
        this.resetContent();
        TikaCLI.main((String[])params);
        return this.outContent.toString("UTF-8");
    }
}

