/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tika.cli.TikaCLI;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TikaCLIBatchIntegrationTest {
    private final String propsFileName = "log4j2_batch_process_test.properties";
    private Path testInputDir = Paths.get("src/test/resources/test-data", new String[0]);
    private String testInputDirForCommandLine;
    private Path tempOutputDir;
    private String tempOutputDirForCommandLine;
    private Path customBatchLogging;
    private OutputStream out = null;
    private OutputStream err = null;
    private ByteArrayOutputStream outBuffer = null;
    private ByteArrayOutputStream errBuffer = null;
    private Path configFile = null;

    @BeforeEach
    public void setup() throws Exception {
        this.tempOutputDir = Files.createTempDirectory("tika-cli-test-batch-", new FileAttribute[0]);
        this.outBuffer = new ByteArrayOutputStream();
        PrintStream outWriter = new PrintStream((OutputStream)this.outBuffer, true, StandardCharsets.UTF_8.name());
        this.errBuffer = new ByteArrayOutputStream();
        PrintStream errWriter = new PrintStream((OutputStream)this.errBuffer, true, StandardCharsets.UTF_8.name());
        this.out = System.out;
        this.err = System.err;
        System.setOut(outWriter);
        System.setErr(errWriter);
        this.testInputDirForCommandLine = this.testInputDir.toAbsolutePath().toString();
        this.tempOutputDirForCommandLine = this.tempOutputDir.toAbsolutePath().toString();
        this.customBatchLogging = this.tempOutputDir.resolve("log4j2_batch_process_test.properties");
        this.configFile = Files.createTempFile("tika-app-batch-", ".xml", new FileAttribute[0]);
        Files.copy(this.getClass().getResourceAsStream("/log4j2_batch_process_test.properties"), this.customBatchLogging, new CopyOption[0]);
        Files.copy(this.getClass().getResourceAsStream("/test-data/tika-config1.xml"), this.configFile, StandardCopyOption.REPLACE_EXISTING);
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.setOut(new PrintStream(this.out, true, StandardCharsets.UTF_8.name()));
        System.setErr(new PrintStream(this.err, true, StandardCharsets.UTF_8.name()));
        FileUtils.deleteDirectory((File)this.tempOutputDir.toFile());
        Files.delete(this.configFile);
    }

    @Test
    public void testSimplestBatchIntegration() throws Exception {
        String[] params = new String[]{this.testInputDirForCommandLine, this.tempOutputDirForCommandLine};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
    }

    @Test
    public void testTikaConfig() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "--config=" + this.configFile.toAbsolutePath().toString()};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
    }

    @Test
    public void testBasicBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "2"};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
    }

    @Test
    public void testJsonRecursiveBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)12, (int)metadataList.size());
            Assertions.assertTrue((boolean)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).contains("human events"));
        }
    }

    @Test
    public void testStreamingJsonRecursiveBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t", "-streamOut"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)12, (int)metadataList.size());
            Assertions.assertTrue((boolean)((Metadata)metadataList.get(6)).get(TikaCoreProperties.TIKA_CONTENT).contains("human events"));
            Assertions.assertNull((Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        }
    }

    @Test
    public void testProcessLogFileConfig() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "2", "-JDlog4j.configurationFile=" + this.customBatchLogging.toUri()};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
        String sysOutString = new String(this.outBuffer.toByteArray(), StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)sysOutString.contains("MY_CUSTOM_LOG_CONFIG"));
    }

    @Test
    public void testDigester() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t", "-digest", "sha512"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)12, (int)metadataList.size());
            Assertions.assertNotNull((Object)((Metadata)metadataList.get(0)).get("X-TIKA:digest:SHA512"));
            Assertions.assertTrue((boolean)((Metadata)metadataList.get(0)).get("X-TIKA:digest:SHA512").startsWith("ee46d973ee1852c01858"));
        }
    }

    private void assertFileExists(Path path) {
        Assertions.assertTrue((boolean)Files.isRegularFile(path, new LinkOption[0]), (String)("File doesn't exist: " + path.toAbsolutePath()));
    }
}

