/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tika.cli.TikaCLI;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.sax.AbstractRecursiveParserWrapperHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TikaCLIBatchIntegrationTest {
    private Path testInputDir = Paths.get("src/test/resources/test-data", new String[0]);
    private String testInputDirForCommandLine;
    private Path tempOutputDir;
    private String tempOutputDirForCommandLine;
    private OutputStream out = null;
    private OutputStream err = null;
    private ByteArrayOutputStream outBuffer = null;

    @Before
    public void setup() throws Exception {
        this.tempOutputDir = Files.createTempDirectory("tika-cli-test-batch-", new FileAttribute[0]);
        this.outBuffer = new ByteArrayOutputStream();
        PrintStream outWriter = new PrintStream((OutputStream)this.outBuffer, true, StandardCharsets.UTF_8.name());
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintStream errWriter = new PrintStream((OutputStream)errBuffer, true, StandardCharsets.UTF_8.name());
        this.out = System.out;
        this.err = System.err;
        System.setOut(outWriter);
        System.setErr(errWriter);
        this.testInputDirForCommandLine = this.testInputDir.toAbsolutePath().toString();
        this.tempOutputDirForCommandLine = this.tempOutputDir.toAbsolutePath().toString();
    }

    @After
    public void tearDown() throws Exception {
        System.setOut(new PrintStream(this.out, true, StandardCharsets.UTF_8.name()));
        System.setErr(new PrintStream(this.err, true, StandardCharsets.UTF_8.name()));
        FileUtils.deleteDirectory((File)this.tempOutputDir.toFile());
    }

    @Test
    public void testSimplestBatchIntegration() throws Exception {
        String[] params = new String[]{this.testInputDirForCommandLine, this.tempOutputDirForCommandLine};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
    }

    @Test
    public void testBasicBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "2"};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
    }

    @Test
    public void testJsonRecursiveBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assert.assertEquals((long)12L, (long)metadataList.size());
            Assert.assertTrue((boolean)((Metadata)metadataList.get(6)).get(AbstractRecursiveParserWrapperHandler.TIKA_CONTENT).contains("human events"));
        }
    }

    @Test
    public void testStreamingJsonRecursiveBatchIntegration() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t", "-streamOut"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assert.assertEquals((long)12L, (long)metadataList.size());
            Assert.assertTrue((boolean)((Metadata)metadataList.get(6)).get(AbstractRecursiveParserWrapperHandler.TIKA_CONTENT).contains("human events"));
            Assert.assertNull((Object)((Metadata)metadataList.get(0)).get(AbstractRecursiveParserWrapperHandler.EMBEDDED_RESOURCE_PATH));
        }
    }

    @Test
    public void testProcessLogFileConfig() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "2", "-JDlog4j.configuration=log4j_batch_process_test.properties"};
        TikaCLI.main((String[])params);
        this.assertFileExists(this.tempOutputDir.resolve("bad_xml.xml.xml"));
        this.assertFileExists(this.tempOutputDir.resolve("coffee.xls.xml"));
        String sysOutString = new String(this.outBuffer.toByteArray(), StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)sysOutString.contains("MY_CUSTOM_LOG_CONFIG"));
    }

    @Test
    public void testDigester() throws Exception {
        String[] params = new String[]{"-i", this.testInputDirForCommandLine, "-o", this.tempOutputDirForCommandLine, "-numConsumers", "10", "-J", "-t", "-digest", "sha512"};
        TikaCLI.main((String[])params);
        Path jsonFile = this.tempOutputDir.resolve("test_recursive_embedded.docx.json");
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assert.assertEquals((long)12L, (long)metadataList.size());
            Assert.assertNotNull((Object)((Metadata)metadataList.get(0)).get("X-TIKA:digest:SHA512"));
            Assert.assertTrue((boolean)((Metadata)metadataList.get(0)).get("X-TIKA:digest:SHA512").startsWith("ee46d973ee1852c01858"));
        }
    }

    private void assertFileExists(Path path) {
        Assert.assertTrue((String)("File doesn't exist: " + path.toAbsolutePath()), (boolean)Files.isRegularFile(path, new LinkOption[0]));
    }
}

