/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tika.cli.BatchCommandLineBuilder;
import org.apache.tika.utils.ProcessUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TikaCLIBatchCommandLineTest {
    Path testInput = null;
    Path testFile = null;
    String testInputPathForCommandLine;
    String escapedInputPathForCommandLine;

    @Before
    public void init() {
        this.testInput = Paths.get("testInput", new String[0]);
        try {
            Files.createDirectories(this.testInput, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open test input directory");
        }
        this.testFile = Paths.get("testFile.txt", new String[0]);
        try (OutputStream os = Files.newOutputStream(this.testFile, new OpenOption[0]);){
            IOUtils.write((String)"test output", (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't open testFile");
        }
        this.testInputPathForCommandLine = this.testInput.toAbsolutePath().toString();
        this.escapedInputPathForCommandLine = BatchCommandLineBuilder.commandLineSafe((String)this.testInputPathForCommandLine);
    }

    @After
    public void tearDown() {
        try {
            FileUtils.deleteDirectory((File)this.testInput.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                Files.deleteIfExists(this.testFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testJVMOpts() throws Exception {
        String[] params = new String[]{"-JXmx1g", "-JDlog4j.configuration=batch_process_log4j.xml", "-inputDir", this.testInputPathForCommandLine, "-outputDir", "testout-output"};
        String[] commandLine = BatchCommandLineBuilder.build((String[])params);
        StringBuilder sb = new StringBuilder();
        for (String s : commandLine) {
            sb.append(s).append(" ");
        }
        String s = sb.toString();
        int classInd = s.indexOf("org.apache.tika.batch.fs.FSBatchProcessCLI");
        int xmx = s.indexOf("-Xmx1g");
        int inputDir = s.indexOf("-inputDir");
        int log = s.indexOf("-Dlog4j.configuration");
        Assert.assertTrue((classInd > -1 ? 1 : 0) != 0);
        Assert.assertTrue((xmx > -1 ? 1 : 0) != 0);
        Assert.assertTrue((inputDir > -1 ? 1 : 0) != 0);
        Assert.assertTrue((log > -1 ? 1 : 0) != 0);
        Assert.assertTrue((xmx < classInd ? 1 : 0) != 0);
        Assert.assertTrue((log < classInd ? 1 : 0) != 0);
        Assert.assertTrue((inputDir > classInd ? 1 : 0) != 0);
    }

    @Test
    public void testBasicMappingOfArgs() throws Exception {
        String[] params = new String[]{"-JXmx1g", "-JDlog4j.configuration=batch_process_log4j.xml", "-bc", "batch-config.xml", "-J", "-h", "-inputDir", this.testInputPathForCommandLine};
        String[] commandLine = BatchCommandLineBuilder.build((String[])params);
        Map<String, String> attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)"true", (Object)attrs.get("-recursiveParserWrapper"));
        Assert.assertEquals((Object)"html", (Object)attrs.get("-basicHandlerType"));
        Assert.assertEquals((Object)"batch-config.xml", (Object)attrs.get("-bc"));
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
    }

    @Test
    public void testTwoDirsNoFlags() throws Exception {
        String outputRoot = "outputRoot";
        String[] params = new String[]{this.testInputPathForCommandLine, outputRoot};
        String[] commandLine = BatchCommandLineBuilder.build((String[])params);
        Map<String, String> attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
        Assert.assertEquals((Object)outputRoot, (Object)attrs.get("-outputDir"));
    }

    @Test
    public void testTwoDirsVarious() throws Exception {
        String outputRoot = "outputRoot";
        String[] params = new String[]{"-i", this.testInputPathForCommandLine, "-o", outputRoot};
        String[] commandLine = BatchCommandLineBuilder.build((String[])params);
        Map<String, String> attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
        Assert.assertEquals((Object)outputRoot, (Object)attrs.get("-outputDir"));
        params = new String[]{"--inputDir", this.testInputPathForCommandLine, "--outputDir", outputRoot};
        commandLine = BatchCommandLineBuilder.build((String[])params);
        attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
        Assert.assertEquals((Object)outputRoot, (Object)attrs.get("-outputDir"));
        params = new String[]{"-inputDir", this.testInputPathForCommandLine, "-outputDir", outputRoot};
        commandLine = BatchCommandLineBuilder.build((String[])params);
        attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
        Assert.assertEquals((Object)outputRoot, (Object)attrs.get("-outputDir"));
    }

    @Test
    public void testConfig() throws Exception {
        String outputRoot = "outputRoot";
        String configPath = "c:/somewhere/someConfig.xml";
        String[] params = new String[]{"--inputDir", this.testInputPathForCommandLine, "--outputDir", outputRoot, "--config=" + configPath};
        String[] commandLine = BatchCommandLineBuilder.build((String[])params);
        Map<String, String> attrs = this.mapify(commandLine);
        Assert.assertEquals((Object)this.escapedInputPathForCommandLine, (Object)attrs.get("-inputDir"));
        Assert.assertEquals((Object)outputRoot, (Object)attrs.get("-outputDir"));
        Assert.assertEquals((Object)configPath, (Object)attrs.get("-c"));
    }

    @Test
    public void testOneDirOneFileException() throws Exception {
        boolean ex = false;
        try {
            String path = this.testFile.toAbsolutePath().toString();
            path = ProcessUtils.escapeCommandLine((String)path);
            String[] params = new String[]{this.testInputPathForCommandLine, path};
            String[] commandLine = BatchCommandLineBuilder.build((String[])params);
            Assert.fail((String)"Not allowed to have one dir and one file");
        }
        catch (IllegalArgumentException e) {
            ex = true;
        }
        Assert.assertTrue((String)"exception on <dir> <file>", (boolean)ex);
    }

    private Map<String, String> mapify(String[] args) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            String k = args[i];
            String v = "";
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                v = args[i + 1];
                ++i;
            }
            map.put(k, v);
        }
        return map;
    }
}

