/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.Random;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.history.logging.ats.ATSHistoryLoggingService;
import org.apache.tez.runtime.library.processor.SleepProcessor;
import org.apache.tez.tests.MiniTezClusterWithTimeline;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestATSHistoryWithMiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestATSHistoryWithMiniCluster.class);
    protected static MiniTezClusterWithTimeline mrrTezCluster = null;
    protected static MiniDFSCluster dfsCluster = null;
    private static String timelineAddress;
    private Random random = new Random();
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (mrrTezCluster == null) {
            try {
                mrrTezCluster = new MiniTezClusterWithTimeline(TestATSHistoryWithMiniCluster.class.getName(), 1, 1, 1, true);
                Configuration conf = new Configuration();
                conf.setBoolean("yarn.timeline-service.enabled", true);
                conf.set("fs.defaultFS", remoteFs.getUri().toString());
                conf.setInt("yarn.nodemanager.delete.debug-delay-sec", 20000);
                mrrTezCluster.init(conf);
                mrrTezCluster.start();
            }
            catch (Throwable e) {
                LOG.info("Failed to start Mini Tez Cluster", e);
            }
        }
        if ((timelineAddress = mrrTezCluster.getConfig().get("yarn.timeline-service.webapp.address")) != null) {
            timelineAddress = timelineAddress.replace("0.0.0.0", "localhost");
        }
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        LOG.info("Shutdown invoked");
        Thread.sleep(10000L);
        if (mrrTezCluster != null) {
            mrrTezCluster.stop();
            mrrTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    private <K> K getTimelineData(String url, Class<K> clazz) {
        Client client = new Client();
        WebResource resource = client.resource(url);
        ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Object entity = response.getEntity(clazz);
        Assert.assertNotNull((Object)entity);
        return (K)entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testDisabledACls() throws Exception {
        TezClient tezSession = null;
        try {
            SleepProcessor.SleepProcessorConfig spConf = new SleepProcessor.SleepProcessorConfig(1);
            DAG dag = DAG.create((String)"TezSleepProcessor");
            Vertex vertex = Vertex.create((String)"SleepVertex", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)SleepProcessor.class.getName()).setUserPayload(spConf.toUserPayload())), (int)1, (Resource)Resource.newInstance((int)256, (int)1));
            dag.addVertex(vertex);
            TezConfiguration tezConf = new TezConfiguration(mrrTezCluster.getConfig());
            tezConf.setBoolean("tez.allow.disabled.timeline-domains", true);
            tezConf.set("tez.history.logging.service.class", ATSHistoryLoggingService.class.getName());
            Path remoteStagingDir = remoteFs.makeQualified(new Path("/tmp", String.valueOf(this.random.nextInt(100000))));
            remoteFs.mkdirs(remoteStagingDir);
            tezConf.set("tez.staging-dir", remoteStagingDir.toString());
            tezSession = TezClient.create((String)"TezSleepProcessor", (TezConfiguration)tezConf, (boolean)true);
            tezSession.start();
            DAGClient dagClient = tezSession.submitDAG(dag);
            DAGStatus dagStatus = dagClient.getDAGStatus(null);
            while (!dagStatus.isCompleted()) {
                LOG.info("Waiting for job to complete. Sleeping for 500ms. Current state: " + dagStatus.getState());
                Thread.sleep(500L);
                dagStatus = dagClient.getDAGStatus(null);
            }
            Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
        }
        finally {
            if (tezSession != null) {
                tezSession.stop();
            }
        }
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestATSHistoryWithMiniCluster.class.getName() + "-tmpDir";
    }
}

