/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.tests;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.DAGAppMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniTezClusterWithTimeline
extends MiniYARNCluster {
    public static final String APPJAR = JarFinder.getJar(DAGAppMaster.class);
    private static final Logger LOG = LoggerFactory.getLogger(MiniTezClusterWithTimeline.class);
    private static final String YARN_CLUSTER_CONFIG = "yarn-site.xml";
    private Path confFilePath;
    private long maxTimeToWaitForAppsOnShutdown;

    public MiniTezClusterWithTimeline(String testName) {
        this(testName, 1);
    }

    public MiniTezClusterWithTimeline(String testName, int noOfNMs) {
        super(testName, noOfNMs, 4, 4);
    }

    public MiniTezClusterWithTimeline(String testName, int noOfNMs, int numLocalDirs, int numLogDirs) {
        super(testName, noOfNMs, numLocalDirs, numLogDirs);
    }

    public MiniTezClusterWithTimeline(String testName, int noOfNMs, int numLocalDirs, int numLogDirs, boolean enableAHS) {
        super(testName, 1, noOfNMs, numLocalDirs, numLogDirs, enableAHS);
    }

    public void serviceInit(Configuration conf) throws Exception {
        conf.set("mapreduce.framework.name", "yarn-tez");
        conf.setBoolean("tez.use.cluster.hadoop-libs", true);
        conf.setBoolean("tez.am.node-blacklisting.enabled", false);
        if (conf.get("yarn.app.mapreduce.am.staging-dir") == null) {
            conf.set("yarn.app.mapreduce.am.staging-dir", new File(this.getTestWorkDir(), "apps_staging_dir/").getAbsolutePath());
        }
        if (conf.get("yarn.nodemanager.delete.debug-delay-sec") == null) {
            conf.setLong("yarn.nodemanager.delete.debug-delay-sec", 0L);
        }
        this.maxTimeToWaitForAppsOnShutdown = conf.getLong("tez.test.minicluster.app.wait.on.shutdown.secs", 30L);
        File appJarLocalFile = new File(APPJAR);
        if (!appJarLocalFile.exists()) {
            String message = "TezAppJar " + APPJAR + " not found. Exiting.";
            LOG.info(message);
            throw new TezUncheckedException(message);
        }
        LOG.info("Using Tez AppJar: " + appJarLocalFile.getAbsolutePath());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testRootDir = fs.makeQualified(new Path("target", this.getName() + "-tmpDir"));
        Path appRemoteJar = new Path(testRootDir, "TezAppJar.jar");
        Path appMasterJar = new Path(APPJAR);
        fs.copyFromLocalFile(appMasterJar, appRemoteJar);
        fs.setPermission(appRemoteJar, new FsPermission("777"));
        conf.set("tez.lib.uris", appRemoteJar.toUri().toString());
        LOG.info("Set TEZ-LIB-URI to: " + conf.get("tez.lib.uris"));
        conf.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
        conf.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
        conf.set("fs.permissions.umask-mode", "000");
        try {
            FileContext fc;
            Path stagingPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(conf.get("yarn.app.mapreduce.am.staging-dir")));
            if (Path.WINDOWS && LocalFileSystem.class.isInstance(stagingPath.getFileSystem(conf))) {
                conf.set("yarn.app.mapreduce.am.staging-dir", new File(conf.get("yarn.app.mapreduce.am.staging-dir")).getAbsolutePath());
            }
            if ((fc = FileContext.getFileContext((URI)stagingPath.toUri(), (Configuration)conf)).util().exists(stagingPath)) {
                LOG.info(stagingPath + " exists! deleting...");
                fc.delete(stagingPath, true);
            }
            LOG.info("mkdir: " + stagingPath);
            fc.mkdir(stagingPath, null, true);
            String doneDir = JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)conf);
            Path doneDirPath = fc.makeQualified(new Path(doneDir));
            fc.mkdir(doneDirPath, null, true);
        }
        catch (IOException e) {
            throw new TezUncheckedException("Could not create staging directory. ", (Throwable)e);
        }
        conf.set("mapreduce.jobtracker.address", "test");
        conf.setStrings("yarn.nodemanager.aux-services", new String[]{"mapreduce_shuffle"});
        conf.setClass(String.format("yarn.nodemanager.aux-services.%s.class", "mapreduce_shuffle"), ShuffleHandler.class, Service.class);
        conf.setInt("mapreduce.shuffle.port", 0);
        conf.setClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class);
        conf.setBoolean("mapreduce.job.ubertask.enable", false);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        LOG.info("Starting MiniTezClusterWithTimeline");
        super.serviceStart();
        File workDir = super.getTestWorkDir();
        Configuration conf = super.getConfig();
        this.confFilePath = new Path(workDir.getAbsolutePath(), YARN_CLUSTER_CONFIG);
        File confFile = new File(this.confFilePath.toString());
        try {
            confFile.createNewFile();
            conf.writeXml((OutputStream)new FileOutputStream(confFile));
            confFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.confFilePath = new Path(confFile.getAbsolutePath());
        conf.setStrings("yarn.application.classpath", new String[]{workDir.getAbsolutePath(), System.getProperty("java.class.path")});
        LOG.info("Setting yarn-site.xml via YARN-APP-CP at: " + conf.get("yarn.application.classpath"));
    }

    protected void serviceStop() throws Exception {
        this.waitForAppsToFinish();
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAppsToFinish() {
        block11: {
            long waitStartTime = System.currentTimeMillis();
            long waitEndTime = this.maxTimeToWaitForAppsOnShutdown == -1L ? -1L : waitStartTime + 1000L * this.maxTimeToWaitForAppsOnShutdown;
            YarnClient yarnClient = YarnClient.createYarnClient();
            yarnClient.init(this.getConfig());
            yarnClient.start();
            Collection unCompletedApps = null;
            try {
                List appReports;
                while (!(unCompletedApps = Collections2.filter((Collection)(appReports = yarnClient.getApplications()), (Predicate)new Predicate<ApplicationReport>(){

                    public boolean apply(ApplicationReport appReport) {
                        return EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING).contains(appReport.getYarnApplicationState());
                    }
                })).isEmpty()) {
                    LOG.info("Waiting for applications to finish in MiniTezClusterWithTimeline, incompleteAppsCount=" + unCompletedApps.size());
                    Thread.sleep(1000L);
                    if (waitEndTime != -1L && waitEndTime > System.currentTimeMillis()) continue;
                }
                if (unCompletedApps == null || unCompletedApps.isEmpty()) break block11;
                LOG.info("Killing incomplete applications in MiniTezCluster, incompleteAppsCount=" + unCompletedApps.size());
                HashSet<ApplicationId> incompleteAppIds = new HashSet<ApplicationId>();
                for (ApplicationReport appReport : unCompletedApps) {
                    try {
                        LOG.info("Killing application, id=" + appReport.getApplicationId() + ", appName=" + appReport.getName());
                        yarnClient.killApplication(appReport.getApplicationId());
                        incompleteAppIds.add(appReport.getApplicationId());
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to kill app on MiniTezCluster shutdown, appId=" + appReport.getApplicationId() + ", appName=" + appReport.getName());
                    }
                }
                waitStartTime = System.currentTimeMillis();
                waitEndTime = this.maxTimeToWaitForAppsOnShutdown == -1L ? -1L : waitStartTime + 1000L * this.maxTimeToWaitForAppsOnShutdown;
                do {
                    Iterator iter = incompleteAppIds.iterator();
                    while (iter.hasNext()) {
                        ApplicationId applicationId = (ApplicationId)iter.next();
                        ApplicationReport report = yarnClient.getApplicationReport(applicationId);
                        if (!EnumSet.of(YarnApplicationState.FINISHED, YarnApplicationState.FAILED, YarnApplicationState.KILLED).contains(report.getYarnApplicationState())) continue;
                        iter.remove();
                        LOG.info("Application completed, id=" + report.getApplicationId() + ", yarnState=" + report.getYarnApplicationState());
                    }
                    if (!incompleteAppIds.isEmpty()) continue;
                    break;
                } while (waitEndTime != -1L && waitEndTime > System.currentTimeMillis());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                yarnClient.stop();
            }
        }
    }

    public Path getConfigFilePath() {
        return this.confFilePath;
    }
}

