/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.library.output.OutputTestHelpers;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnorderedKVOutput2 {
    private Configuration conf;
    private FileSystem localFs;
    private Path workingDir;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.localFs = FileSystem.getLocal((Configuration)this.conf);
        this.workingDir = new Path(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir", "/tmp")), TestUnorderedKVOutput2.class.getName()).makeQualified(this.localFs.getUri(), this.localFs.getWorkingDirectory());
        this.conf.set("tez.runtime.key.class", Text.class.getName());
        this.conf.set("tez.runtime.value.class", Text.class.getName());
        this.conf.set("tez.runtime.partitioner.class", HashPartitioner.class.getName());
        this.conf.setStrings("tez.runtime.framework.local.dirs", new String[]{this.workingDir.toString()});
    }

    @After
    public void cleanup() throws IOException {
        this.localFs.delete(this.workingDir, true);
    }

    @Test(timeout=5000L)
    public void testNonStartedOutput() throws Exception {
        OutputContext outputContext = OutputTestHelpers.createOutputContext();
        int numPartitions = 1;
        UnorderedKVOutput output = new UnorderedKVOutput(outputContext, numPartitions);
        output.initialize();
        List events = output.close();
        Assert.assertEquals((long)1L, (long)events.size());
        Event event1 = (Event)events.get(0);
        Assert.assertTrue((boolean)(event1 instanceof DataMovementEvent));
        DataMovementEvent dme = (DataMovementEvent)event1;
        ByteBuffer bb = dme.getUserPayload();
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)bb));
        Assert.assertTrue((boolean)shufflePayload.hasEmptyPartitions());
        byte[] emptyPartitions = TezCommonUtils.decompressByteStringToByteArray((ByteString)shufflePayload.getEmptyPartitions());
        BitSet emptyPartionsBitSet = TezUtilsInternal.fromByteArray((byte[])emptyPartitions);
        Assert.assertEquals((long)numPartitions, (long)emptyPartionsBitSet.cardinality());
        for (int i = 0; i < numPartitions; ++i) {
            Assert.assertTrue((boolean)emptyPartionsBitSet.get(i));
        }
    }

    @Test(timeout=10000L)
    public void testClose() throws Exception {
        OutputContext outputContext = OutputTestHelpers.createOutputContext(this.conf, this.workingDir);
        int numPartitions = 1;
        UnorderedKVOutput output = new UnorderedKVOutput(outputContext, numPartitions);
        output.initialize();
        output.start();
        Assert.assertNotNull((Object)output.getWriter());
        output.close();
        Assert.assertNull((Object)output.getWriter());
    }
}

