/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.UnorderedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestUnorderedKVOutputConfig {
    @Test(timeout=5000L)
    public void testNullParams() {
        try {
            UnorderedKVOutputConfig.newBuilder(null, (String)"VALUE");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedKVOutputConfig.newBuilder((String)"KEY", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test(timeout=5000L)
    public void testSetters() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.ifile.readahead.bytes", 1111);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("test.key.2", "key2");
        additionalConf.put("tez.runtime.unordered.output.max-per-buffer.size-bytes", "2222");
        additionalConf.put("file.shouldExist", "file");
        Configuration fromConfUnfiltered = new Configuration(false);
        fromConfUnfiltered.set("test.conf.unfiltered.1", "unfiltered1");
        UnorderedKVOutputConfig.Builder builder = UnorderedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE").setCompression(true, "CustomCodec", null).setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("tez.runtime.ifile.readahead", String.valueOf(false)).setAdditionalConfiguration(additionalConf).setFromConfiguration(fromConf).setFromConfigurationUnfiltered(fromConfUnfiltered);
        UnorderedKVOutputConfig configuration = builder.build();
        UnorderedKVOutputConfig rebuilt = new UnorderedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000));
        Assert.assertEquals((Object)"io", (Object)conf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)conf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)conf.get("fs.shouldExist"));
        Assert.assertNull((Object)conf.get("test.conf.key.1"));
        Assert.assertNull((Object)conf.get("test.key.1"));
        Assert.assertNull((Object)conf.get("test.key.2"));
        Assert.assertEquals((Object)"unfiltered1", (Object)conf.get("test.conf.unfiltered.1"));
    }

    @Test(timeout=5000L)
    public void testDefaultConfigsUsed() {
        UnorderedKVOutputConfig.Builder builder = UnorderedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE");
        UnorderedKVOutputConfig configuration = builder.build();
        UnorderedKVOutputConfig rebuilt = new UnorderedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
    }
}

