/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryReader;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryWriter;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.testutils.KVDataGen;
import org.apache.tez.runtime.library.utils.BufferUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestIFile.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir = null;
    private static CompressionCodec codec;
    private Random rnd = new Random();
    private String outputFileName = "ifile.out";
    private Path outputPath;
    private DataOutputBuffer k = new DataOutputBuffer();
    private DataOutputBuffer v = new DataOutputBuffer();

    @Before
    public void setUp() throws Exception {
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(new Configuration());
        codec = codecFactory.getCodecByClassName("org.apache.hadoop.io.compress.DefaultCodec");
        this.outputPath = new Path(workDir, this.outputFileName);
    }

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test(timeout=5000L)
    public void testWithEmptyIFile() throws IOException {
        this.testWriterAndReader(new LinkedList<KVDataGen.KVPair>());
        this.testWithDataBuffer(new LinkedList<KVDataGen.KVPair>());
    }

    @Test(timeout=5000L)
    public void testCompressedFlag() throws IOException {
        byte[] HEADER = new byte[]{84, 73, 70, 1};
        ByteArrayInputStream bin = new ByteArrayInputStream(HEADER);
        boolean compressed = IFile.Reader.isCompressedFlagEnabled((InputStream)bin);
        assert (compressed);
        HEADER = new byte[]{84, 73};
        bin = new ByteArrayInputStream(HEADER);
        try {
            compressed = IFile.Reader.isCompressedFlagEnabled((InputStream)bin);
            Assert.fail((String)"Should not have allowed wrong header");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=5000L)
    public void testWritingEmptyKeyValues() throws IOException {
        DataInputBuffer key = new DataInputBuffer();
        DataInputBuffer value = new DataInputBuffer();
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, this.outputPath, null, null, null, null, null);
        writer.append(key, value);
        writer.append(key, value);
        writer.append(key, value);
        writer.append(key, value);
        writer.close();
        IFile.Reader reader = new IFile.Reader(localFs, this.outputPath, null, null, null, false, -1, 1024);
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        int records = 0;
        while (reader.nextRawKey(keyIn)) {
            reader.nextRawValue(valIn);
            ++records;
            assert (keyIn.getLength() == 0);
            assert (valIn.getLength() == 0);
        }
        Assert.assertTrue((String)"Number of records read does not match", (records == 4 ? 1 : 0) != 0);
        reader.close();
    }

    @Test(timeout=5000L)
    public void testWithUnsortedData() throws IOException {
        List<KVDataGen.KVPair> unsortedData = KVDataGen.generateTestData(false, this.rnd.nextInt(100));
        this.testWriterAndReader(unsortedData);
        this.testWithDataBuffer(unsortedData);
    }

    @Test(timeout=5000L)
    public void testWithSortedData() throws IOException {
        List<KVDataGen.KVPair> sortedData = KVDataGen.generateTestData(true, this.rnd.nextInt(100));
        this.testWriterAndReader(sortedData);
        this.testWithDataBuffer(sortedData);
    }

    @Test(timeout=5000L)
    public void testExceedMaxSize() throws IOException {
        int oldMaxBufferSize = IFile.Reader.MAX_BUFFER_SIZE;
        Text shortString = new Text("string");
        Text longString = new Text("A string of length 22.");
        Assert.assertEquals((long)22L, (long)longString.getLength());
        Text readKey = new Text();
        Text readValue = new Text();
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        FSDataOutputStream out = localFs.create(this.outputPath);
        IFile.Writer writer = new IFile.Writer(defaultConf, out, Text.class, Text.class, null, null, null, false);
        writer.append((Object)longString, (Object)shortString);
        writer.close();
        out.close();
        IFile.Reader.MAX_BUFFER_SIZE = 16;
        IFile.Reader reader = new IFile.Reader(localFs, this.outputPath, null, null, null, false, 0, -1);
        try {
            reader.nextRawKey(keyIn);
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        reader.close();
        out = localFs.create(this.outputPath);
        writer = new IFile.Writer(defaultConf, out, Text.class, Text.class, null, null, null, false);
        writer.append((Object)shortString, (Object)longString);
        writer.close();
        out.close();
        IFile.Reader.MAX_BUFFER_SIZE = 16;
        reader = new IFile.Reader(localFs, this.outputPath, null, null, null, false, 0, -1);
        try {
            reader.nextRawKey(keyIn);
            reader.nextRawValue(valIn);
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        reader.close();
        out = localFs.create(this.outputPath);
        writer = new IFile.Writer(defaultConf, out, Text.class, Text.class, null, null, null, false);
        writer.append((Object)longString, (Object)shortString);
        writer.close();
        out.close();
        IFile.Reader.MAX_BUFFER_SIZE = 32;
        reader = new IFile.Reader(localFs, this.outputPath, null, null, null, false, 0, -1);
        reader.nextRawKey(keyIn);
        Assert.assertEquals((long)(longString.getLength() + 1), (long)keyIn.getData().length);
        reader.close();
        out = localFs.create(this.outputPath);
        writer = new IFile.Writer(defaultConf, out, Text.class, Text.class, null, null, null, false);
        writer.append((Object)shortString, (Object)longString);
        writer.close();
        out.close();
        IFile.Reader.MAX_BUFFER_SIZE = 32;
        reader = new IFile.Reader(localFs, this.outputPath, null, null, null, false, 0, -1);
        reader.nextRawKey(keyIn);
        reader.nextRawValue(valIn);
        Assert.assertEquals((long)(longString.getLength() + 1), (long)valIn.getData().length);
        reader.close();
        IFile.Reader.MAX_BUFFER_SIZE = oldMaxBufferSize;
    }

    @Test(timeout=5000L)
    public void testWithRLEMarker() throws IOException {
        FSDataOutputStream out = localFs.create(this.outputPath);
        IFile.Writer writer = new IFile.Writer(defaultConf, out, Text.class, IntWritable.class, codec, null, null, true);
        Text key = new Text("key0");
        IntWritable value = new IntWritable(0);
        writer.append((Object)key, (Object)value);
        key = new Text("key0");
        writer.append((Object)key, (Object)value);
        Assert.assertTrue((boolean)writer.sameKey);
        key = new Text("key1");
        writer.append((Object)key, (Object)value);
        Assert.assertFalse((boolean)writer.sameKey);
        writer.close();
        out.close();
        byte[] kvbuffer = "key1Value1key1Value2key3Value3".getBytes();
        int keyLength = 4;
        int valueLength = 6;
        int pos = 0;
        out = localFs.create(this.outputPath);
        writer = new IFile.Writer(defaultConf, out, Text.class, IntWritable.class, codec, null, null, true);
        BoundedByteArrayOutputStream boundedOut = new BoundedByteArrayOutputStream(0x100000);
        InMemoryWriter inMemWriter = new InMemoryWriter(boundedOut, true);
        DataInputBuffer kin = new DataInputBuffer();
        kin.reset(kvbuffer, pos, keyLength);
        DataInputBuffer vin = new DataInputBuffer();
        DataOutputBuffer vout = new DataOutputBuffer();
        new IntWritable(0).write((DataOutput)vout);
        vin.reset(vout.getData(), vout.getLength());
        writer.append(kin, vin);
        Assert.assertFalse((boolean)writer.sameKey);
        inMemWriter.append(kin, vin);
        Assert.assertFalse((boolean)inMemWriter.sameKey);
        kin.reset(kvbuffer, pos += keyLength + valueLength, keyLength);
        new IntWritable(0).write((DataOutput)vout);
        vin.reset(vout.getData(), vout.getLength());
        writer.append(kin, vin);
        Assert.assertTrue((boolean)writer.sameKey);
        inMemWriter.append(kin, vin);
        Assert.assertTrue((boolean)inMemWriter.sameKey);
        kin.reset(kvbuffer, pos += keyLength + valueLength, keyLength);
        new IntWritable(0).write((DataOutput)vout);
        vin.reset(vout.getData(), vout.getLength());
        writer.append(kin, vin);
        Assert.assertFalse((boolean)writer.sameKey);
        inMemWriter.append(kin, vin);
        Assert.assertFalse((boolean)inMemWriter.sameKey);
        writer.close();
        out.close();
        inMemWriter.close();
        boundedOut.close();
    }

    @Test(timeout=5000L)
    public void testWithUniqueKeys() throws IOException {
        List<KVDataGen.KVPair> sortedData = KVDataGen.generateTestData(true, 0);
        this.testWriterAndReader(sortedData);
        this.testWithDataBuffer(sortedData);
    }

    @Test(timeout=5000L)
    public void testConcatenatedZlibPadding() throws IOException, URISyntaxException {
        long compTotal = 0L;
        long[] raws = new long[]{2392L, 102314L, 42576L, 31432L, 25090L};
        long[] compressed = new long[]{723L, 25396L, 10926L, 8203L, 6665L};
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(new Configuration());
        codec = codecFactory.getCodecByClassName("org.apache.hadoop.io.compress.DefaultCodec");
        URL url = this.getClass().getClassLoader().getResource("TestIFile_concatenated_compressed.bin");
        Assert.assertNotEquals((String)"IFileinput file must exist", null, (Object)url);
        Path p = new Path(url.toURI());
        FSDataInputStream inStream = localFs.open(p);
        for (int i = 0; i < 5; ++i) {
            byte[] bytes = new byte[(int)raws[i]];
            Assert.assertEquals((String)"Compressed stream out-of-sync", (long)inStream.getPos(), (long)compTotal);
            IFile.Reader.readToMemory((byte[])bytes, (InputStream)inStream, (int)((int)compressed[i]), (CompressionCodec)codec, (boolean)false, (int)-1);
            compTotal += compressed[i];
            InMemoryReader inMemReader = new InMemoryReader(null, new InputAttemptIdentifier(0, 0), bytes, 0, bytes.length);
            DataInputBuffer keyIn = new DataInputBuffer();
            DataInputBuffer valIn = new DataInputBuffer();
            SerializationFactory serializationFactory = new SerializationFactory(defaultConf);
            Deserializer keyDeserializer = serializationFactory.getDeserializer(Text.class);
            Deserializer valDeserializer = serializationFactory.getDeserializer(IntWritable.class);
            keyDeserializer.open((InputStream)keyIn);
            valDeserializer.open((InputStream)valIn);
            while (inMemReader.nextRawKey(keyIn)) {
                inMemReader.nextRawValue(valIn);
            }
        }
        inStream.close();
    }

    @Test(timeout=5000L)
    public void testInMemoryWriter() throws IOException {
        InMemoryWriter writer = null;
        BoundedByteArrayOutputStream bout = new BoundedByteArrayOutputStream(0x100000);
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true, 10);
        writer = new InMemoryWriter(bout);
        this.writeTestFileUsingDataBuffer((IFile.Writer)writer, false, data);
        this.readUsingInMemoryReader(bout.getBuffer(), data);
        bout.reset();
        writer = new InMemoryWriter(bout);
        this.writeTestFileUsingDataBuffer((IFile.Writer)writer, true, data);
        this.readUsingInMemoryReader(bout.getBuffer(), data);
        bout.reset();
        writer = new InMemoryWriter(bout, true);
        this.writeTestFileUsingDataBuffer((IFile.Writer)writer, false, data);
        this.readUsingInMemoryReader(bout.getBuffer(), data);
        bout.reset();
        writer = new InMemoryWriter(bout, true);
        this.writeTestFileUsingDataBuffer((IFile.Writer)writer, true, data);
        this.readUsingInMemoryReader(bout.getBuffer(), data);
    }

    @Test(timeout=5000L)
    public void testAppendValue() throws IOException {
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(false, this.rnd.nextInt(100));
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, this.outputPath, Text.class, IntWritable.class, codec, null, null);
        Text previousKey = null;
        for (KVDataGen.KVPair kvp : data) {
            if (previousKey != null && previousKey.compareTo((BinaryComparable)kvp.getKey()) == 0) {
                writer.appendValue((Object)kvp.getvalue());
            } else {
                writer.append((Object)kvp.getKey(), (Object)kvp.getvalue());
            }
            previousKey = kvp.getKey();
        }
        writer.close();
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    @Test(timeout=5000L)
    public void testAppendValues() throws IOException {
        ArrayList<KVDataGen.KVPair> data = new ArrayList<KVDataGen.KVPair>();
        ArrayList<IntWritable> values = new ArrayList<IntWritable>();
        Text key = new Text("key");
        IntWritable val = new IntWritable(1);
        for (int i = 0; i < 5; ++i) {
            data.add(new KVDataGen.KVPair(key, val));
            values.add(val);
        }
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, this.outputPath, Text.class, IntWritable.class, codec, null, null);
        writer.append((Object)((KVDataGen.KVPair)data.get(0)).getKey(), (Object)((KVDataGen.KVPair)data.get(0)).getvalue());
        writer.appendValues(values.subList(1, values.size()).iterator());
        Text lastKey = new Text("key3");
        IntWritable lastVal = new IntWritable(10);
        data.add(new KVDataGen.KVPair(lastKey, lastVal));
        writer.append((Object)lastKey, (Object)lastVal);
        writer.close();
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    @Test(timeout=5000L)
    public void testAppendKeyValues() throws IOException {
        ArrayList<KVDataGen.KVPair> data = new ArrayList<KVDataGen.KVPair>();
        ArrayList<IntWritable> values = new ArrayList<IntWritable>();
        Text key = new Text("key");
        IntWritable val = new IntWritable(1);
        for (int i = 0; i < 5; ++i) {
            data.add(new KVDataGen.KVPair(key, val));
            values.add(val);
        }
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, this.outputPath, Text.class, IntWritable.class, codec, null, null);
        writer.appendKeyValues((Object)((KVDataGen.KVPair)data.get(0)).getKey(), values.iterator());
        Text lastKey = new Text("key3");
        IntWritable lastVal = new IntWritable(10);
        data.add(new KVDataGen.KVPair(lastKey, lastVal));
        writer.append((Object)lastKey, (Object)lastVal);
        writer.close();
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    @Test(timeout=5000L)
    public void testAppendValueWithDataInputBuffer() throws IOException {
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(false, this.rnd.nextInt(100));
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, this.outputPath, Text.class, IntWritable.class, codec, null, null);
        DataInputBuffer previousKey = new DataInputBuffer();
        DataInputBuffer key = new DataInputBuffer();
        DataInputBuffer value = new DataInputBuffer();
        for (KVDataGen.KVPair kvp : data) {
            this.populateData(kvp, key, value);
            if (previousKey != null && BufferUtils.compare((DataInputBuffer)key, (DataInputBuffer)previousKey) == 0) {
                writer.appendValue(value);
            } else {
                writer.append(key, value);
            }
            previousKey.reset(this.k.getData(), 0, this.k.getLength());
        }
        writer.close();
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    @Test(timeout=20000L)
    public void testReadToDisk() throws IOException {
        byte[] zeroData = new byte[1000];
        Arrays.fill(zeroData, (byte)0);
        ByteArrayInputStream in = new ByteArrayInputStream(zeroData);
        try {
            IFile.Reader.readToDisk((OutputStream)new ByteArrayOutputStream(), (InputStream)in, (long)zeroData.length, (boolean)false, (int)0);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(IFile.HEADER);
        baos.write(zeroData);
        try {
            IFile.Reader.readToDisk((OutputStream)new ByteArrayOutputStream(), (InputStream)new ByteArrayInputStream(baos.toByteArray()), (long)zeroData.length, (boolean)false, (int)0);
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof ChecksumException));
        }
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true, 0);
        IFile.Writer writer = this.writeTestFile(false, false, data, codec);
        baos.reset();
        IFile.Reader.readToDisk((OutputStream)baos, (InputStream)localFs.open(this.outputPath), (long)writer.getCompressedLength(), (boolean)false, (int)0);
        byte[] diskData = baos.toByteArray();
        IFile.Reader reader = new IFile.Reader((InputStream)new ByteArrayInputStream(diskData), (long)diskData.length, codec, null, null, false, 0, 1024);
        this.verifyData(reader, data);
        reader.close();
    }

    private void testWriterAndReader(List<KVDataGen.KVPair> data) throws IOException {
        IFile.Writer writer = null;
        writer = this.writeTestFile(false, false, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFile(false, false, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFile(false, true, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFile(false, true, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFile(true, false, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFile(true, false, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFile(true, true, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFile(true, true, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    private void testWithDataBuffer(List<KVDataGen.KVPair> data) throws IOException {
        IFile.Writer writer = null;
        writer = this.writeTestFileUsingDataBuffer(false, false, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFileUsingDataBuffer(false, false, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFileUsingDataBuffer(false, true, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFileUsingDataBuffer(false, true, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFileUsingDataBuffer(true, false, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFileUsingDataBuffer(true, false, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
        writer = this.writeTestFileUsingDataBuffer(true, true, data, null);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, null);
        writer = this.writeTestFileUsingDataBuffer(true, true, data, codec);
        this.readAndVerifyData(writer.getRawLength(), writer.getCompressedLength(), data, codec);
    }

    private void readAndVerifyData(long rawLength, long compressedLength, List<KVDataGen.KVPair> originalData, CompressionCodec codec) throws IOException {
        this.readFileUsingInMemoryReader(rawLength, compressedLength, originalData);
        this.readUsingIFileReader(originalData, codec);
    }

    private void readFileUsingInMemoryReader(long rawLength, long compressedLength, List<KVDataGen.KVPair> originalData) throws IOException {
        LOG.info("Read using in memory reader");
        FSDataInputStream inStream = localFs.open(this.outputPath);
        byte[] bytes = new byte[(int)rawLength];
        IFile.Reader.readToMemory((byte[])bytes, (InputStream)inStream, (int)((int)compressedLength), (CompressionCodec)codec, (boolean)false, (int)-1);
        inStream.close();
        this.readUsingInMemoryReader(bytes, originalData);
    }

    private void readUsingInMemoryReader(byte[] bytes, List<KVDataGen.KVPair> originalData) throws IOException {
        InMemoryReader inMemReader = new InMemoryReader(null, new InputAttemptIdentifier(0, 0), bytes, 0, bytes.length);
        this.verifyData((IFile.Reader)inMemReader, originalData);
    }

    private void readUsingIFileReader(List<KVDataGen.KVPair> originalData, CompressionCodec codec) throws IOException {
        LOG.info("Read using IFile reader");
        IFile.Reader reader = new IFile.Reader(localFs, this.outputPath, codec, null, null, false, 0, -1);
        this.verifyData(reader, originalData);
        reader.close();
    }

    private void verifyData(IFile.Reader reader, List<KVDataGen.KVPair> data) throws IOException {
        LOG.info("Data verification");
        Text readKey = new Text();
        IntWritable readValue = new IntWritable();
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        SerializationFactory serializationFactory = new SerializationFactory(defaultConf);
        Deserializer keyDeserializer = serializationFactory.getDeserializer(Text.class);
        Deserializer valDeserializer = serializationFactory.getDeserializer(IntWritable.class);
        keyDeserializer.open((InputStream)keyIn);
        valDeserializer.open((InputStream)valIn);
        int numRecordsRead = 0;
        while (reader.nextRawKey(keyIn)) {
            reader.nextRawValue(valIn);
            readKey = (Text)keyDeserializer.deserialize((Object)readKey);
            readValue = (IntWritable)valDeserializer.deserialize((Object)readValue);
            KVDataGen.KVPair expected = data.get(numRecordsRead);
            Assert.assertEquals((String)("Key does not match: Expected: " + expected.getKey() + ", Read: " + readKey), (Object)expected.getKey(), (Object)readKey);
            Assert.assertEquals((String)("Value does not match: Expected: " + expected.getvalue() + ", Read: " + readValue), (Object)expected.getvalue(), (Object)readValue);
            ++numRecordsRead;
        }
        Assert.assertEquals((String)("Expected: " + data.size() + " records, but found: " + numRecordsRead), (long)data.size(), (long)numRecordsRead);
        LOG.info("Found: " + numRecordsRead + " records");
    }

    private IFile.Writer writeTestFile(boolean rle, boolean repeatKeys, List<KVDataGen.KVPair> data, CompressionCodec codec) throws IOException {
        FSDataOutputStream out = localFs.create(this.outputPath);
        IFile.Writer writer = new IFile.Writer(defaultConf, out, Text.class, IntWritable.class, codec, null, null, rle);
        this.writeTestFile(writer, repeatKeys, data);
        out.close();
        return writer;
    }

    private IFile.Writer writeTestFile(IFile.Writer writer, boolean repeatKeys, List<KVDataGen.KVPair> data) throws IOException {
        Assert.assertNotNull((Object)writer);
        Text previousKey = null;
        for (KVDataGen.KVPair kvp : data) {
            if (repeatKeys && previousKey != null && previousKey.compareTo((BinaryComparable)kvp.getKey()) == 0) {
                writer.append((Object)IFile.REPEAT_KEY, (Object)kvp.getvalue());
            } else {
                writer.append((Object)kvp.getKey(), (Object)kvp.getvalue());
            }
            previousKey = kvp.getKey();
        }
        writer.close();
        LOG.info("Uncompressed: " + writer.getRawLength());
        LOG.info("CompressedSize: " + writer.getCompressedLength());
        return writer;
    }

    private IFile.Writer writeTestFileUsingDataBuffer(boolean rle, boolean repeatKeys, List<KVDataGen.KVPair> data, CompressionCodec codec) throws IOException {
        FSDataOutputStream out = localFs.create(this.outputPath);
        IFile.Writer writer = new IFile.Writer(defaultConf, out, Text.class, IntWritable.class, codec, null, null, rle);
        this.writeTestFileUsingDataBuffer(writer, repeatKeys, data);
        out.close();
        return writer;
    }

    private IFile.Writer writeTestFileUsingDataBuffer(IFile.Writer writer, boolean repeatKeys, List<KVDataGen.KVPair> data) throws IOException {
        DataInputBuffer previousKey = new DataInputBuffer();
        DataInputBuffer key = new DataInputBuffer();
        DataInputBuffer value = new DataInputBuffer();
        for (KVDataGen.KVPair kvp : data) {
            this.populateData(kvp, key, value);
            if (repeatKeys && previousKey != null && BufferUtils.compare((DataInputBuffer)key, (DataInputBuffer)previousKey) == 0) {
                writer.append(IFile.REPEAT_KEY, value);
            } else {
                writer.append(key, value);
            }
            previousKey.reset(key.getData(), 0, key.getLength());
        }
        writer.close();
        LOG.info("Uncompressed: " + writer.getRawLength());
        LOG.info("CompressedSize: " + writer.getCompressedLength());
        return writer;
    }

    private void populateData(KVDataGen.KVPair kvp, DataInputBuffer key, DataInputBuffer value) throws IOException {
        DataOutputBuffer k = new DataOutputBuffer();
        DataOutputBuffer v = new DataOutputBuffer();
        kvp.getKey().write((DataOutput)k);
        kvp.getvalue().write((DataOutput)v);
        key.reset(k.getData(), 0, k.getLength());
        value.reset(v.getData(), 0, v.getLength());
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestIFile.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            LOG.info("Using workDir: " + workDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

