/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import org.apache.tez.runtime.library.utils.Grouper;
import org.junit.Assert;
import org.junit.Test;

public class TestGrouper {
    private Grouper grouper = new Grouper();

    @Test(timeout=5000L)
    public void testEvenlyGrouping() {
        this.grouper.init(4, 2);
        Assert.assertEquals((long)0L, (long)this.grouper.getFirstItemInGroup(0));
        Assert.assertEquals((long)2L, (long)this.grouper.getFirstItemInGroup(1));
        Assert.assertEquals((long)2L, (long)this.grouper.getNumItemsInGroup(0));
        Assert.assertEquals((long)2L, (long)this.grouper.getNumItemsInGroup(1));
        Assert.assertEquals((long)1L, (long)this.grouper.getLastItemInGroup(0));
        Assert.assertEquals((long)3L, (long)this.grouper.getLastItemInGroup(1));
        Assert.assertEquals((long)0L, (long)this.grouper.getGroupId(1));
        Assert.assertEquals((long)1L, (long)this.grouper.getGroupId(2));
        Assert.assertTrue((boolean)this.grouper.isInGroup(2, 1));
        Assert.assertFalse((boolean)this.grouper.isInGroup(2, 0));
    }

    @Test(timeout=5000L)
    public void testUnevenlyGrouping() {
        this.grouper.init(5, 2);
        Assert.assertEquals((long)0L, (long)this.grouper.getFirstItemInGroup(0));
        Assert.assertEquals((long)2L, (long)this.grouper.getFirstItemInGroup(1));
        Assert.assertEquals((long)2L, (long)this.grouper.getNumItemsInGroup(0));
        Assert.assertEquals((long)3L, (long)this.grouper.getNumItemsInGroup(1));
        Assert.assertEquals((long)1L, (long)this.grouper.getLastItemInGroup(0));
        Assert.assertEquals((long)4L, (long)this.grouper.getLastItemInGroup(1));
        Assert.assertEquals((long)0L, (long)this.grouper.getGroupId(1));
        Assert.assertEquals((long)1L, (long)this.grouper.getGroupId(3));
        Assert.assertTrue((boolean)this.grouper.isInGroup(3, 1));
        Assert.assertFalse((boolean)this.grouper.isInGroup(3, 0));
    }

    @Test(timeout=5000L)
    public void testSingleGroup() {
        this.grouper.init(4, 1);
        Assert.assertEquals((long)0L, (long)this.grouper.getFirstItemInGroup(0));
        Assert.assertEquals((long)4L, (long)this.grouper.getNumItemsInGroup(0));
        Assert.assertEquals((long)3L, (long)this.grouper.getLastItemInGroup(0));
        Assert.assertEquals((long)0L, (long)this.grouper.getGroupId(0));
        Assert.assertEquals((long)0L, (long)this.grouper.getGroupId(3));
        Assert.assertTrue((boolean)this.grouper.isInGroup(3, 0));
    }

    @Test(timeout=5000L)
    public void testNoGrouping() {
        this.grouper.init(2, 2);
        Assert.assertEquals((long)0L, (long)this.grouper.getFirstItemInGroup(0));
        Assert.assertEquals((long)1L, (long)this.grouper.getNumItemsInGroup(0));
        Assert.assertEquals((long)0L, (long)this.grouper.getLastItemInGroup(0));
        Assert.assertEquals((long)0L, (long)this.grouper.getGroupId(0));
        Assert.assertTrue((boolean)this.grouper.isInGroup(0, 0));
    }
}

