/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.library.output.OutputTestHelpers;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.Assert;
import org.junit.Test;

public class TestUnorderedPartitionedKVOutput2 {
    @Test(timeout=5000L)
    public void testNonStartedOutput() throws Exception {
        OutputContext outputContext = OutputTestHelpers.createOutputContext();
        int numPartitions = 1;
        UnorderedPartitionedKVOutput output = new UnorderedPartitionedKVOutput(outputContext, numPartitions);
        output.initialize();
        List events = output.close();
        Assert.assertEquals((long)1L, (long)events.size());
        Event event1 = (Event)events.get(0);
        Assert.assertTrue((boolean)(event1 instanceof CompositeDataMovementEvent));
        CompositeDataMovementEvent dme = (CompositeDataMovementEvent)event1;
        ByteBuffer bb = dme.getUserPayload();
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)bb));
        Assert.assertTrue((boolean)shufflePayload.hasEmptyPartitions());
        byte[] emptyPartitions = TezCommonUtils.decompressByteStringToByteArray((ByteString)shufflePayload.getEmptyPartitions());
        BitSet emptyPartionsBitSet = TezUtilsInternal.fromByteArray((byte[])emptyPartitions);
        Assert.assertEquals((long)numPartitions, (long)emptyPartionsBitSet.cardinality());
        for (int i = 0; i < numPartitions; ++i) {
            Assert.assertTrue((boolean)emptyPartionsBitSet.get(i));
        }
    }
}

