/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.io.RawComparator;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValueInput;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValuesInput;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.input.OrderedGroupedMergedKVInput;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSortedGroupedMergedInput {
    MergedInputContext createMergedInputContext() {
        return (MergedInputContext)Mockito.mock(MergedInputContext.class);
    }

    @Test(timeout=5000L)
    public void testSimple() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        MergedInputContext mockContext = this.createMergedInputContext();
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(mockContext, sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)(++keyCount), (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                ++valCount;
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
            }
            Assert.assertEquals((long)6L, (long)valCount);
        }
        ((MergedInputContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)4))).notifyProgress();
        this.getNextFromFinishedReader(kvsReader);
    }

    private void getNextFromFinishedReader(KeyValuesReader kvsReader) {
        try {
            boolean hasNext = kvsReader.next();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("For usage, please refer to"));
        }
    }

    @Test(timeout=5000L)
    public void testSkippedKey() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            if (++keyCount == 2) continue;
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)keyCount, (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                ++valCount;
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
            }
            Assert.assertEquals((long)6L, (long)valCount);
        }
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testPartialValuesSkip() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)(++keyCount), (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext() && (keyCount != 2 || ++valCount != 3)) {
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
            }
            if (keyCount == 2) {
                Assert.assertEquals((long)3L, (long)valCount);
                continue;
            }
            Assert.assertEquals((long)6L, (long)valCount);
        }
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testOrdering() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{2, 4}, new int[][]{{2, 2}, {4, 4}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{4, 5, 6, 7}, new int[][]{{4, 4}, {5, 5}, {6, 6}, {7, 7}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)(++keyCount), (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                ++valCount;
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
            }
            if (keyCount == 1) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            if (keyCount == 2) {
                Assert.assertEquals((long)4L, (long)valCount);
                continue;
            }
            if (keyCount == 3) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            if (keyCount == 4) {
                Assert.assertEquals((long)4L, (long)valCount);
                continue;
            }
            if (keyCount == 5 || keyCount == 6 || keyCount == 7) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            Assert.fail((String)"Unexpected key");
        }
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testSkippedKey2() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{2, 4}, new int[][]{{2, 2}, {4, 4}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{4, 5, 6, 7}, new int[][]{{4, 4}, {5, 5}, {6, 6}, {7, 7}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            if (++keyCount == 4) continue;
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)keyCount, (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                ++valCount;
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
            }
            if (keyCount == 1) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            if (keyCount == 2) {
                Assert.assertEquals((long)4L, (long)valCount);
                continue;
            }
            if (keyCount == 3) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            if (keyCount == 4) {
                Assert.fail((String)"Key 4 should have been skipped");
                continue;
            }
            if (keyCount == 5 || keyCount == 6 || keyCount == 7) {
                Assert.assertEquals((long)2L, (long)valCount);
                continue;
            }
            Assert.fail((String)"Unexpected key");
        }
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testSkippedKey3() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{1, 2, 3, 4}, new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3, 4}, new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{1, 2, 3, 4}, new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            if (++keyCount == 2 || keyCount == 3) continue;
            Integer key = (Integer)kvsReader.getCurrentKey();
            Assert.assertEquals((Object)keyCount, (Object)key);
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                Integer val = (Integer)valuesIter.next();
                Assert.assertEquals((Object)keyCount, (Object)val);
                if (keyCount != 1 || ++valCount != 6) continue;
                break;
            }
            Assert.assertEquals((long)6L, (long)valCount);
        }
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testEmptySources() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[0], new int[0][]);
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[0], new int[0][]);
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[0], new int[0][]);
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        OrderedGroupedMergedKVInput input = new OrderedGroupedMergedKVInput(this.createMergedInputContext(), sInputs);
        KeyValuesReader kvsReader = input.getReader();
        Assert.assertTrue((!kvsReader.next() ? 1 : 0) != 0);
        this.getNextFromFinishedReader(kvsReader);
    }

    @Test(timeout=5000L)
    public void testSimpleConcatenatedMergedKeyValueInput() throws Exception {
        DummyInput sInput1 = new DummyInput(10);
        DummyInput sInput2 = new DummyInput(10);
        DummyInput sInput3 = new DummyInput(10);
        LinkedList<DummyInput> sInputs = new LinkedList<DummyInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        MergedInputContext mockContext = this.createMergedInputContext();
        ConcatenatedMergedKeyValueInput input = new ConcatenatedMergedKeyValueInput(mockContext, sInputs);
        KeyValueReader kvReader = input.getReader();
        int keyCount = 0;
        while (kvReader.next()) {
            ++keyCount;
            Integer key = (Integer)kvReader.getCurrentKey();
            Integer value = (Integer)kvReader.getCurrentValue();
        }
        Assert.assertTrue((keyCount == 30 ? 1 : 0) != 0);
        ((MergedInputContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)4))).notifyProgress();
        this.getNextFromFinishedReader(kvReader);
    }

    @Test(timeout=5000L)
    public void testSimpleConcatenatedMergedKeyValuesInput() throws Exception {
        SortedTestKeyValuesReader kvsReader1 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader2 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestKeyValuesReader kvsReader3 = new SortedTestKeyValuesReader(new int[]{1, 2, 3}, new int[][]{{1, 1}, {2, 2}, {3, 3}});
        SortedTestInput sInput1 = new SortedTestInput(kvsReader1);
        SortedTestInput sInput2 = new SortedTestInput(kvsReader2);
        SortedTestInput sInput3 = new SortedTestInput(kvsReader3);
        LinkedList<SortedTestInput> sInputs = new LinkedList<SortedTestInput>();
        sInputs.add(sInput1);
        sInputs.add(sInput2);
        sInputs.add(sInput3);
        MergedInputContext mockContext = this.createMergedInputContext();
        ConcatenatedMergedKeyValuesInput input = new ConcatenatedMergedKeyValuesInput(mockContext, sInputs);
        KeyValuesReader kvsReader = input.getReader();
        int keyCount = 0;
        while (kvsReader.next()) {
            ++keyCount;
            Integer key = (Integer)kvsReader.getCurrentKey();
            Iterator valuesIter = kvsReader.getCurrentValues().iterator();
            int valCount = 0;
            while (valuesIter.hasNext()) {
                ++valCount;
                Integer val = (Integer)valuesIter.next();
            }
            Assert.assertEquals((long)2L, (long)valCount);
        }
        Assert.assertEquals((long)9L, (long)keyCount);
        ((MergedInputContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)4))).notifyProgress();
        this.getNextFromFinishedReader(kvsReader);
    }

    private void getNextFromFinishedReader(KeyValueReader kvReader) {
        try {
            boolean hasNext = kvReader.next();
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("For usage, please refer to"));
        }
    }

    private static class RawComparatorForTest
    implements RawComparator<Integer> {
        private RawComparatorForTest() {
        }

        public int compare(Integer o1, Integer o2) {
            return o1 - o2;
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummyKeyValueReader
    extends KeyValueReader {
        private int records;

        public DummyKeyValueReader(int records) {
            this.records = records;
        }

        public boolean next() throws IOException {
            return this.records-- > 0;
        }

        public Object getCurrentKey() throws IOException {
            return this.records;
        }

        public Object getCurrentValue() throws IOException {
            return this.records;
        }
    }

    private static class DummyInput
    implements Input {
        DummyKeyValueReader reader;

        public DummyInput(int records) {
            this.reader = new DummyKeyValueReader(records);
        }

        public void start() throws Exception {
        }

        public Reader getReader() throws Exception {
            return this.reader;
        }
    }

    private static class SortedTestKeyValuesReader
    extends KeyValuesReader {
        final int[] keys;
        final int[][] values;
        int currentIndex = -1;

        SortedTestKeyValuesReader(int[] keys, int[][] vals) {
            this.keys = keys;
            this.values = vals;
        }

        public boolean next() throws IOException {
            this.hasCompletedProcessing();
            ++this.currentIndex;
            if (this.keys == null || this.currentIndex >= this.keys.length) {
                this.completedProcessing = true;
                return false;
            }
            return true;
        }

        public Object getCurrentKey() throws IOException {
            return this.keys[this.currentIndex];
        }

        public Iterable<Object> getCurrentValues() throws IOException {
            LinkedList<Object> ints = new LinkedList<Object>();
            for (int i = 0; i < this.values[this.currentIndex].length; ++i) {
                ints.add(this.values[this.currentIndex][i]);
            }
            return ints;
        }
    }

    private static class SortedTestInput
    extends OrderedGroupedKVInput {
        final SortedTestKeyValuesReader reader;

        SortedTestInput(SortedTestKeyValuesReader reader) {
            super(null, 0);
            this.reader = reader;
        }

        public List<Event> initialize() throws IOException {
            return null;
        }

        public void start() throws IOException {
        }

        public KeyValuesReader getReader() throws IOException {
            return this.reader;
        }

        public void handleEvents(List<Event> inputEvents) {
        }

        public List<Event> close() throws IOException {
            return null;
        }

        public RawComparator getInputKeyComparator() {
            return new RawComparatorForTest();
        }
    }
}

