/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.Shuffle;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestOrderedGroupedKVInput {
    @Test(timeout=5000L)
    public void testInterruptWhileAwaitingInput() throws IOException, TezException {
        InputContext inputContext = this.createMockInputContext();
        OrderedGroupedKVInputForTest kvInput = new OrderedGroupedKVInputForTest(inputContext, 10);
        kvInput.initialize();
        kvInput.start();
        try {
            kvInput.getReader();
            Assert.fail((String)"getReader should not return since underlying inputs are not ready");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)(e instanceof IOInterruptedException));
        }
    }

    private InputContext createMockInputContext() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        TezConfiguration conf = new TezConfiguration();
        UserPayload payLoad = TezUtils.createUserPayloadFromConf((Configuration)conf);
        String[] workingDirs = new String[]{"workDir1"};
        TezCounters counters = new TezCounters();
        ((InputContext)Mockito.doReturn((Object)payLoad).when((Object)inputContext)).getUserPayload();
        ((InputContext)Mockito.doReturn((Object)workingDirs).when((Object)inputContext)).getWorkDirs();
        ((InputContext)Mockito.doReturn((Object)0xC800000L).when((Object)inputContext)).getTotalMemoryAvailableToTask();
        ((InputContext)Mockito.doReturn((Object)counters).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                if (args[1] instanceof MemoryUpdateCallbackHandler) {
                    MemoryUpdateCallbackHandler memUpdateCallbackHandler = (MemoryUpdateCallbackHandler)args[1];
                    memUpdateCallbackHandler.memoryAssigned(0xC800000L);
                } else {
                    Assert.fail();
                }
                return null;
            }
        }).when((Object)inputContext)).requestInitialMemory(((Long)Matchers.any(Long.TYPE)).longValue(), (MemoryUpdateCallback)Matchers.any(MemoryUpdateCallbackHandler.class));
        return inputContext;
    }

    static class OrderedGroupedKVInputForTest
    extends OrderedGroupedKVInput {
        public OrderedGroupedKVInputForTest(InputContext inputContext, int numPhysicalInputs) {
            super(inputContext, numPhysicalInputs);
        }

        Shuffle createShuffle() throws IOException {
            Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
            try {
                ((Shuffle)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)shuffle)).waitForInput();
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
            catch (TezException e) {
                Assert.fail();
            }
            return shuffle;
        }
    }
}

