/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.conf.UnorderedKVInputConfig;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUnorderedPartitionedKVEdgeConfig {
    @Test(timeout=2000L)
    public void testNullParams() {
        try {
            UnorderedPartitionedKVEdgeConfig.newBuilder(null, (String)"VALUE", (String)"PARTITIONER");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", null, (String)"PARTITIONER");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test(timeout=2000L)
    public void testDefaultConfigsUsed() {
        UnorderedPartitionedKVEdgeConfig.Builder builder = UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER");
        builder.setKeySerializationClass("SerClass1", null);
        builder.setValueSerializationClass("SerClass2", null);
        UnorderedPartitionedKVEdgeConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuiltOutput = new UnorderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)true, (Object)outputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertTrue((boolean)outputConf.get("io.serializations").startsWith("SerClass2,SerClass1"));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)true, (Object)inputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertTrue((boolean)inputConf.get("io.serializations").startsWith("SerClass2,SerClass1"));
    }

    @Test(timeout=2000L)
    public void testSpecificIOConfs() {
        UnorderedPartitionedKVEdgeConfig.Builder builder = UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER");
        UnorderedPartitionedKVEdgeConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuiltOutput = new UnorderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", "DEFAULT"));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", "DEFAULT"));
    }

    @Test(timeout=2000L)
    public void tetCommonConf() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setBoolean("tez.runtime.ifile.readahead", false);
        fromConf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.11f);
        fromConf.setInt("tez.runtime.unordered.output.buffer.size-mb", 123);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConfs = new HashMap<String, String>();
        additionalConfs.put("test.key.2", "key2");
        additionalConfs.put("tez.runtime.ifile.readahead.bytes", "1111");
        additionalConfs.put("tez.runtime.shuffle.memory.limit.percent", "0.22f");
        additionalConfs.put("tez.runtime.unordered.output.max-per-buffer.size-bytes", "2222");
        additionalConfs.put("file.shouldExist", "file");
        Configuration fromConfUnfiltered = new Configuration(false);
        fromConfUnfiltered.set("test.conf.unfiltered.1", "unfiltered1");
        UnorderedPartitionedKVEdgeConfig.Builder builder = UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER").setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("io.file.buffer.size", "3333").setAdditionalConfiguration("tez.runtime.shuffle.merge.percent", "0.33f").setAdditionalConfiguration(additionalConfs).setFromConfiguration(fromConf).setFromConfigurationUnfiltered(fromConfUnfiltered);
        UnorderedPartitionedKVEdgeConfig configuration = builder.build();
        UnorderedPartitionedKVOutputConfig rebuiltOutput = new UnorderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        UnorderedKVInputConfig rebuiltInput = new UnorderedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)false, (Object)outputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)outputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)3333L, (long)outputConf.getInt("io.file.buffer.size", 0));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.fetch.buffer.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.memory.limit.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.merge.percent"));
        Assert.assertEquals((long)123L, (long)outputConf.getInt("tez.runtime.unordered.output.buffer.size-mb", 0));
        Assert.assertEquals((long)2222L, (long)outputConf.getInt("tez.runtime.unordered.output.max-per-buffer.size-bytes", 0));
        Assert.assertEquals((Object)"io", (Object)outputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)outputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)outputConf.get("fs.shouldExist"));
        Assert.assertEquals((Object)"unfiltered1", (Object)outputConf.get("test.conf.unfiltered.1"));
        Assert.assertEquals((Object)false, (Object)inputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)inputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)3333L, (long)inputConf.getInt("io.file.buffer.size", 0));
        Assert.assertEquals((float)0.11f, (float)inputConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)inputConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)inputConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertNull((Object)inputConf.get("tez.runtime.unordered.output.buffer.size-mb"));
        Assert.assertNull((Object)inputConf.get("tez.runtime.unordered.output.max-per-buffer.size-bytes"));
        Assert.assertEquals((Object)"io", (Object)inputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)inputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)inputConf.get("fs.shouldExist"));
        Assert.assertEquals((Object)"unfiltered1", (Object)inputConf.get("test.conf.unfiltered.1"));
    }

    private void checkHistoryText(String historyText) {
        Assert.assertNotNull((Object)historyText);
        Assert.assertTrue((boolean)historyText.contains("tez.runtime.convert.user-payload.to.history-text"));
    }

    @Test(timeout=2000L)
    public void testHistoryText() {
        UnorderedPartitionedKVEdgeConfig.Builder builder = UnorderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER");
        Configuration fromConf = new Configuration(false);
        fromConf.setBoolean("tez.runtime.convert.user-payload.to.history-text", true);
        builder.setFromConfiguration(fromConf);
        UnorderedPartitionedKVEdgeConfig kvEdgeConfig = builder.build();
        this.checkHistoryText(kvEdgeConfig.getInputHistoryText());
        this.checkHistoryText(kvEdgeConfig.getOutputHistoryText());
        EdgeProperty defaultEdgeProperty = builder.build().createDefaultEdgeProperty();
        this.checkHistoryText(defaultEdgeProperty.getEdgeDestination().getHistoryText());
        this.checkHistoryText(defaultEdgeProperty.getEdgeSource().getHistoryText());
        EdgeManagerPluginDescriptor descriptor = (EdgeManagerPluginDescriptor)Mockito.mock(EdgeManagerPluginDescriptor.class);
        EdgeProperty edgeProperty = builder.build().createDefaultCustomEdgeProperty(descriptor);
        this.checkHistoryText(edgeProperty.getEdgeDestination().getHistoryText());
        this.checkHistoryText(edgeProperty.getEdgeSource().getHistoryText());
    }
}

