/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.Shuffle;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShuffle {
    private static final Logger LOG = LoggerFactory.getLogger(TestShuffle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSchedulerTerminatesOnException() throws IOException, InterruptedException {
        InputContext inputContext = this.createTezInputContext();
        TezConfiguration conf = new TezConfiguration();
        conf.setLong("tez.runtime.task.memory", 300000L);
        Shuffle shuffle = new Shuffle(inputContext, (Configuration)conf, 1, 3000000L);
        try {
            shuffle.run();
            ShuffleScheduler scheduler = shuffle.scheduler;
            MergeManager mergeManager = shuffle.merger;
            Assert.assertFalse((boolean)scheduler.isShutdown());
            Assert.assertFalse((boolean)mergeManager.isShutdown());
            String exceptionMessage = "Simulating fetch failure";
            shuffle.reportException((Throwable)new IOException(exceptionMessage));
            while (!scheduler.isShutdown()) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((boolean)scheduler.isShutdown());
            while (!mergeManager.isShutdown()) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((boolean)mergeManager.isShutdown());
            ArgumentCaptor throwableArgumentCaptor = ArgumentCaptor.forClass(Throwable.class);
            ArgumentCaptor stringArgumentCaptor = ArgumentCaptor.forClass(String.class);
            ((InputContext)Mockito.verify((Object)inputContext, (VerificationMode)Mockito.times((int)1))).reportFailure((TaskFailureType)Matchers.eq((Object)TaskFailureType.NON_FATAL), (Throwable)throwableArgumentCaptor.capture(), (String)stringArgumentCaptor.capture());
            Throwable t = (Throwable)throwableArgumentCaptor.getValue();
            Assert.assertTrue((boolean)t.getCause().getMessage().contains(exceptionMessage));
        }
        finally {
            shuffle.shutdown();
        }
    }

    private InputContext createTezInputContext() throws IOException {
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)1);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)applicationId).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)"sourceVertex").when((Object)inputContext)).getSourceVertexName();
        Mockito.when((Object)inputContext.getCounters()).thenReturn((Object)new TezCounters());
        ExecutionContextImpl executionContext = new ExecutionContextImpl("localhost");
        ((InputContext)Mockito.doReturn((Object)executionContext).when((Object)inputContext)).getExecutionContext();
        ByteBuffer shuffleBuffer = ByteBuffer.allocate(4).putInt(0, 4);
        ((InputContext)Mockito.doReturn((Object)shuffleBuffer).when((Object)inputContext)).getServiceProviderMetaData(Matchers.anyString());
        Token sessionToken = new Token((TokenIdentifier)new JobTokenIdentifier(new Text("text")), (SecretManager)new JobTokenSecretManager());
        ByteBuffer tokenBuffer = TezCommonUtils.serializeServiceData((Token)sessionToken);
        ((InputContext)Mockito.doReturn((Object)tokenBuffer).when((Object)inputContext)).getServiceConsumerMetaData(Matchers.anyString());
        return inputContext;
    }
}

