/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.http.HttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetcherOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapHost;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.Shuffle;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleClientMetrics;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.exceptions.FetcherReadTimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFetcher {
    public static final String SHUFFLE_INPUT_FILE_PREFIX = "shuffle_input_file_";
    public static final String HOST = "localhost";
    public static final int PORT = 65;
    public static final int DAG_ID = 1;
    public static final String APP_ID = "application_1234_1";
    private TezCounters tezCounters = new TezCounters();
    private TezCounter ioErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.IO_ERROR.toString());
    private TezCounter wrongLengthErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.WRONG_LENGTH.toString());
    private TezCounter badIdErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.BAD_ID.toString());
    private TezCounter wrongMapErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.WRONG_MAP.toString());
    private TezCounter connectionErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.CONNECTION.toString());
    private TezCounter wrongReduceErrsCounter = this.tezCounters.findCounter("Shuffle Errors", ShuffleScheduler.ShuffleErrors.WRONG_REDUCE.toString());
    static final Logger LOG = LoggerFactory.getLogger(TestFetcher.class);

    @Test(timeout=5000L)
    public void testInputsReturnedOnConnectionException() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)"src vertex").when((Object)inputContext)).getSourceVertexName();
        MapHost mapHost = new MapHost(HOST, 65, 0);
        InputAttemptIdentifier inputAttemptIdentifier = new InputAttemptIdentifier(0, 0, "attempt");
        mapHost.addKnownMap(inputAttemptIdentifier);
        ArrayList mapsForHost = Lists.newArrayList((Object[])new InputAttemptIdentifier[]{inputAttemptIdentifier});
        ((ShuffleScheduler)Mockito.doReturn((Object)mapsForHost).when((Object)scheduler)).getMapsForHost(mapHost);
        FetcherOrderedGrouped fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, false, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        fetcher.call();
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).getMapsForHost(mapHost);
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).freeHost(mapHost);
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).putBackKnownMapOutput(mapHost, inputAttemptIdentifier);
    }

    @Test(timeout=5000L)
    public void testLocalFetchModeSetting1() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)"src vertex").when((Object)inputContext)).getSourceVertexName();
        boolean ENABLE_LOCAL_FETCH = true;
        boolean DISABLE_LOCAL_FETCH = false;
        MapHost mapHost = new MapHost(HOST, 65, 0);
        FetcherOrderedGrouped fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, true, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        FetcherOrderedGrouped spyFetcher = (FetcherOrderedGrouped)Mockito.spy((Object)fetcher);
        ((FetcherOrderedGrouped)Mockito.doNothing().when((Object)spyFetcher)).setupLocalDiskFetch(mapHost);
        spyFetcher.fetchNext();
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.times((int)1))).setupLocalDiskFetch(mapHost);
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.never())).copyFromHost((MapHost)Matchers.any(MapHost.class));
        mapHost = new MapHost("localhost_OTHER", 65, 0);
        fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, true, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        spyFetcher = (FetcherOrderedGrouped)Mockito.spy((Object)fetcher);
        ((FetcherOrderedGrouped)Mockito.doNothing().when((Object)spyFetcher)).setupLocalDiskFetch(mapHost);
        spyFetcher.fetchNext();
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.never())).setupLocalDiskFetch((MapHost)Matchers.any(MapHost.class));
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.times((int)1))).copyFromHost(mapHost);
        mapHost = new MapHost(HOST, 66, 0);
        fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, true, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        spyFetcher = (FetcherOrderedGrouped)Mockito.spy((Object)fetcher);
        ((FetcherOrderedGrouped)Mockito.doNothing().when((Object)spyFetcher)).setupLocalDiskFetch(mapHost);
        spyFetcher.fetchNext();
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.never())).setupLocalDiskFetch((MapHost)Matchers.any(MapHost.class));
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.times((int)1))).copyFromHost(mapHost);
        mapHost = new MapHost(HOST, 65, 0);
        fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, false, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        spyFetcher = (FetcherOrderedGrouped)Mockito.spy((Object)fetcher);
        ((FetcherOrderedGrouped)Mockito.doNothing().when((Object)spyFetcher)).setupLocalDiskFetch(mapHost);
        spyFetcher.fetchNext();
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.never())).setupLocalDiskFetch((MapHost)Matchers.any(MapHost.class));
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher, (VerificationMode)Mockito.times((int)1))).copyFromHost(mapHost);
    }

    @Test(timeout=5000L)
    public void testSetupLocalDiskFetch() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        Mockito.when((Object)inputContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)inputContext.getSourceVertexName()).thenReturn((Object)"");
        MapHost host = new MapHost(HOST, 65, 1);
        FetcherOrderedGrouped fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, true, HOST, 65, "src vertex", host, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        FetcherOrderedGrouped spyFetcher = (FetcherOrderedGrouped)Mockito.spy((Object)fetcher);
        List<InputAttemptIdentifier> srcAttempts = Arrays.asList(new InputAttemptIdentifier(0, 1, "attemptpathComponent_0"), new InputAttemptIdentifier(1, 2, "attemptpathComponent_1"), new InputAttemptIdentifier(2, 3, "attemptpathComponent_2"), new InputAttemptIdentifier(3, 4, "attemptpathComponent_3"), new InputAttemptIdentifier(4, 4, "attemptpathComponent_4"));
        int FIRST_FAILED_ATTEMPT_IDX = 2;
        int SECOND_FAILED_ATTEMPT_IDX = 4;
        int[] sucessfulAttemptsIndexes = new int[]{0, 1, 3};
        ((ShuffleScheduler)Mockito.doReturn(srcAttempts).when((Object)scheduler)).getMapsForHost(host);
        ((FetcherOrderedGrouped)Mockito.doAnswer((Answer)new Answer<MapOutput>(){

            public MapOutput answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                MapOutput mapOutput = (MapOutput)Mockito.mock(MapOutput.class);
                ((MapOutput)Mockito.doReturn((Object)MapOutput.Type.DISK_DIRECT).when((Object)mapOutput)).getType();
                ((MapOutput)Mockito.doReturn((Object)args[0]).when((Object)mapOutput)).getAttemptIdentifier();
                return mapOutput;
            }
        }).when((Object)spyFetcher)).getMapOutputForDirectDiskFetch((InputAttemptIdentifier)Matchers.any(InputAttemptIdentifier.class), (Path)Matchers.any(Path.class), (TezIndexRecord)Matchers.any(TezIndexRecord.class));
        ((FetcherOrderedGrouped)Mockito.doAnswer((Answer)new Answer<Path>(){

            public Path answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return new Path(TestFetcher.SHUFFLE_INPUT_FILE_PREFIX + args[0]);
            }
        }).when((Object)spyFetcher)).getShuffleInputFileName(Matchers.anyString(), Matchers.anyString());
        ((FetcherOrderedGrouped)Mockito.doAnswer((Answer)new Answer<TezIndexRecord>(){

            public TezIndexRecord answer(InvocationOnMock invocation) throws Throwable {
                int len;
                Object[] args = invocation.getArguments();
                String pathComponent = (String)args[0];
                long p = Long.valueOf(pathComponent.substring((len = pathComponent.length()) - 1, len));
                if (p == 2L || p == 4L) {
                    throw new IOException("failing to simulate failure case");
                }
                return new TezIndexRecord(p * 10L, p * 1000L, p * 100L);
            }
        }).when((Object)spyFetcher)).getIndexRecord(Matchers.anyString(), Matchers.eq((int)host.getPartitionId()));
        ((ShuffleScheduler)Mockito.doNothing().when((Object)scheduler)).copySucceeded((InputAttemptIdentifier)Matchers.any(InputAttemptIdentifier.class), (MapHost)Matchers.any(MapHost.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong(), (MapOutput)Matchers.any(MapOutput.class), Matchers.anyBoolean());
        ((ShuffleScheduler)Mockito.doNothing().when((Object)scheduler)).putBackKnownMapOutput(host, srcAttempts.get(2));
        ((ShuffleScheduler)Mockito.doNothing().when((Object)scheduler)).putBackKnownMapOutput(host, srcAttempts.get(4));
        spyFetcher.setupLocalDiskFetch(host);
        for (int i : sucessfulAttemptsIndexes) {
            this.verifyCopySucceeded(scheduler, host, srcAttempts, i);
        }
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).copyFailed(srcAttempts.get(2), host, true, false, true);
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).copyFailed(srcAttempts.get(4), host, true, false, true);
        ((ShuffleClientMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)3))).successFetch();
        ((ShuffleClientMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)2))).failedFetch();
        ((FetcherOrderedGrouped)Mockito.verify((Object)spyFetcher)).putBackRemainingMapOutputs(host);
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).putBackKnownMapOutput(host, srcAttempts.get(2));
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).putBackKnownMapOutput(host, srcAttempts.get(4));
    }

    private void verifyCopySucceeded(ShuffleScheduler scheduler, MapHost host, List<InputAttemptIdentifier> srcAttempts, long p) throws IOException {
        InputAttemptIdentifier srcAttemptToMatch = srcAttempts.get((int)p);
        String filenameToMatch = SHUFFLE_INPUT_FILE_PREFIX + srcAttemptToMatch.getPathComponent();
        ArgumentCaptor captureMapOutput = ArgumentCaptor.forClass(MapOutput.class);
        ((ShuffleScheduler)Mockito.verify((Object)scheduler)).copySucceeded((InputAttemptIdentifier)Matchers.eq((Object)srcAttemptToMatch), (MapHost)Matchers.eq((Object)host), Matchers.eq((long)(p * 100L)), Matchers.eq((long)(p * 1000L)), Matchers.anyLong(), (MapOutput)captureMapOutput.capture(), Matchers.anyBoolean());
        MapOutput m = (MapOutput)captureMapOutput.getAllValues().get(0);
        Assert.assertTrue((m.getType().equals((Object)MapOutput.Type.DISK_DIRECT) && m.getAttemptIdentifier().equals((Object)srcAttemptToMatch) ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testWithRetry() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.runtime.shuffle.read.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.connect.timeout", 3000);
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        Mockito.when((Object)inputContext.getCounters()).thenReturn((Object)new TezCounters());
        Mockito.when((Object)inputContext.getSourceVertexName()).thenReturn((Object)"");
        Mockito.when((Object)inputContext.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)0L, (int)1));
        HttpConnectionParams httpConnectionParams = ShuffleUtils.getHttpConnectionParams((Configuration)conf);
        MapHost host = new MapHost(HOST, 65, 1);
        FetcherOrderedGrouped mockFetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, false, HOST, 65, "src vertex", host, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        final FetcherOrderedGrouped fetcher = (FetcherOrderedGrouped)Mockito.spy((Object)mockFetcher);
        List<InputAttemptIdentifier> srcAttempts = Arrays.asList(new InputAttemptIdentifier(0, 1, "attemptpathComponent_0"), new InputAttemptIdentifier(1, 2, "attemptpathComponent_1"), new InputAttemptIdentifier(3, 4, "attemptpathComponent_3"));
        ((ShuffleScheduler)Mockito.doReturn(srcAttempts).when((Object)scheduler)).getMapsForHost(host);
        ((FetcherOrderedGrouped)Mockito.doReturn((Object)true).when((Object)fetcher)).setupConnection((MapHost)Matchers.any(MapHost.class), (Collection)Matchers.any(Collection.class));
        URL url = ShuffleUtils.constructInputURL((String)"http://localhost:65/mapOutput?job=job_123&&reduce=1&map=", srcAttempts, (boolean)false);
        fetcher.httpConnection = new FakeHttpConnection(url, null, "", null);
        ((MergeManager)Mockito.doAnswer((Answer)new Answer<MapOutput>(){

            public MapOutput answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                MapOutput mapOutput = (MapOutput)Mockito.mock(MapOutput.class);
                ((MapOutput)Mockito.doReturn((Object)MapOutput.Type.MEMORY).when((Object)mapOutput)).getType();
                ((MapOutput)Mockito.doReturn((Object)args[0]).when((Object)mapOutput)).getAttemptIdentifier();
                return mapOutput;
            }
        }).when((Object)merger)).reserve((InputAttemptIdentifier)Matchers.any(InputAttemptIdentifier.class), (long)Matchers.anyInt(), (long)Matchers.anyInt(), Matchers.anyInt());
        ((FetcherOrderedGrouped)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(4000L);
                ((FetcherOrderedGrouped)Mockito.doReturn((Object)false).when((Object)fetcher)).setupConnection((MapHost)Matchers.any(MapHost.class), (Collection)Matchers.any(Collection.class));
                throw new FetcherReadTimeoutException("creating fetcher socket read timeout exception");
            }
        }).when((Object)fetcher)).copyMapOutput((MapHost)Matchers.any(MapHost.class), (DataInputStream)Matchers.any(DataInputStream.class));
        try {
            fetcher.copyFromHost(host);
        }
        catch (IOException e) {
            // empty catch block
        }
        ((FetcherOrderedGrouped)Mockito.verify((Object)fetcher, (VerificationMode)Mockito.times((int)2))).setupConnection((MapHost)Matchers.any(MapHost.class), (Collection)Matchers.any(Collection.class));
        ((ShuffleScheduler)Mockito.verify((Object)scheduler, (VerificationMode)Mockito.times((int)1))).copyFailed((InputAttemptIdentifier)Matchers.any(InputAttemptIdentifier.class), (MapHost)Matchers.any(MapHost.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean());
        ((FetcherOrderedGrouped)Mockito.verify((Object)fetcher, (VerificationMode)Mockito.times((int)1))).putBackRemainingMapOutputs((MapHost)Matchers.any(MapHost.class));
        ((ShuffleScheduler)Mockito.verify((Object)scheduler, (VerificationMode)Mockito.times((int)3))).putBackKnownMapOutput((MapHost)Matchers.any(MapHost.class), (InputAttemptIdentifier)Matchers.any(InputAttemptIdentifier.class));
        try {
            fetcher.stopped = false;
            fetcher.copyFromHost(host);
            ((FetcherOrderedGrouped)Mockito.verify((Object)fetcher, (VerificationMode)Mockito.times((int)2))).putBackRemainingMapOutputs((MapHost)Matchers.any(MapHost.class));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Test
    public void testAsyncWithException() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.setInt("tez.runtime.shuffle.read.timeout", 3000);
        conf.setInt("tez.runtime.shuffle.connect.timeout", 3000);
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        TezCounters counters = new TezCounters();
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        Mockito.when((Object)inputContext.getCounters()).thenReturn((Object)counters);
        Mockito.when((Object)inputContext.getSourceVertexName()).thenReturn((Object)"");
        JobTokenSecretManager jobMgr = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        ((JobTokenSecretManager)Mockito.doReturn((Object)new byte[10]).when((Object)jobMgr)).computeHash((byte[])Matchers.any(byte[].class));
        HttpConnectionParams httpConnectionParams = ShuffleUtils.getHttpConnectionParams((Configuration)conf);
        MapHost host = new MapHost(HOST, 65, 1);
        FetcherOrderedGrouped mockFetcher = new FetcherOrderedGrouped(httpConnectionParams, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, jobMgr, false, 0, null, (Configuration)conf, false, HOST, 65, "src vertex", host, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, true, false, true);
        FetcherOrderedGrouped fetcher = (FetcherOrderedGrouped)Mockito.spy((Object)mockFetcher);
        fetcher.remaining = new LinkedHashMap();
        List<InputAttemptIdentifier> srcAttempts = Arrays.asList(new InputAttemptIdentifier(0, 1, "attemptpathComponent_0"), new InputAttemptIdentifier(1, 2, "attemptpathComponent_1"), new InputAttemptIdentifier(3, 4, "attemptpathComponent_3"));
        ((ShuffleScheduler)Mockito.doReturn(srcAttempts).when((Object)scheduler)).getMapsForHost(host);
        try {
            long currentIOErrors = this.ioErrsCounter.getValue();
            boolean connected = fetcher.setupConnection(host, srcAttempts);
            Assert.assertTrue((!connected ? 1 : 0) != 0);
            Assert.assertTrue((this.ioErrsCounter.getValue() > currentIOErrors ? 1 : 0) != 0);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test(timeout=5000L)
    public void testInputAttemptIdentifierMap() {
        InputAttemptIdentifier[] srcAttempts = new InputAttemptIdentifier[]{new InputAttemptIdentifier(0, 1, "attemptpathComponent_0", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(0, 1, "attemptpathComponent_0", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 1, "attemptpathComponent_1", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 2, "attemptpathComponent_1", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 1, "attemptpathComponent_2", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 1), new InputAttemptIdentifier(1, 1, "attemptpathComponent_3", false, InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE, 2), new InputAttemptIdentifier(2, 1, "attemptpathComponent_3", false, InputAttemptIdentifier.SPILL_INFO.FINAL_MERGE_ENABLED, 0)};
        InputAttemptIdentifier[] expectedSrcAttempts = new InputAttemptIdentifier[]{new InputAttemptIdentifier(0, 1, "attemptpathComponent_0", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 1, "attemptpathComponent_1", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 2, "attemptpathComponent_1", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0), new InputAttemptIdentifier(1, 1, "attemptpathComponent_2", false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 1), new InputAttemptIdentifier(1, 1, "attemptpathComponent_3", false, InputAttemptIdentifier.SPILL_INFO.FINAL_UPDATE, 2), new InputAttemptIdentifier(2, 1, "attemptpathComponent_3", false, InputAttemptIdentifier.SPILL_INFO.FINAL_MERGE_ENABLED, 0)};
        TezConfiguration conf = new TezConfiguration();
        ShuffleScheduler scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        MergeManager merger = (MergeManager)Mockito.mock(MergeManager.class);
        ShuffleClientMetrics metrics = (ShuffleClientMetrics)Mockito.mock(ShuffleClientMetrics.class);
        Shuffle shuffle = (Shuffle)Mockito.mock(Shuffle.class);
        MapHost mapHost = new MapHost(HOST, 65, 0);
        FetcherOrderedGrouped fetcher = new FetcherOrderedGrouped(null, scheduler, (FetchedInputAllocatorOrderedGrouped)merger, metrics, (ExceptionReporter)shuffle, null, false, 0, null, (Configuration)conf, false, HOST, 65, "src vertex", mapHost, this.ioErrsCounter, this.wrongLengthErrsCounter, this.badIdErrsCounter, this.wrongMapErrsCounter, this.connectionErrsCounter, this.wrongReduceErrsCounter, APP_ID, 1, false, false, true);
        fetcher.populateRemainingMap(new LinkedList<InputAttemptIdentifier>(Arrays.asList(srcAttempts)));
        Assert.assertEquals((long)expectedSrcAttempts.length, (long)fetcher.remaining.size());
        Iterator iterator = fetcher.remaining.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next().getKey();
            Assert.assertTrue((expectedSrcAttempts[count++].toString().compareTo(key) == 0 ? 1 : 0) != 0);
        }
    }

    static class FakeHttpConnection
    extends HttpConnection {
        public FakeHttpConnection(URL url, HttpConnectionParams connParams, String logIdentifier, JobTokenSecretManager jobTokenSecretMgr) throws IOException {
            super(url, connParams, logIdentifier, jobTokenSecretMgr);
            this.connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
            Mockito.when((Object)this.connection.getResponseCode()).thenReturn((Object)200);
            Mockito.when((Object)this.connection.getHeaderField("name")).thenReturn((Object)"mapreduce");
            Mockito.when((Object)this.connection.getHeaderField("version")).thenReturn((Object)"1.0.0");
            Mockito.when((Object)this.connection.getHeaderField("ReplyHash")).thenReturn((Object)"");
        }

        public DataInputStream getInputStream() throws IOException {
            byte[] b = new byte[1024];
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            return new DataInputStream(bin);
        }

        public void validate() throws IOException {
        }

        public void cleanup(boolean disconnect) throws IOException {
            LOG.info("HttpConnection cleanup called with disconnect=" + disconnect);
        }
    }
}

