/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.readers;

import java.io.IOException;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.api.IOInterruptedException;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.readers.UnorderedKVReader;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;
import org.apache.tez.runtime.library.common.shuffle.LocalDiskFetchedInput;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUnorderedKVReader {
    private static final Logger LOG = LoggerFactory.getLogger(TestUnorderedKVReader.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir = null;
    private String outputFileName = "ifile.out";
    private Path outputPath;
    private long rawLen;
    private long compLen;
    private UnorderedKVReader<Text, Text> unorderedKVReader;

    @Before
    public void setUp() throws Exception {
        this.outputPath = new Path(workDir, this.outputFileName);
        this.setupReader();
    }

    private void setupReader() throws IOException, InterruptedException {
        defaultConf.set("tez.runtime.key.class", Text.class.getName());
        defaultConf.set("tez.runtime.value.class", Text.class.getName());
        this.createIFile(this.outputPath, 1);
        final LinkedList<LocalDiskFetchedInput> inputs = new LinkedList<LocalDiskFetchedInput>();
        LocalDiskFetchedInput realFetchedInput = new LocalDiskFetchedInput(0L, this.rawLen, this.compLen, new InputAttemptIdentifier(0, 0), this.outputPath, defaultConf, new FetchedInputCallback(){

            public void fetchComplete(FetchedInput fetchedInput) {
            }

            public void fetchFailed(FetchedInput fetchedInput) {
            }

            public void freeResources(FetchedInput fetchedInput) {
            }
        });
        LocalDiskFetchedInput fetchedInput = (LocalDiskFetchedInput)Mockito.spy((Object)realFetchedInput);
        ((LocalDiskFetchedInput)Mockito.doNothing().when((Object)fetchedInput)).free();
        inputs.add(fetchedInput);
        TezCounters counters = new TezCounters();
        TezCounter inputRecords = counters.findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        ShuffleManager manager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        ((ShuffleManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return inputs.isEmpty() ? null : (LocalDiskFetchedInput)inputs.remove();
            }
        }).when((Object)manager)).getNextInput();
        this.unorderedKVReader = new UnorderedKVReader(manager, defaultConf, null, false, -1, -1, inputRecords, (InputContext)Mockito.mock(InputContext.class));
    }

    private void createIFile(Path path, int recordCount) throws IOException {
        FSDataOutputStream out = localFs.create(path);
        IFile.Writer writer = new IFile.Writer(defaultConf, out, Text.class, Text.class, null, null, null, true);
        for (int i = 0; i < recordCount; ++i) {
            writer.append((Object)new Text("Key_" + i), (Object)new Text("Value_" + i));
        }
        writer.close();
        this.rawLen = writer.getRawLength();
        this.compLen = writer.getCompressedLength();
        out.close();
    }

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test(timeout=5000L)
    public void testReadingMultipleTimes() throws Exception {
        int counter = 0;
        while (this.unorderedKVReader.next()) {
            this.unorderedKVReader.getCurrentKey();
            this.unorderedKVReader.getCurrentKey();
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
        try {
            boolean next = this.unorderedKVReader.next();
            TestCase.fail();
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("For usage, please refer to"));
        }
    }

    @Test(timeout=5000L)
    public void testInterruptOnNext() throws IOException, InterruptedException {
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        ((ShuffleManager)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)shuffleManager)).getNextInput();
        TezCounters counters = new TezCounters();
        TezCounter inputRecords = counters.findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        UnorderedKVReader reader = new UnorderedKVReader(shuffleManager, defaultConf, null, false, -1, -1, inputRecords, (InputContext)Mockito.mock(InputContext.class));
        try {
            reader.next();
            TestCase.fail((String)"No data available to reader. Should not be able to access any record");
        }
        catch (IOInterruptedException e) {
            // empty catch block
        }
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestUnorderedKVReader.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            LOG.info("Using workDir: " + workDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

