/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.apache.tez.runtime.library.output.OutputTestHelpers;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.Assert;
import org.junit.Test;

public class TestOrderedPartitionedKVOutput2 {
    @Test(timeout=5000L)
    public void testNonStartedOutput() throws IOException {
        OutputContext outputContext = OutputTestHelpers.createOutputContext();
        int numPartitions = 10;
        OrderedPartitionedKVOutput output = new OrderedPartitionedKVOutput(outputContext, numPartitions);
        output.initialize();
        List events = output.close();
        Assert.assertEquals((long)2L, (long)events.size());
        Event event1 = (Event)events.get(0);
        Assert.assertTrue((boolean)(event1 instanceof VertexManagerEvent));
        Event event2 = (Event)events.get(1);
        Assert.assertTrue((boolean)(event2 instanceof CompositeDataMovementEvent));
        CompositeDataMovementEvent cdme = (CompositeDataMovementEvent)event2;
        ByteBuffer bb = cdme.getUserPayload();
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)bb));
        Assert.assertTrue((boolean)shufflePayload.hasEmptyPartitions());
        byte[] emptyPartitions = TezCommonUtils.decompressByteStringToByteArray((ByteString)shufflePayload.getEmptyPartitions());
        BitSet emptyPartionsBitSet = TezUtilsInternal.fromByteArray((byte[])emptyPartitions);
        Assert.assertEquals((long)numPartitions, (long)emptyPartionsBitSet.cardinality());
        for (int i = 0; i < numPartitions; ++i) {
            Assert.assertTrue((boolean)emptyPartionsBitSet.get(i));
        }
    }
}

