/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.conf.UnorderedKVInputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestUnorderedKVInputConfig {
    @Test(timeout=5000L)
    public void testNullParams() {
        try {
            UnorderedKVInputConfig.newBuilder(null, (String)"VALUE");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            UnorderedKVInputConfig.newBuilder((String)"KEY", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test(timeout=5000L)
    public void testSetters() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.ifile.readahead.bytes", 1111);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("test.key.2", "key2");
        additionalConf.put("tez.runtime.io.sort.factor", "3");
        additionalConf.put("file.shouldExist", "file");
        UnorderedKVInputConfig.Builder builder = UnorderedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE").setCompression(true, "CustomCodec", null).setMaxSingleMemorySegmentFraction(0.11f).setMergeFraction(0.22f).setShuffleBufferFraction(0.33f).setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("tez.runtime.ifile.readahead", String.valueOf(false)).setAdditionalConfiguration(additionalConf).setFromConfiguration(fromConf);
        UnorderedKVInputConfig configuration = builder.build();
        UnorderedKVInputConfig rebuilt = new UnorderedKVInputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((float)0.11f, (float)conf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)conf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)conf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000));
        Assert.assertEquals((long)3L, (long)conf.getInt("tez.runtime.io.sort.factor", -1));
        Assert.assertEquals((Object)"io", (Object)conf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)conf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)conf.get("fs.shouldExist"));
        Assert.assertNull((Object)conf.get("test.conf.key.1"));
        Assert.assertNull((Object)conf.get("test.key.1"));
        Assert.assertNull((Object)conf.get("test.key.2"));
    }

    @Test(timeout=5000L)
    public void testDefaultConfigsUsed() {
        UnorderedKVInputConfig.Builder builder = UnorderedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE");
        UnorderedKVInputConfig configuration = builder.build();
        UnorderedKVInputConfig rebuilt = new UnorderedKVInputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
    }

    private final void verifySharedFetchConfigs(UserPayload payload) {
        UnorderedKVInputConfig rebuilt = new UnorderedKVInputConfig();
        rebuilt.fromUserPayload(payload);
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.optimize.local.fetch", true));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.optimize.shared.fetch", false));
    }

    @Test
    public void testSharedFetchConfigs() {
        UnorderedKVInputConfig.Builder builder = UnorderedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE");
        UnorderedKVInputConfig configuration = builder.setAdditionalConfiguration("tez.runtime.optimize.local.fetch", String.valueOf(false)).setAdditionalConfiguration("tez.runtime.optimize.shared.fetch", String.valueOf(true)).build();
        this.verifySharedFetchConfigs(configuration.toUserPayload());
        Configuration conf = new Configuration();
        conf.set("tez.runtime.optimize.local.fetch", String.valueOf(false));
        conf.set("tez.runtime.optimize.shared.fetch", String.valueOf(true));
        configuration = UnorderedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE").setFromConfiguration(conf).build();
        this.verifySharedFetchConfigs(configuration.toUserPayload());
    }
}

