/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleInputEventHandlerImpl;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestShuffleInputEventHandlerImpl {
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    private static final String PATH_COMPONENT = "attempttmp";
    private final Configuration conf = new Configuration();

    @Test(timeout=5000L)
    public void testSimple() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, null);
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), Matchers.eq((int)0));
    }

    @Test(timeout=5000L)
    public void testCurrentPartitionEmpty() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, this.createEmptyPartitionByteString(0));
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addCompletedInputWithNoData((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier));
    }

    @Test(timeout=5000L)
    public void testOtherPartitionEmpty() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, this.createEmptyPartitionByteString(1));
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), Matchers.eq((int)0));
    }

    @Test(timeout=5000L)
    public void testMultipleEvents1() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex1 = 1;
        Event dme1 = this.createDataMovementEvent(0, taskIndex1, this.createEmptyPartitionByteString(0));
        int taskIndex2 = 2;
        Event dme2 = this.createDataMovementEvent(0, taskIndex2, null);
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme1);
        eventList.add(dme2);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier1 = new InputAttemptIdentifier(taskIndex1, 0);
        InputAttemptIdentifier expectedIdentifier2 = new InputAttemptIdentifier(taskIndex2, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addCompletedInputWithNoData((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier1));
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier2), Matchers.eq((int)0));
    }

    private InputContext createInputContext() throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(8080);
        ByteBuffer shuffleMetaData = ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
        ExecutionContext executionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        ((ExecutionContext)Mockito.doReturn((Object)HOST).when((Object)executionContext)).getHostName();
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)"sourceVertex").when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)shuffleMetaData).when((Object)inputContext)).getServiceProviderMetaData("mapreduce_shuffle");
        ((InputContext)Mockito.doReturn((Object)executionContext).when((Object)inputContext)).getExecutionContext();
        return inputContext;
    }

    private ShuffleManager createShuffleManager(InputContext inputContext) throws IOException {
        Path outDirBase = new Path(".", "outDir");
        String[] outDirs = new String[]{outDirBase.toString()};
        ((InputContext)Mockito.doReturn((Object)outDirs).when((Object)inputContext)).getWorkDirs();
        this.conf.setStrings("tez.runtime.framework.local.dirs", inputContext.getWorkDirs());
        DataOutputBuffer out = new DataOutputBuffer();
        Token token = new Token((TokenIdentifier)new JobTokenIdentifier(), (SecretManager)new JobTokenSecretManager(null));
        token.write((DataOutput)out);
        ((InputContext)Mockito.doReturn((Object)ByteBuffer.wrap(out.getData())).when((Object)inputContext)).getServiceConsumerMetaData("mapreduce_shuffle");
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleManager realShuffleManager = new ShuffleManager(inputContext, this.conf, 2, 1024, false, -1, null, inputAllocator);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.spy((Object)realShuffleManager);
        return shuffleManager;
    }

    @Test(timeout=5000L)
    public void testPipelinedShuffleEvents() throws IOException {
        InputContext inputContext = this.createInputContext();
        ShuffleManager shuffleManager = this.createShuffleManager(inputContext);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        Event dme = this.createDataMovementEvent(true, 0, 1, 0, false, new BitSet(), 4, 0);
        handler.handleEvents(Collections.singletonList(dme));
        InputAttemptIdentifier expectedId1 = new InputAttemptIdentifier(new InputIdentifier(1), 0, PATH_COMPONENT, false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager, (VerificationMode)Mockito.times((int)1))).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedId1), Matchers.eq((int)0));
        dme = this.createDataMovementEvent(true, 0, 1, 1, false, new BitSet(), 4, 0);
        handler.handleEvents(Collections.singletonList(dme));
        InputAttemptIdentifier expectedId2 = new InputAttemptIdentifier(new InputIdentifier(1), 0, PATH_COMPONENT, false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 1);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager, (VerificationMode)Mockito.times((int)2))).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedId2), Matchers.eq((int)0));
        dme = this.createDataMovementEvent(true, 0, 1, 1, false, new BitSet(), 4, 1);
        handler.handleEvents(Collections.singletonList(dme));
        ((InputContext)Mockito.verify((Object)inputContext)).fatalError((Throwable)Matchers.any(Throwable.class), Matchers.anyString());
    }

    @Test(timeout=5000L)
    public void testPipelinedShuffleEvents_WithOutOfOrderAttempts() throws IOException {
        InputContext inputContext = this.createInputContext();
        ShuffleManager shuffleManager = this.createShuffleManager(inputContext);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        Event dme = this.createDataMovementEvent(true, 0, 1, 0, false, new BitSet(), 4, 1);
        handler.handleEvents(Collections.singletonList(dme));
        InputAttemptIdentifier expected = new InputAttemptIdentifier(new InputIdentifier(1), 1, PATH_COMPONENT, false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 1);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager, (VerificationMode)Mockito.times((int)1))).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expected), Matchers.eq((int)0));
        dme = this.createDataMovementEvent(true, 0, 1, 0, false, new BitSet(), 4, 0);
        handler.handleEvents(Collections.singletonList(dme));
        ((InputContext)Mockito.verify((Object)inputContext)).fatalError((Throwable)Matchers.any(Throwable.class), Matchers.anyString());
    }

    @Test(timeout=5000L)
    public void testPipelinedShuffleEvents_WithEmptyPartitions() throws IOException {
        InputContext inputContext = this.createInputContext();
        ShuffleManager shuffleManager = this.createShuffleManager(inputContext);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        BitSet bitSet = new BitSet(4);
        bitSet.flip(0, 4);
        Event dme = this.createDataMovementEvent(true, 0, 1, 0, false, bitSet, 4, 0);
        handler.handleEvents(Collections.singletonList(dme));
        InputAttemptIdentifier expected = new InputAttemptIdentifier(new InputIdentifier(1), 0, PATH_COMPONENT, false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 0);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager, (VerificationMode)Mockito.times((int)1))).addCompletedInputWithNoData(expected);
        handler.handleEvents(Collections.singletonList(dme));
        dme = this.createDataMovementEvent(true, 0, 1, 1, false, new BitSet(), 4, 0);
        expected = new InputAttemptIdentifier(new InputIdentifier(1), 0, PATH_COMPONENT, false, InputAttemptIdentifier.SPILL_INFO.INCREMENTAL_UPDATE, 1);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager, (VerificationMode)Mockito.times((int)2))).addCompletedInputWithNoData(expected);
        dme = this.createDataMovementEvent(true, 0, 1, 0, false, new BitSet(), 4, 1);
        handler.handleEvents(Collections.singletonList(dme));
        ((InputContext)Mockito.verify((Object)inputContext)).fatalError((Throwable)Matchers.any(Throwable.class), Matchers.anyString());
    }

    private Event createDataMovementEvent(boolean addSpillDetails, int srcIdx, int targetIdx, int spillId, boolean isLastSpill, BitSet emptyPartitions, int numPartitions, int attemptNum) throws IOException {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        if (emptyPartitions.cardinality() != 0) {
            ByteString emptyPartitionsByteString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitions));
            payloadBuilder.setEmptyPartitions(emptyPartitionsByteString);
        }
        if (emptyPartitions.cardinality() != numPartitions) {
            payloadBuilder.setHost(HOST);
            payloadBuilder.setPort(8080);
            payloadBuilder.setPathComponent("attemptPath");
        }
        if (addSpillDetails) {
            payloadBuilder.setSpillId(spillId);
            payloadBuilder.setLastEvent(isLastSpill);
        }
        ByteBuffer payload = payloadBuilder.build().toByteString().asReadOnlyByteBuffer();
        return DataMovementEvent.create((int)srcIdx, (int)targetIdx, (int)attemptNum, (ByteBuffer)payload);
    }

    private Event createDataMovementEvent(int srcIndex, int targetIndex, ByteString emptyPartitionByteString) {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder builder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        builder.setHost(HOST);
        builder.setPort(8080);
        builder.setPathComponent(PATH_COMPONENT);
        if (emptyPartitionByteString != null) {
            builder.setEmptyPartitions(emptyPartitionByteString);
        }
        DataMovementEvent dme = DataMovementEvent.create((int)srcIndex, (int)targetIndex, (int)0, (ByteBuffer)builder.build().toByteString().asReadOnlyByteBuffer());
        return dme;
    }

    private ByteString createEmptyPartitionByteString(int ... emptyPartitions) throws IOException {
        BitSet bitSet = new BitSet();
        for (int i : emptyPartitions) {
            bitSet.set(i);
        }
        ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)bitSet));
        return emptyPartitionsBytesString;
    }
}

