/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;
import org.apache.tez.runtime.library.utils.BufferUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFile {
    private static final Log LOG = LogFactory.getLog(IFile.class);
    public static final int EOF_MARKER = -1;
    public static final int RLE_MARKER = -2;
    public static final int V_END_MARKER = -3;
    public static final DataInputBuffer REPEAT_KEY = new DataInputBuffer();
    public static final byte[] HEADER = new byte[]{84, 73, 70, 0};
    private static final String WRONG_KEY_CLASS = "wrong key class: %s is not %s";
    private static final String WRONG_VALUE_CLASS = "wrong value class: %s is not %s";
    private static final String NEGATIVE_KEY_LEN = "Negative key-length not allowed: %d for %s";
    private static final String NEGATIVE_VAL_LEN = "Negative value-length not allowed: %d for %s";
    private static final String INCOMPLETE_READ = "Requested to read %d got %d";

    public static void checkState(boolean expression, String format, Object ... args) throws IOException {
        if (!expression) {
            throw new IOException(String.format(format, args));
        }
    }

    static void checkArgument(boolean expression, String format, Object ... args) throws IOException {
        if (!expression) {
            throw new IOException(String.format(format, args));
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Reader {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private long numRecordsRead = 0L;
        private final TezCounter readRecordsCounter;
        private final TezCounter bytesReadCounter;
        final InputStream in;
        Decompressor decompressor;
        public long bytesRead = 0L;
        final long fileLength;
        protected boolean eof = false;
        IFileInputStream checksumIn;
        protected byte[] buffer = null;
        protected int bufferSize = 131072;
        protected DataInputStream dataIn;
        protected int recNo = 1;
        protected int originalKeyLength;
        protected int prevKeyLength;
        protected int currentKeyLength;
        protected int currentValueLength;
        byte[] keyBytes = new byte[0];
        long startPos;
        protected boolean isCompressed = false;

        public Reader(FileSystem fs, Path file, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize) throws IOException {
            this((InputStream)fs.open(file), fs.getFileStatus(file).getLen(), codec, readsCounter, bytesReadCounter, ifileReadAhead, ifileReadAheadLength, bufferSize);
        }

        public Reader(InputStream in, long length, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean readAhead, int readAheadLength, int bufferSize) throws IOException {
            this(in, in != null ? length - (long)HEADER.length : length, codec, readsCounter, bytesReadCounter, readAhead, readAheadLength, bufferSize, in != null ? Reader.isCompressedFlagEnabled(in) : false);
            if (in != null && bytesReadCounter != null) {
                bytesReadCounter.increment((long)HEADER.length);
            }
        }

        public Reader(InputStream in, long length, CompressionCodec codec, TezCounter readsCounter, TezCounter bytesReadCounter, boolean readAhead, int readAheadLength, int bufferSize, boolean isCompressed) throws IOException {
            this.isCompressed = isCompressed;
            this.checksumIn = new IFileInputStream(in, length, readAhead, readAheadLength);
            if (isCompressed && codec != null) {
                this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (this.decompressor != null) {
                    this.in = codec.createInputStream((InputStream)this.checksumIn, this.decompressor);
                } else {
                    LOG.warn((Object)"Could not obtain decompressor from CodecPool");
                    this.in = this.checksumIn;
                }
            } else {
                this.in = this.checksumIn;
            }
            this.dataIn = new DataInputStream(this.in);
            this.startPos = this.checksumIn.getPosition();
            this.readRecordsCounter = readsCounter;
            this.bytesReadCounter = bytesReadCounter;
            this.fileLength = length;
            this.bufferSize = Math.max(0, bufferSize);
        }

        public static void readToMemory(byte[] buffer, InputStream in, int compressedLength, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength) throws IOException {
            boolean isCompressed = Reader.isCompressedFlagEnabled(in);
            IFileInputStream checksumIn = new IFileInputStream(in, compressedLength - HEADER.length, ifileReadAhead, ifileReadAheadLength);
            in = checksumIn;
            Decompressor decompressor = null;
            if (isCompressed && codec != null) {
                decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (decompressor != null) {
                    decompressor.reset();
                    in = codec.createInputStream((InputStream)checksumIn, decompressor);
                } else {
                    LOG.warn((Object)"Could not obtain decompressor from CodecPool");
                    in = checksumIn;
                }
            }
            try {
                IOUtils.readFully((InputStream)in, (byte[])buffer, (int)0, (int)(buffer.length - HEADER.length));
            }
            catch (IOException ioe) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                throw ioe;
            }
            finally {
                if (decompressor != null) {
                    decompressor.reset();
                    CodecPool.returnDecompressor((Decompressor)decompressor);
                }
            }
        }

        public long getLength() {
            return this.fileLength - this.checksumIn.getSize();
        }

        public long getPosition() throws IOException {
            return this.checksumIn.getPosition();
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = IOUtils.wrappedReadForCompressedData((InputStream)this.in, (byte[])buf, (int)(off + bytesRead), (int)(len - bytesRead));
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        protected void readValueLength(DataInput dIn) throws IOException {
            this.currentValueLength = WritableUtils.readVInt((DataInput)dIn);
            this.bytesRead += (long)WritableUtils.getVIntSize((long)this.currentValueLength);
            if (this.currentValueLength == -3) {
                this.readKeyValueLength(dIn);
            }
        }

        protected void readKeyValueLength(DataInput dIn) throws IOException {
            this.currentKeyLength = WritableUtils.readVInt((DataInput)dIn);
            this.currentValueLength = WritableUtils.readVInt((DataInput)dIn);
            if (this.currentKeyLength != -2) {
                this.originalKeyLength = this.currentKeyLength;
            }
            this.bytesRead += (long)(WritableUtils.getVIntSize((long)this.currentKeyLength) + WritableUtils.getVIntSize((long)this.currentValueLength));
        }

        protected boolean positionToNextRecord(DataInput dIn) throws IOException {
            IFile.checkState(!this.eof, "Reached EOF. Completed reading %d", this.bytesRead);
            this.prevKeyLength = this.currentKeyLength;
            if (this.prevKeyLength == -2) {
                this.readValueLength(dIn);
            } else {
                this.readKeyValueLength(dIn);
            }
            if (this.currentKeyLength == -1 && this.currentValueLength == -1) {
                this.eof = true;
                return false;
            }
            if (this.currentKeyLength != -2 && this.currentKeyLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + this.currentKeyLength + " PreviousKeyLen: " + this.prevKeyLength);
            }
            if (this.currentValueLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + this.currentValueLength);
            }
            return true;
        }

        public final boolean nextRawKey(DataInputBuffer key) throws IOException {
            return this.readRawKey(key) != KeyState.NO_KEY;
        }

        public KeyState readRawKey(DataInputBuffer key) throws IOException {
            int i;
            if (!this.positionToNextRecord(this.dataIn)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("currentKeyLength=" + this.currentKeyLength + ", currentValueLength=" + this.currentValueLength + ", bytesRead=" + this.bytesRead + ", length=" + this.fileLength));
                }
                return KeyState.NO_KEY;
            }
            if (this.currentKeyLength == -2) {
                key.reset(this.keyBytes, this.originalKeyLength);
                return KeyState.SAME_KEY;
            }
            if (this.keyBytes.length < this.currentKeyLength) {
                this.keyBytes = new byte[this.currentKeyLength << 1];
            }
            IFile.checkState((i = this.readData(this.keyBytes, 0, this.currentKeyLength)) == this.currentKeyLength, IFile.INCOMPLETE_READ, this.currentKeyLength, i);
            key.reset(this.keyBytes, this.currentKeyLength);
            this.bytesRead += (long)this.currentKeyLength;
            return KeyState.NEW_KEY;
        }

        public void nextRawValue(DataInputBuffer value) throws IOException {
            byte[] valBytes = value.getData().length < this.currentValueLength || value.getData() == this.keyBytes ? new byte[this.currentValueLength << 1] : value.getData();
            int i = this.readData(valBytes, 0, this.currentValueLength);
            IFile.checkState(i == this.currentValueLength, IFile.INCOMPLETE_READ, this.currentValueLength, i);
            value.reset(valBytes, this.currentValueLength);
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
            ++this.numRecordsRead;
        }

        public static boolean isCompressedFlagEnabled(InputStream in) throws IOException {
            byte[] header = new byte[HEADER.length];
            IOUtils.readFully((InputStream)in, (byte[])header, (int)0, (int)HEADER.length);
            if (header[0] != 84 || header[1] != 73 || header[2] != 70) {
                throw new IOException("Not a valid ifile header");
            }
            return header[3] == 1;
        }

        public void close() throws IOException {
            this.in.close();
            this.dataIn = null;
            this.buffer = null;
            if (this.readRecordsCounter != null) {
                this.readRecordsCounter.increment(this.numRecordsRead);
            }
            if (this.bytesReadCounter != null) {
                this.bytesReadCounter.increment(this.checksumIn.getPosition() - this.startPos + this.checksumIn.getSize());
            }
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }

        public void reset(int offset) {
        }

        public void disableChecksumValidation() {
            this.checksumIn.disableChecksumValidation();
        }

        public static enum KeyState {
            NO_KEY,
            NEW_KEY,
            SAME_KEY;

        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Writer {
        protected DataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        FSDataOutputStream rawOut;
        final AtomicBoolean closed = new AtomicBoolean(false);
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        private long numRecordsWritten = 0L;
        private long rleWritten = 0L;
        private long totalKeySaving = 0L;
        private final TezCounter writtenRecordsCounter;
        private final TezCounter serializedUncompressedBytes;
        IFileOutputStream checksumOut;
        Class keyClass;
        Class valueClass;
        Serializer keySerializer;
        Serializer valueSerializer;
        final DataOutputBuffer buffer = new DataOutputBuffer();
        final DataOutputBuffer previous = new DataOutputBuffer();
        Object prevKey = null;
        boolean headerWritten = false;
        @VisibleForTesting
        boolean sameKey = false;
        final int RLE_MARKER_SIZE = WritableUtils.getVIntSize((long)-2L);
        final int V_END_MARKER_SIZE = WritableUtils.getVIntSize((long)-3L);
        protected final boolean rle;

        public Writer(Configuration conf, FileSystem fs, Path file, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec, writesCounter, serializedBytesCounter);
            this.ownOutputStream = true;
        }

        protected Writer(TezCounter writesCounter, TezCounter serializedBytesCounter) {
            this.writtenRecordsCounter = writesCounter;
            this.serializedUncompressedBytes = serializedBytesCounter;
            this.rle = false;
        }

        public Writer(Configuration conf, FSDataOutputStream outputStream, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter) throws IOException {
            this(conf, outputStream, keyClass, valueClass, codec, writesCounter, serializedBytesCounter, false);
        }

        public Writer(Configuration conf, FSDataOutputStream outputStream, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter, TezCounter serializedBytesCounter, boolean rle) throws IOException {
            this.rawOut = outputStream;
            this.writtenRecordsCounter = writesCounter;
            this.serializedUncompressedBytes = serializedBytesCounter;
            this.checksumOut = new IFileOutputStream((OutputStream)outputStream);
            this.start = this.rawOut.getPos();
            this.rle = rle;
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (this.compressor != null) {
                    this.compressor.reset();
                    this.compressedOut = codec.createOutputStream((OutputStream)this.checksumOut, this.compressor);
                    this.out = new FSDataOutputStream((OutputStream)this.compressedOut, null);
                    this.compressOutput = true;
                } else {
                    LOG.warn((Object)"Could not obtain compressor from CodecPool");
                    this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
                }
            } else {
                this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
            }
            this.writeHeader((OutputStream)outputStream);
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            if (keyClass != null) {
                SerializationFactory serializationFactory = new SerializationFactory(conf);
                this.keySerializer = serializationFactory.getSerializer(keyClass);
                this.keySerializer.open((OutputStream)this.buffer);
                this.valueSerializer = serializationFactory.getSerializer(valueClass);
                this.valueSerializer.open((OutputStream)this.buffer);
            }
        }

        public Writer(Configuration conf, FileSystem fs, Path file) throws IOException {
            this(conf, fs, file, null, null, null, null, null);
        }

        protected void writeHeader(OutputStream outputStream) throws IOException {
            if (!this.headerWritten) {
                outputStream.write(HEADER, 0, HEADER.length - 1);
                outputStream.write(this.compressOutput ? 1 : 0);
                outputStream.flush();
                this.headerWritten = true;
            }
        }

        public void close() throws IOException {
            IFile.checkState(!this.closed.getAndSet(true), "Writer was already closed earlier", new Object[0]);
            if (this.keyClass != null) {
                this.keySerializer.close();
                this.valueSerializer.close();
            }
            this.writeValueMarker(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize((long)-1L));
            this.decompressedBytesWritten += (long)HEADER.length;
            this.out.flush();
            if (this.ownOutputStream) {
                this.out.close();
            } else {
                if (this.compressOutput) {
                    this.compressedOut.finish();
                    this.compressedOut.resetState();
                }
                this.checksumOut.finish();
            }
            this.compressedBytesWritten = this.rawOut.getPos() - this.start;
            if (this.compressOutput) {
                CodecPool.returnCompressor((Compressor)this.compressor);
                this.compressor = null;
            }
            this.out = null;
            if (this.writtenRecordsCounter != null) {
                this.writtenRecordsCounter.increment(this.numRecordsWritten);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Total keys written=" + this.numRecordsWritten + "; rleEnabled=" + this.rle + "; Savings" + "(due to multi-kv/rle)=" + this.totalKeySaving + "; number of RLEs written=" + this.rleWritten + "; compressedLen=" + this.compressedBytesWritten + "; rawLen=" + this.decompressedBytesWritten));
            }
        }

        public void append(Object key, Object value) throws IOException {
            IFile.checkArgument(key == REPEAT_KEY || key.getClass() == this.keyClass, IFile.WRONG_KEY_CLASS, key.getClass(), this.keyClass);
            IFile.checkArgument(value.getClass() == this.valueClass, IFile.WRONG_VALUE_CLASS, value.getClass(), this.valueClass);
            int keyLength = 0;
            boolean bl = this.sameKey = key == REPEAT_KEY;
            if (!this.sameKey) {
                this.keySerializer.serialize(key);
                keyLength = this.buffer.getLength();
                IFile.checkState(keyLength >= 0, IFile.NEGATIVE_KEY_LEN, keyLength, key);
                if (this.rle && keyLength == this.previous.getLength()) {
                    this.sameKey = BufferUtils.compare(this.previous, this.buffer) == 0;
                }
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            IFile.checkState(valueLength >= 0, IFile.NEGATIVE_VAL_LEN, valueLength, value);
            if (!this.sameKey) {
                this.writeKVPair(this.buffer.getData(), 0, keyLength, this.buffer.getData(), keyLength, this.buffer.getLength() - keyLength);
                if (this.rle) {
                    this.previous.reset();
                    this.previous.write(this.buffer.getData(), 0, keyLength);
                }
            } else {
                this.writeValue(this.buffer.getData(), keyLength, valueLength);
            }
            this.prevKey = this.sameKey ? REPEAT_KEY : key;
            this.buffer.reset();
            ++this.numRecordsWritten;
        }

        public void appendValue(Object value) throws IOException {
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength();
            IFile.checkState(valueLength >= 0, IFile.NEGATIVE_VAL_LEN, valueLength, value);
            this.writeValue(this.buffer.getData(), 0, valueLength);
            this.buffer.reset();
            ++this.numRecordsWritten;
            this.prevKey = REPEAT_KEY;
        }

        public void appendValue(DataInputBuffer value) throws IOException {
            int valueLength = value.getLength() - value.getPosition();
            IFile.checkState(valueLength >= 0, IFile.NEGATIVE_VAL_LEN, valueLength, value);
            this.writeValue(value.getData(), value.getPosition(), valueLength);
            this.buffer.reset();
            ++this.numRecordsWritten;
            this.prevKey = REPEAT_KEY;
        }

        public <V> void appendValues(Iterator<V> valuesItr) throws IOException {
            while (valuesItr.hasNext()) {
                this.appendValue(valuesItr.next());
            }
        }

        public <K, V> void appendKeyValues(K key, Iterator<V> valuesItr) throws IOException {
            if (valuesItr.hasNext()) {
                this.append(key, valuesItr.next());
            }
            while (valuesItr.hasNext()) {
                this.appendValue(valuesItr.next());
            }
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            IFile.checkState(key == REPEAT_KEY || keyLength >= 0, IFile.NEGATIVE_KEY_LEN, keyLength, key);
            int valueLength = value.getLength() - value.getPosition();
            IFile.checkState(valueLength >= 0, IFile.NEGATIVE_VAL_LEN, valueLength, value);
            boolean bl = this.sameKey = key == REPEAT_KEY;
            if (!this.sameKey && this.rle) {
                boolean bl2 = this.sameKey = keyLength != 0 && BufferUtils.compare(this.previous, key) == 0;
            }
            if (!this.sameKey) {
                this.writeKVPair(key.getData(), key.getPosition(), keyLength, value.getData(), value.getPosition(), valueLength);
                if (this.rle) {
                    BufferUtils.copy(key, this.previous);
                }
            } else {
                this.writeValue(value.getData(), value.getPosition(), valueLength);
            }
            this.prevKey = this.sameKey ? REPEAT_KEY : key;
            ++this.numRecordsWritten;
        }

        protected void writeValue(byte[] data, int offset, int length) throws IOException {
            this.writeRLE(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)length);
            this.out.write(data, offset, length);
            this.decompressedBytesWritten += (long)(length + WritableUtils.getVIntSize((long)length));
            if (this.serializedUncompressedBytes != null) {
                this.serializedUncompressedBytes.increment((long)length);
            }
            ++this.totalKeySaving;
        }

        protected void writeKVPair(byte[] keyData, int keyPos, int keyLength, byte[] valueData, int valPos, int valueLength) throws IOException {
            this.writeValueMarker(this.out);
            WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(keyData, keyPos, keyLength);
            this.out.write(valueData, valPos, valueLength);
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
            if (this.serializedUncompressedBytes != null) {
                this.serializedUncompressedBytes.increment((long)(keyLength + valueLength));
            }
        }

        protected void writeRLE(DataOutputStream out) throws IOException {
            if (this.prevKey != REPEAT_KEY) {
                WritableUtils.writeVInt((DataOutput)out, (int)-2);
                this.decompressedBytesWritten += (long)this.RLE_MARKER_SIZE;
                ++this.rleWritten;
            }
        }

        protected void writeValueMarker(DataOutputStream out) throws IOException {
            if (this.prevKey == REPEAT_KEY) {
                WritableUtils.writeVInt((DataOutput)out, (int)-3);
                this.decompressedBytesWritten += (long)this.V_END_MARKER_SIZE;
            }
        }

        public DataOutputStream getOutputStream() {
            return this.out;
        }

        public void updateCountersForExternalAppend(long length) {
            ++this.numRecordsWritten;
            this.decompressedBytesWritten += length;
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }
    }
}

