/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.broadcast.output.FileBasedKVWriter;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

public class UnorderedKVOutput
extends AbstractLogicalOutput {
    private static final Log LOG = LogFactory.getLog(UnorderedKVOutput.class);
    private FileBasedKVWriter kvWriter;
    private Configuration conf;
    private boolean dataViaEventsEnabled;
    private int dataViaEventsMaxSize;
    private static final Set<String> confKeys = new HashSet<String>();

    public UnorderedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public synchronized List<Event> initialize() throws Exception {
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.getContext().requestInitialMemory(0L, null);
        this.dataViaEventsEnabled = this.conf.getBoolean("tez.runtime.transfer.data-via-events.enabled", false);
        this.dataViaEventsMaxSize = this.conf.getInt("tez.runtime.transfer.data-via-events.max-size", 204800);
        LOG.info((Object)(((Object)((Object)this)).getClass().getSimpleName() + " running with params -> " + "dataViaEventsEnabled: " + this.dataViaEventsEnabled + ", dataViaEventsMaxSize: " + this.dataViaEventsMaxSize));
        this.kvWriter = new FileBasedKVWriter(this.getContext(), this.conf);
        return Collections.emptyList();
    }

    public synchronized void start() {
    }

    public synchronized KeyValuesWriter getWriter() throws Exception {
        return this.kvWriter;
    }

    public synchronized void handleEvents(List<Event> outputEvents) {
        throw new TezUncheckedException("Not expecting any events");
    }

    public synchronized List<Event> close() throws Exception {
        boolean outputGenerated = this.kvWriter.close();
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        LOG.info((Object)("Closing KVOutput: RawLength: " + this.kvWriter.getRawLength() + ", CompressedLength: " + this.kvWriter.getCompressedLength()));
        if (this.dataViaEventsEnabled && outputGenerated && this.kvWriter.getCompressedLength() <= (long)this.dataViaEventsMaxSize) {
            LOG.info((Object)("Serialzing actual data into DataMovementEvent, dataSize: " + this.kvWriter.getCompressedLength()));
            byte[] data = this.kvWriter.getData();
            ShuffleUserPayloads.DataProto.Builder dataProtoBuilder = ShuffleUserPayloads.DataProto.newBuilder();
            dataProtoBuilder.setData(ByteString.copyFrom((byte[])data));
            dataProtoBuilder.setRawLength((int)this.kvWriter.getRawLength());
            dataProtoBuilder.setCompressedLength((int)this.kvWriter.getCompressedLength());
            payloadBuilder.setData(dataProtoBuilder.build());
        }
        if (!outputGenerated) {
            LOG.info((Object)"No output was generated");
            BitSet emptyPartitions = new BitSet();
            emptyPartitions.set(0);
            ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)emptyPartitions));
            payloadBuilder.setEmptyPartitions(emptyPartitionsBytesString);
        }
        if (outputGenerated) {
            String host = this.getHost();
            ByteBuffer shuffleMetadata = this.getContext().getServiceProviderMetaData(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID);
            int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
            payloadBuilder.setHost(host);
            payloadBuilder.setPort(shufflePort);
            payloadBuilder.setPathComponent(this.getContext().getUniqueIdentifier());
        }
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        DataMovementEvent dmEvent = DataMovementEvent.create((int)0, (ByteBuffer)payloadProto.toByteString().asReadOnlyByteBuffer());
        ArrayList events = Lists.newArrayListWithCapacity((int)1);
        events.add(dmEvent);
        return events;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    String getHost() {
        return System.getenv(ApplicationConstants.Environment.NM_HOST.toString());
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.am.counters.max.keys");
        confKeys.add("tez.am.counters.group-name.max.keys");
        confKeys.add("tez.am.counters.name.max.keys");
        confKeys.add("tez.am.counters.groups.max.keys");
    }
}

