/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.List;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class ConcatenatedMergedKeyValueInput
extends MergedLogicalInput {
    public ConcatenatedMergedKeyValueInput(MergedInputContext context, List<Input> inputs) {
        super(context, inputs);
    }

    public KeyValueReader getReader() throws Exception {
        return new ConcatenatedMergedKeyValueReader();
    }

    public void setConstituentInputIsReady(Input input) {
        this.informInputReady();
    }

    public class ConcatenatedMergedKeyValueReader
    extends KeyValueReader {
        private int currentReaderIndex = 0;
        private KeyValueReader currentReader;

        @Override
        public boolean next() throws IOException {
            while (this.currentReader == null || !this.currentReader.next()) {
                if (this.currentReaderIndex == ConcatenatedMergedKeyValueInput.this.getInputs().size()) {
                    return false;
                }
                try {
                    Reader reader = ((Input)ConcatenatedMergedKeyValueInput.this.getInputs().get(this.currentReaderIndex)).getReader();
                    if (!(reader instanceof KeyValueReader)) {
                        throw new TezUncheckedException("Expected KeyValueReader. Got: " + reader.getClass().getName());
                    }
                    this.currentReader = (KeyValueReader)reader;
                    ++this.currentReaderIndex;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            return true;
        }

        @Override
        public Object getCurrentKey() throws IOException {
            return this.currentReader.getCurrentKey();
        }

        @Override
        public Object getCurrentValue() throws IOException {
            return this.currentReader.getCurrentValue();
        }
    }
}

