/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.FileChunk;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.impl.MergeManager;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;

class MapOutput {
    private static final Log LOG = LogFactory.getLog(MapOutput.class);
    private static AtomicInteger ID = new AtomicInteger(0);
    private final int id = ID.incrementAndGet();
    private final Type type;
    private InputAttemptIdentifier attemptIdentifier;
    private final long size;
    private final boolean primaryMapOutput;
    private final MergeManager merger;
    private final byte[] memory;
    private BoundedByteArrayOutputStream byteStream;
    private final FileSystem localFS;
    private final Path tmpOutputPath;
    private final FileChunk outputPath;
    private OutputStream disk;

    private MapOutput(Type type, InputAttemptIdentifier attemptIdentifier, MergeManager merger, long size, Path outputPath, long offset, boolean primaryMapOutput, FileSystem fs, Path tmpOutputPath) {
        this.type = type;
        this.attemptIdentifier = attemptIdentifier;
        this.merger = merger;
        this.primaryMapOutput = primaryMapOutput;
        this.localFS = fs;
        this.size = size;
        if (type == Type.MEMORY) {
            this.byteStream = new BoundedByteArrayOutputStream((int)size);
            this.memory = this.byteStream.getBuffer();
        } else {
            this.byteStream = null;
            this.memory = null;
        }
        this.tmpOutputPath = tmpOutputPath;
        this.disk = null;
        if (type == Type.DISK || type == Type.DISK_DIRECT) {
            boolean preserve = type == Type.DISK_DIRECT;
            this.outputPath = new FileChunk(outputPath, offset, size, preserve);
        } else {
            this.outputPath = null;
        }
    }

    public static MapOutput createDiskMapOutput(InputAttemptIdentifier attemptIdentifier, MergeManager merger, long size, Configuration conf, int fetcher, boolean primaryMapOutput, TezTaskOutputFiles mapOutputFile) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path outputpath = mapOutputFile.getInputFileForWrite(attemptIdentifier.getInputIdentifier().getInputIndex(), size);
        Path tmpOuputPath = outputpath.suffix(String.valueOf(fetcher));
        long offset = 0L;
        MapOutput mapOutput = new MapOutput(Type.DISK, attemptIdentifier, merger, size, outputpath, offset, primaryMapOutput, (FileSystem)fs, tmpOuputPath);
        mapOutput.disk = mapOutput.localFS.create(tmpOuputPath);
        return mapOutput;
    }

    public static MapOutput createLocalDiskMapOutput(InputAttemptIdentifier attemptIdentifier, MergeManager merger, Path path, long offset, long size, boolean primaryMapOutput) {
        return new MapOutput(Type.DISK_DIRECT, attemptIdentifier, merger, size, path, offset, primaryMapOutput, null, null);
    }

    public static MapOutput createMemoryMapOutput(InputAttemptIdentifier attemptIdentifier, MergeManager merger, int size, boolean primaryMapOutput) {
        return new MapOutput(Type.MEMORY, attemptIdentifier, merger, size, null, -1L, primaryMapOutput, null, null);
    }

    public static MapOutput createWaitMapOutput(InputAttemptIdentifier attemptIdentifier) {
        return new MapOutput(Type.WAIT, attemptIdentifier, null, -1L, null, -1L, false, null, null);
    }

    public boolean isPrimaryMapOutput() {
        return this.primaryMapOutput;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapOutput) {
            return this.id == ((MapOutput)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public FileChunk getOutputPath() {
        return this.outputPath;
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public BoundedByteArrayOutputStream getArrayStream() {
        return this.byteStream;
    }

    public OutputStream getDisk() {
        return this.disk;
    }

    public InputAttemptIdentifier getAttemptIdentifier() {
        return this.attemptIdentifier;
    }

    public Type getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public void commit() throws IOException {
        if (this.type == Type.MEMORY) {
            this.merger.closeInMemoryFile(this);
        } else if (this.type == Type.DISK) {
            this.localFS.rename(this.tmpOutputPath, this.outputPath.getPath());
            this.merger.closeOnDiskFile(this.outputPath);
        } else if (this.type == Type.DISK_DIRECT) {
            this.merger.closeOnDiskFile(this.outputPath);
        } else {
            throw new IOException("Cannot commit MapOutput of type WAIT!");
        }
    }

    public void abort() {
        if (this.type == Type.MEMORY) {
            this.merger.unreserve(this.memory.length);
        } else if (this.type == Type.DISK) {
            try {
                this.localFS.delete(this.tmpOutputPath, false);
            }
            catch (IOException ie) {
                LOG.info((Object)("failure to clean up " + this.tmpOutputPath), (Throwable)ie);
            }
        } else if (this.type != Type.DISK_DIRECT) {
            throw new IllegalArgumentException("Cannot commit MapOutput with of type WAIT!");
        }
    }

    public String toString() {
        return "MapOutput( AttemptIdentifier: " + this.attemptIdentifier + ", Type: " + (Object)((Object)this.type) + ")";
    }

    public static class MapOutputComparator
    implements Comparator<MapOutput> {
        @Override
        public int compare(MapOutput o1, MapOutput o2) {
            if (o1.id == o2.id) {
                return 0;
            }
            if (o1.size < o2.size) {
                return -1;
            }
            if (o1.size > o2.size) {
                return 1;
            }
            if (o1.id < o2.id) {
                return -1;
            }
            return 1;
        }
    }

    public static enum Type {
        WAIT,
        MEMORY,
        DISK,
        DISK_DIRECT;

    }
}

