/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.impl.InMemoryReader;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.testutils.KVDataGen;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestIFile {
    private static final Log LOG = LogFactory.getLog(TestIFile.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir = null;

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test
    public void testRepeatedKeysInMemReaderNoRLE() throws IOException {
        String outputFileName = "ifile.out";
        Path outputPath = new Path(workDir, outputFileName);
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true);
        IFile.Writer writer = this.writeTestFile(outputPath, false, data);
        FSDataInputStream inStream = localFs.open(outputPath);
        byte[] bytes = new byte[(int)writer.getRawLength()];
        this.readDataToMem(inStream, bytes);
        inStream.close();
        InMemoryReader inMemReader = new InMemoryReader(null, new InputAttemptIdentifier(0, 0), bytes, 0, bytes.length);
        this.readAndVerify((IFile.Reader)inMemReader, data);
    }

    @Test
    public void testRepeatedKeysFileReaderNoRLE() throws IOException {
        String outputFileName = "ifile.out";
        Path outputPath = new Path(workDir, outputFileName);
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true);
        this.writeTestFile(outputPath, false, data);
        IFile.Reader reader = new IFile.Reader(localFs, outputPath, null, null, null, false, 0, -1);
        this.readAndVerify(reader, data);
        reader.close();
    }

    @Ignore
    @Test
    public void testRepeatedKeysInMemReaderRLE() throws IOException {
        String outputFileName = "ifile.out";
        Path outputPath = new Path(workDir, outputFileName);
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true);
        IFile.Writer writer = this.writeTestFile(outputPath, true, data);
        FSDataInputStream inStream = localFs.open(outputPath);
        byte[] bytes = new byte[(int)writer.getRawLength()];
        this.readDataToMem(inStream, bytes);
        inStream.close();
        InMemoryReader inMemReader = new InMemoryReader(null, new InputAttemptIdentifier(0, 0), bytes, 0, bytes.length);
        this.readAndVerify((IFile.Reader)inMemReader, data);
    }

    @Ignore
    @Test
    public void testRepeatedKeysFileReaderRLE() throws IOException {
        String outputFileName = "ifile.out";
        Path outputPath = new Path(workDir, outputFileName);
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true);
        this.writeTestFile(outputPath, true, data);
        IFile.Reader reader = new IFile.Reader(localFs, outputPath, null, null, null, false, 0, -1);
        this.readAndVerify(reader, data);
        reader.close();
    }

    private void readDataToMem(FSDataInputStream inStream, byte[] bytes) throws IOException {
        int toRead = bytes.length;
        int offset = 0;
        while (toRead > 0) {
            int ret = inStream.read(bytes, offset, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            offset += ret;
        }
        LOG.info((Object)("Read: " + bytes.length + " bytes"));
    }

    private void readAndVerify(IFile.Reader reader, List<KVDataGen.KVPair> data) throws IOException {
        Text readKey = new Text();
        IntWritable readValue = new IntWritable();
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        SerializationFactory serializationFactory = new SerializationFactory(defaultConf);
        Deserializer keyDeserializer = serializationFactory.getDeserializer(Text.class);
        Deserializer valDeserializer = serializationFactory.getDeserializer(IntWritable.class);
        keyDeserializer.open((InputStream)keyIn);
        valDeserializer.open((InputStream)valIn);
        int numRecordsRead = 0;
        while (reader.nextRawKey(keyIn)) {
            reader.nextRawValue(valIn);
            readKey = (Text)keyDeserializer.deserialize((Object)readKey);
            readValue = (IntWritable)valDeserializer.deserialize((Object)readValue);
            KVDataGen.KVPair expected = data.get(numRecordsRead);
            Assert.assertEquals((String)("Key does not match: Expected: " + expected.getKey() + ", Read: " + readKey), (Object)expected.getKey(), (Object)readKey);
            Assert.assertEquals((String)("Value does not match: Expected: " + expected.getvalue() + ", Read: " + readValue), (Object)expected.getvalue(), (Object)readValue);
            ++numRecordsRead;
        }
        Assert.assertEquals((String)("Expected: " + data.size() + " records, but found: " + numRecordsRead), (long)data.size(), (long)numRecordsRead);
        LOG.info((Object)("Found: " + numRecordsRead + " records"));
    }

    private IFile.Writer writeTestFile(Path outputPath, boolean useRle, List<KVDataGen.KVPair> data) throws IOException {
        IFile.Writer writer = new IFile.Writer(defaultConf, localFs, outputPath, Text.class, IntWritable.class, null, null, null);
        writer.setRLE(useRle);
        for (KVDataGen.KVPair kvp : data) {
            writer.append((Object)kvp.getKey(), (Object)kvp.getvalue());
        }
        writer.close();
        LOG.info((Object)("Uncompressed: " + writer.getRawLength()));
        LOG.info((Object)("CompressedSize: " + writer.getCompressedLength()));
        return writer;
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestIFile.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            LOG.info((Object)("Using workDir: " + workDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

