/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.broadcast.input;

import java.io.IOException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.broadcast.input.BroadcastInputManager;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.shuffle.common.FetchedInput;
import org.junit.Assert;
import org.junit.Test;

public class TestBroadcastInputManager {
    private static final Log LOG = LogFactory.getLog(TestBroadcastInputManager.class);

    @Test
    public void testInMemAllocation() throws IOException {
        String localDirs = "/tmp/" + this.getClass().getName();
        Configuration conf = new Configuration();
        long jvmMax = Runtime.getRuntime().maxMemory();
        LOG.info((Object)("jvmMax: " + jvmMax));
        float bufferPercent = 0.1f;
        conf.setFloat("tez.runtime.shuffle.input.buffer.percent", bufferPercent);
        conf.setFloat("tez.runtime.shuffle.memory.limit.percent", 1.0f);
        conf.setStrings("tez.runtime.local.dirs", new String[]{localDirs});
        long inMemThreshold = (long)(bufferPercent * (float)jvmMax);
        LOG.info((Object)("InMemThreshold: " + inMemThreshold));
        BroadcastInputManager inputManager = new BroadcastInputManager(UUID.randomUUID().toString(), conf, Runtime.getRuntime().maxMemory());
        inputManager.setInitialMemoryAvailable(inMemThreshold);
        inputManager.configureAndStart();
        long requestSize = (long)(0.4f * (float)inMemThreshold);
        long compressedSize = 1L;
        LOG.info((Object)("RequestSize: " + requestSize));
        FetchedInput fi1 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(1, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi1.getType());
        FetchedInput fi2 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(2, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi2.getType());
        FetchedInput fi3 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(3, 1));
        Assert.assertEquals((Object)FetchedInput.Type.DISK, (Object)fi3.getType());
        fi1.abort();
        fi1.free();
        FetchedInput fi4 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(4, 1));
        Assert.assertEquals((Object)FetchedInput.Type.MEMORY, (Object)fi4.getType());
        fi3.abort();
        fi3.free();
        FetchedInput fi5 = inputManager.allocate(requestSize, compressedSize, new InputAttemptIdentifier(4, 1));
        Assert.assertEquals((Object)FetchedInput.Type.DISK, (Object)fi5.getType());
    }
}

