/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.processor;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SleepProcessor
implements LogicalIOProcessor {
    private static final Log LOG = LogFactory.getLog(SleepProcessor.class);
    private int timeToSleepMS;

    public void initialize(TezProcessorContext processorContext) throws Exception {
        if (processorContext.getUserPayload() == null) {
            LOG.info((Object)"No processor user payload specified, using default timeToSleep of 1 ms");
            this.timeToSleepMS = 1;
        } else {
            SleepProcessorConfig cfg = new SleepProcessorConfig();
            cfg.fromUserPayload(processorContext.getUserPayload());
            this.timeToSleepMS = cfg.getTimeToSleepMS();
        }
        LOG.info((Object)("Initialized SleepProcessor, timeToSleepMS=" + this.timeToSleepMS));
    }

    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        LOG.info((Object)("Running the Sleep Processor, sleeping for " + this.timeToSleepMS + " ms"));
        try {
            Thread.sleep(this.timeToSleepMS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void handleEvents(List<Event> processorEvents) {
    }

    public void close() throws Exception {
    }

    public static class SleepProcessorConfig {
        private int timeToSleepMS;

        public SleepProcessorConfig() {
        }

        public SleepProcessorConfig(int timeToSleepMS) {
            this.timeToSleepMS = timeToSleepMS;
        }

        public byte[] toUserPayload() {
            return Integer.toString(this.timeToSleepMS).getBytes();
        }

        public void fromUserPayload(byte[] userPayload) {
            this.timeToSleepMS = Integer.valueOf(new String(userPayload));
        }

        public int getTimeToSleepMS() {
            return this.timeToSleepMS;
        }
    }
}

