/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BufferUtils;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.library.common.sort.impl.IFileInputStream;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFile {
    private static final Log LOG = LogFactory.getLog(IFile.class);
    public static final int EOF_MARKER = -1;
    public static final int RLE_MARKER = -2;
    public static final DataInputBuffer REPEAT_KEY = new DataInputBuffer();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Reader {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private long numRecordsRead = 0L;
        private final TezCounter readRecordsCounter;
        final InputStream in;
        Decompressor decompressor;
        public long bytesRead = 0L;
        protected final long fileLength;
        protected boolean eof = false;
        final IFileInputStream checksumIn;
        protected byte[] buffer = null;
        protected int bufferSize = 131072;
        protected DataInputStream dataIn;
        protected int recNo = 1;
        protected int prevKeyLength;
        protected int currentKeyLength;
        protected int currentValueLength;
        byte[] keyBytes = new byte[0];

        public Reader(FileSystem fs, Path file, CompressionCodec codec, TezCounter readsCounter, boolean ifileReadAhead, int ifileReadAheadLength, int bufferSize) throws IOException {
            this((InputStream)fs.open(file), fs.getFileStatus(file).getLen(), codec, readsCounter, ifileReadAhead, ifileReadAheadLength, bufferSize);
        }

        public Reader(InputStream in, long length, CompressionCodec codec, TezCounter readsCounter, boolean readAhead, int readAheadLength, int bufferSize) throws IOException {
            this.readRecordsCounter = readsCounter;
            this.checksumIn = new IFileInputStream(in, length, readAhead, readAheadLength);
            if (codec != null) {
                this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (this.decompressor != null) {
                    this.in = codec.createInputStream((InputStream)this.checksumIn, this.decompressor);
                } else {
                    LOG.warn((Object)"Could not obtain decompressor from CodecPool");
                    this.in = this.checksumIn;
                }
            } else {
                this.in = this.checksumIn;
            }
            this.dataIn = new DataInputStream(this.in);
            this.fileLength = length;
            if (bufferSize != -1) {
                this.bufferSize = bufferSize;
            }
        }

        public long getLength() {
            return this.fileLength - this.checksumIn.getSize();
        }

        public long getPosition() throws IOException {
            return this.checksumIn.getPosition();
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = IOUtils.wrappedReadForCompressedData((InputStream)this.in, (byte[])buf, (int)(off + bytesRead), (int)(len - bytesRead));
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        protected boolean positionToNextRecord(DataInput dIn) throws IOException {
            if (this.eof) {
                throw new EOFException("Completed reading " + this.bytesRead);
            }
            this.prevKeyLength = this.currentKeyLength;
            this.currentKeyLength = WritableUtils.readVInt((DataInput)dIn);
            this.currentValueLength = WritableUtils.readVInt((DataInput)dIn);
            this.bytesRead += (long)(WritableUtils.getVIntSize((long)this.currentKeyLength) + WritableUtils.getVIntSize((long)this.currentValueLength));
            if (this.currentKeyLength == -1 && this.currentValueLength == -1) {
                this.eof = true;
                return false;
            }
            if (this.currentKeyLength != -2 && this.currentKeyLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + this.currentKeyLength);
            }
            if (this.currentValueLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + this.currentValueLength);
            }
            return true;
        }

        public boolean nextRawKey(DataInputBuffer key) throws IOException {
            return this.readRawKey(key) != KeyState.NO_KEY;
        }

        public KeyState readRawKey(DataInputBuffer key) throws IOException {
            int i;
            if (!this.positionToNextRecord(this.dataIn)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("currentKeyLength=" + this.currentKeyLength + ", currentValueLength=" + this.currentValueLength + ", bytesRead=" + this.bytesRead + ", length=" + this.fileLength));
                }
                return KeyState.NO_KEY;
            }
            if (this.currentKeyLength == -2) {
                this.currentKeyLength = this.prevKeyLength;
                key.reset(this.keyBytes, this.currentKeyLength);
                return KeyState.SAME_KEY;
            }
            if (this.keyBytes.length < this.currentKeyLength) {
                this.keyBytes = new byte[this.currentKeyLength << 1];
            }
            if ((i = this.readData(this.keyBytes, 0, this.currentKeyLength)) != this.currentKeyLength) {
                throw new IOException("Asked for " + this.currentKeyLength + " Got: " + i);
            }
            key.reset(this.keyBytes, this.currentKeyLength);
            this.bytesRead += (long)this.currentKeyLength;
            return KeyState.NEW_KEY;
        }

        public void nextRawValue(DataInputBuffer value) throws IOException {
            byte[] valBytes = value.getData().length < this.currentValueLength || value.getData() == this.keyBytes ? new byte[this.currentValueLength << 1] : value.getData();
            int i = this.readData(valBytes, 0, this.currentValueLength);
            if (i != this.currentValueLength) {
                throw new IOException("Asked for " + this.currentValueLength + " Got: " + i);
            }
            value.reset(valBytes, this.currentValueLength);
            this.bytesRead += (long)this.currentValueLength;
            ++this.recNo;
            ++this.numRecordsRead;
        }

        public void close() throws IOException {
            this.in.close();
            this.dataIn = null;
            this.buffer = null;
            if (this.readRecordsCounter != null) {
                this.readRecordsCounter.increment(this.numRecordsRead);
            }
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }

        public void reset(int offset) {
        }

        public void disableChecksumValidation() {
            this.checksumIn.disableChecksumValidation();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum KeyState {
            NO_KEY,
            NEW_KEY,
            SAME_KEY;

        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Writer {
        FSDataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        FSDataOutputStream rawOut;
        AtomicBoolean closed = new AtomicBoolean(false);
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        private long numRecordsWritten = 0L;
        private final TezCounter writtenRecordsCounter;
        IFileOutputStream checksumOut;
        Class keyClass;
        Class valueClass;
        Serializer keySerializer;
        Serializer valueSerializer;
        DataOutputBuffer buffer = new DataOutputBuffer();
        DataOutputBuffer previous = new DataOutputBuffer();
        private boolean rle = false;

        public Writer(Configuration conf, FileSystem fs, Path file, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec, writesCounter);
            this.ownOutputStream = true;
        }

        protected Writer(TezCounter writesCounter) {
            this.writtenRecordsCounter = writesCounter;
        }

        public Writer(Configuration conf, FSDataOutputStream out, Class keyClass, Class valueClass, CompressionCodec codec, TezCounter writesCounter) throws IOException {
            this.writtenRecordsCounter = writesCounter;
            this.checksumOut = new IFileOutputStream((OutputStream)out);
            this.rawOut = out;
            this.start = this.rawOut.getPos();
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (this.compressor != null) {
                    this.compressor.reset();
                    this.compressedOut = codec.createOutputStream((OutputStream)this.checksumOut, this.compressor);
                    this.out = new FSDataOutputStream((OutputStream)this.compressedOut, null);
                    this.compressOutput = true;
                } else {
                    LOG.warn((Object)"Could not obtain compressor from CodecPool");
                    this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
                }
            } else {
                this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
            }
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            if (keyClass != null) {
                SerializationFactory serializationFactory = new SerializationFactory(conf);
                this.keySerializer = serializationFactory.getSerializer(keyClass);
                this.keySerializer.open((OutputStream)this.buffer);
                this.valueSerializer = serializationFactory.getSerializer(valueClass);
                this.valueSerializer.open((OutputStream)this.buffer);
            }
        }

        public Writer(Configuration conf, FileSystem fs, Path file) throws IOException {
            this(conf, fs, file, null, null, null, null);
        }

        public void close() throws IOException {
            if (this.closed.getAndSet(true)) {
                throw new IOException("Writer was already closed earlier");
            }
            if (this.keyClass != null) {
                this.keySerializer.close();
                this.valueSerializer.close();
            }
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize((long)-1L));
            this.out.flush();
            if (this.compressOutput) {
                this.compressedOut.finish();
                this.compressedOut.resetState();
            }
            if (this.ownOutputStream) {
                this.out.close();
            } else {
                this.checksumOut.finish();
            }
            this.compressedBytesWritten = this.rawOut.getPos() - this.start;
            if (this.compressOutput) {
                CodecPool.returnCompressor((Compressor)this.compressor);
                this.compressor = null;
            }
            this.out = null;
            if (this.writtenRecordsCounter != null) {
                this.writtenRecordsCounter.increment(this.numRecordsWritten);
            }
        }

        public void append(Object key, Object value) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass() + " is not " + this.keyClass);
            }
            if (value.getClass() != this.valueClass) {
                throw new IOException("wrong value class: " + value.getClass() + " is not " + this.valueClass);
            }
            boolean sameKey = false;
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            if (this.rle && keyLength == this.previous.getLength()) {
                boolean bl = sameKey = BufferUtils.compare(this.previous, this.buffer) == 0;
            }
            if (!sameKey) {
                BufferUtils.copy(this.buffer, this.previous);
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            if (this.rle && sameKey) {
                WritableUtils.writeVInt((DataOutput)this.out, (int)-2);
                WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
                this.out.write(this.buffer.getData(), keyLength, this.buffer.getLength());
                this.decompressedBytesWritten += (long)(0 + valueLength + WritableUtils.getVIntSize((long)-2L) + WritableUtils.getVIntSize((long)valueLength));
            } else {
                WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
                WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
                this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
                this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
            }
            this.buffer.reset();
            ++this.numRecordsWritten;
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            int valueLength = value.getLength() - value.getPosition();
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            boolean sameKey = false;
            if (this.rle && keyLength == this.previous.getLength()) {
                boolean bl = sameKey = keyLength != 0 && BufferUtils.compare(this.previous, key) == 0;
            }
            if (this.rle && sameKey) {
                WritableUtils.writeVInt((DataOutput)this.out, (int)-2);
                WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
                this.out.write(value.getData(), value.getPosition(), valueLength);
                this.decompressedBytesWritten += (long)(0 + valueLength + WritableUtils.getVIntSize((long)-2L) + WritableUtils.getVIntSize((long)valueLength));
            } else {
                WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
                WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
                this.out.write(key.getData(), key.getPosition(), keyLength);
                this.out.write(value.getData(), value.getPosition(), valueLength);
                this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
                BufferUtils.copy(key, this.previous);
            }
            ++this.numRecordsWritten;
        }

        public DataOutputStream getOutputStream() {
            return this.out;
        }

        public void updateCountersForExternalAppend(long length) {
            ++this.numRecordsWritten;
            this.decompressedBytesWritten += length;
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }

        public void setRLE(boolean rle) {
            this.rle = rle;
            this.previous.reset();
        }
    }
}

