/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    public static Class<? extends CompressionCodec> getIntermediateOutputCompressorClass(Configuration conf, Class<DefaultCodec> defaultValue) {
        Class<DefaultCodec> codecClass = defaultValue;
        String name = conf.get("tez.runtime.intermediate-output.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public static Class<? extends CompressionCodec> getIntermediateInputCompressorClass(Configuration conf, Class<DefaultCodec> defaultValue) {
        Class<DefaultCodec> codecClass = defaultValue;
        String name = conf.get("tez.runtime.intermediate-input.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public static boolean shouldCompressIntermediateOutput(Configuration conf) {
        return conf.getBoolean("tez.runtime.intermediate-output.should-compress", false);
    }

    public static boolean isIntermediateInputCompressed(Configuration conf) {
        return conf.getBoolean("tez.runtime.intermdiate-input.is-compressed", false);
    }

    public static <V> Class<V> getIntermediateOutputValueClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.intermediate-output.value.class", null, Object.class);
        return retv;
    }

    public static <V> Class<V> getIntermediateInputValueClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.intermediate-input.value.class", null, Object.class);
        return retv;
    }

    public static <K> Class<K> getIntermediateOutputKeyClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.intermediate-output.key.class", null, Object.class);
        return retv;
    }

    public static <K> Class<K> getIntermediateInputKeyClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.intermediate-input.key.class", null, Object.class);
        return retv;
    }

    public static <K> RawComparator<K> getIntermediateOutputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.intermediate-output.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateOutputKeyClass(conf).asSubclass(WritableComparable.class));
    }

    public static <K> RawComparator<K> getIntermediateInputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.intermediate-input.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateInputKeyClass(conf).asSubclass(WritableComparable.class));
    }

    public static <V> RawComparator<V> getInputKeySecondaryGroupingComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.intermediate-input.key.secondary.comparator.class", null, RawComparator.class);
        if (theClass == null) {
            return ConfigUtils.getIntermediateInputKeyComparator(conf);
        }
        return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
    }

    public static boolean useNewApi(Configuration conf) {
        return conf.getBoolean("mapred.mapper.new-api", false);
    }
}

