/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.broadcast.input;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutputFiles;
import org.apache.tez.runtime.library.shuffle.common.DiskFetchedInput;
import org.apache.tez.runtime.library.shuffle.common.FetchedInput;
import org.apache.tez.runtime.library.shuffle.common.FetchedInputAllocator;
import org.apache.tez.runtime.library.shuffle.common.FetchedInputCallback;
import org.apache.tez.runtime.library.shuffle.common.MemoryFetchedInput;

public class BroadcastInputManager
implements FetchedInputAllocator,
FetchedInputCallback {
    private static final Log LOG = LogFactory.getLog(BroadcastInputManager.class);
    private final Configuration conf;
    private final TezTaskOutputFiles fileNameAllocator;
    private final LocalDirAllocator localDirAllocator;
    private final long memoryLimit;
    private final long maxSingleShuffleLimit;
    private volatile long usedMemory = 0L;

    public BroadcastInputManager(String uniqueIdentifier, Configuration conf) {
        this.conf = conf;
        this.fileNameAllocator = new TezTaskOutputFiles(conf, uniqueIdentifier);
        this.localDirAllocator = new LocalDirAllocator("tez.runtime.local.dirs");
        float maxInMemCopyUse = conf.getFloat("tez.runtime.shuffle.input.buffer.percent", 0.9f);
        if ((double)maxInMemCopyUse > 1.0 || (double)maxInMemCopyUse < 0.0) {
            throw new IllegalArgumentException("Invalid value for tez.runtime.shuffle.input.buffer.percent: " + maxInMemCopyUse);
        }
        this.memoryLimit = (long)((float)conf.getLong("tez.runtime.task.memory", Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE)) * maxInMemCopyUse);
        float singleShuffleMemoryLimitPercent = conf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.25f);
        if (singleShuffleMemoryLimitPercent <= 0.0f || singleShuffleMemoryLimitPercent > 1.0f) {
            throw new IllegalArgumentException("Invalid value for tez.runtime.shuffle.memory.limit.percent: " + singleShuffleMemoryLimitPercent);
        }
        this.maxSingleShuffleLimit = (long)((float)this.memoryLimit * singleShuffleMemoryLimitPercent);
        LOG.info((Object)("BroadcastInputManager -> MemoryLimit: " + this.memoryLimit + ", maxSingleMemLimit: " + this.maxSingleShuffleLimit));
    }

    public synchronized FetchedInput allocate(long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier) throws IOException {
        if (actualSize > this.maxSingleShuffleLimit || this.usedMemory + actualSize > this.memoryLimit) {
            return new DiskFetchedInput(actualSize, compressedSize, inputAttemptIdentifier, this, this.conf, this.localDirAllocator, this.fileNameAllocator);
        }
        this.usedMemory += actualSize;
        LOG.info((Object)("Used memory after allocating " + actualSize + " : " + this.usedMemory));
        return new MemoryFetchedInput(actualSize, compressedSize, inputAttemptIdentifier, this);
    }

    public synchronized void fetchComplete(FetchedInput fetchedInput) {
        switch (fetchedInput.getType()) {
            case DISK: 
            case MEMORY: {
                break;
            }
            default: {
                throw new TezUncheckedException("InputType: " + (Object)((Object)fetchedInput.getType()) + " not expected for Broadcast fetch");
            }
        }
    }

    public synchronized void fetchFailed(FetchedInput fetchedInput) {
        this.cleanup(fetchedInput);
    }

    public synchronized void freeResources(FetchedInput fetchedInput) {
        this.cleanup(fetchedInput);
    }

    private void cleanup(FetchedInput fetchedInput) {
        switch (fetchedInput.getType()) {
            case DISK: {
                break;
            }
            case MEMORY: {
                this.unreserve(fetchedInput.getActualSize());
                break;
            }
            default: {
                throw new TezUncheckedException("InputType: " + (Object)((Object)fetchedInput.getType()) + " not expected for Broadcast fetch");
            }
        }
    }

    private synchronized void unreserve(long size) {
        this.usedMemory -= size;
        LOG.info((Object)("Used memory after freeing " + size + " : " + this.usedMemory));
    }
}

