/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.OrderedGroupedKVInputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestOrderedGroupedMergedKVInputConfig {
    @Test(timeout=5000L)
    public void testNullParams() {
        try {
            OrderedGroupedKVInputConfig.newBuilder(null, (String)"VALUE");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            OrderedGroupedKVInputConfig.newBuilder((String)"KEY", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test(timeout=5000L)
    public void testSetters() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.ifile.readahead.bytes", 1111);
        fromConf.set("io.shouldExist", "io");
        fromConf.setInt("tez.runtime.shuffle.min.failures.per.host", 3);
        fromConf.setFloat("tez.runtime.shuffle.acceptable.host-fetch.failure.fraction", 0.1f);
        fromConf.setFloat("tez.runtime.shuffle.max.stall.time.fraction", 0.6f);
        fromConf.setInt("tez.runtime.shuffle.src-attempt.abort.limit", 10);
        fromConf.setFloat("tez.runtime.shuffle.max.allowed.failed.fetch.fraction", 0.2f);
        fromConf.setFloat("tez.runtime.shuffle.min.required.progress.fraction", 0.6f);
        fromConf.setBoolean("tez.runtime.shuffle.failed.check.since-last.completion", false);
        Configuration fromConfUnfiltered = new Configuration(false);
        fromConfUnfiltered.set("test.conf.unfiltered.1", "unfiltered1");
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("test.key.2", "key2");
        additionalConf.put("tez.runtime.io.sort.factor", "3");
        additionalConf.put("file.shouldExist", "file");
        OrderedGroupedKVInputConfig.Builder builder = OrderedGroupedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE").setKeyComparatorClass("KEY_COMPARATOR", null).setCompression(true, "CustomCodec", null).setMaxSingleMemorySegmentFraction(0.11f).setMergeFraction(0.22f).setPostMergeBufferFraction(0.33f).setShuffleBufferFraction(0.44f).setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("tez.runtime.ifile.readahead", String.valueOf(false)).setAdditionalConfiguration(additionalConf).setFromConfiguration(fromConf).setFromConfigurationUnfiltered(fromConfUnfiltered);
        OrderedGroupedKVInputConfig configuration = builder.build();
        OrderedGroupedKVInputConfig rebuilt = new OrderedGroupedKVInputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((float)0.11f, (float)conf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)conf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)conf.getFloat("tez.runtime.task.input.post-merge.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.44f, (float)conf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.1f, (float)conf.getFloat("tez.runtime.shuffle.acceptable.host-fetch.failure.fraction", 0.0f), (float)0.001f);
        Assert.assertEquals((float)3.0f, (float)conf.getInt("tez.runtime.shuffle.min.failures.per.host", 0), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)conf.getInt("tez.runtime.shuffle.src-attempt.abort.limit", 0), (float)0.0f);
        Assert.assertEquals((float)0.6f, (float)conf.getFloat("tez.runtime.shuffle.max.stall.time.fraction", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.2f, (float)conf.getFloat("tez.runtime.shuffle.max.allowed.failed.fetch.fraction", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.6f, (float)conf.getFloat("tez.runtime.shuffle.min.required.progress.fraction", 0.6f), (float)0.001f);
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.shuffle.failed.check.since-last.completion", true));
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000));
        Assert.assertEquals((long)3L, (long)conf.getInt("tez.runtime.io.sort.factor", -1));
        Assert.assertEquals((Object)"io", (Object)conf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)conf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)conf.get("fs.shouldExist"));
        Assert.assertNull((Object)conf.get("test.conf.key.1"));
        Assert.assertNull((Object)conf.get("test.key.1"));
        Assert.assertNull((Object)conf.get("test.key.2"));
        Assert.assertEquals((Object)"unfiltered1", (Object)conf.get("test.conf.unfiltered.1"));
    }

    @Test(timeout=5000L)
    public void testDefaultConfigsUsed() {
        OrderedGroupedKVInputConfig.Builder builder = OrderedGroupedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE");
        OrderedGroupedKVInputConfig configuration = builder.build();
        OrderedGroupedKVInputConfig rebuilt = new OrderedGroupedKVInputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
    }

    @Test(timeout=5000L)
    public void testCombinerConfigs() {
        HashMap combinerConf = Maps.newHashMap();
        combinerConf.put("combiner.test.key", "COMBINERKEY");
        combinerConf.put("tez.runtime.compress.codec", "InvalidKeyOverride");
        OrderedGroupedKVInputConfig.Builder builder = OrderedGroupedKVInputConfig.newBuilder((String)"KEY", (String)"VALUE").setCombiner("COMBINER", (Map)combinerConf);
        OrderedGroupedKVInputConfig configuration = builder.build();
        OrderedGroupedKVInputConfig rebuilt = new OrderedGroupedKVInputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"COMBINERKEY", (Object)conf.get("combiner.test.key"));
    }
}

