/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.cartesianproduct;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductConfig;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductFilterDescriptor;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductUserPayload;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCartesianProductConfig {
    private TezConfiguration conf;

    @Before
    public void setup() {
        this.conf = new TezConfiguration();
    }

    @Test(timeout=5000L)
    public void testSerializationPartitioned() throws IOException {
        HashMap<String, Integer> vertexPartitionMap = new HashMap<String, Integer>();
        vertexPartitionMap.put("v1", 2);
        vertexPartitionMap.put("v2", 3);
        vertexPartitionMap.put("v3", 4);
        String filterClassName = "filter";
        byte[] bytes = new byte[10];
        new Random().nextBytes(bytes);
        CartesianProductFilterDescriptor filterDescriptor = (CartesianProductFilterDescriptor)new CartesianProductFilterDescriptor(filterClassName).setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(bytes)));
        CartesianProductConfig config = new CartesianProductConfig(vertexPartitionMap, filterDescriptor);
        UserPayload payload = config.toUserPayload(this.conf);
        CartesianProductConfig parsedConfig = CartesianProductConfig.fromUserPayload((UserPayload)payload);
        this.assertConfigEquals(config, parsedConfig);
    }

    @Test(timeout=5000L)
    public void testSerializationFair() throws Exception {
        ArrayList<String> sourceVertices = new ArrayList<String>();
        sourceVertices.add("v1");
        sourceVertices.add("v2");
        sourceVertices.add("v3");
        CartesianProductConfig config = new CartesianProductConfig(sourceVertices);
        UserPayload payload = config.toUserPayload(this.conf);
        CartesianProductConfig parsedConfig = CartesianProductConfig.fromUserPayload((UserPayload)payload);
        this.assertConfigEquals(config, parsedConfig);
        try {
            config = new CartesianProductConfig(false, new int[0], new String[]{"v0", "v1"}, null);
            config.checkNumPartitions();
        }
        catch (Exception e) {
            return;
        }
        throw new Exception();
    }

    private void assertConfigEquals(CartesianProductConfig config1, CartesianProductConfig config2) {
        Assert.assertArrayEquals((Object[])config1.getSourceVertices().toArray(new String[0]), (Object[])config2.getSourceVertices().toArray(new String[0]));
        if (config1.getNumPartitions() == null) {
            Assert.assertNull((Object)config2.getNumPartitions());
        } else {
            Assert.assertArrayEquals((int[])Ints.toArray((Collection)config1.getNumPartitions()), (int[])Ints.toArray((Collection)config2.getNumPartitions()));
        }
        CartesianProductFilterDescriptor descriptor1 = config1.getFilterDescriptor();
        CartesianProductFilterDescriptor descriptor2 = config1.getFilterDescriptor();
        if (descriptor1 != null && descriptor2 != null) {
            Assert.assertEquals((Object)descriptor1.getClassName(), (Object)descriptor2.getClassName());
            UserPayload payload1 = descriptor1.getUserPayload();
            UserPayload payload2 = descriptor2.getUserPayload();
            if (payload1 != null && payload2 != null) {
                Assert.assertEquals((long)0L, (long)payload1.getPayload().compareTo(payload2.getPayload()));
            }
        } else {
            Assert.assertNull((Object)descriptor1);
            Assert.assertNull((Object)descriptor2);
        }
    }

    @Test(timeout=5000L)
    public void testFairCartesianProductConfig() {
        ArrayList<String> sourceVertices = new ArrayList<String>();
        sourceVertices.add("v0");
        sourceVertices.add("v1");
        CartesianProductConfig config = new CartesianProductConfig(sourceVertices);
        CartesianProductUserPayload.CartesianProductConfigProto proto = config.toProto(this.conf);
        Assert.assertEquals((long)1000L, (long)proto.getMaxParallelism());
        Assert.assertEquals((long)1000000L, (long)proto.getMinOpsPerWorker());
        Assert.assertEquals((Object)true, (Object)proto.getEnableGrouping());
        Assert.assertFalse((boolean)proto.hasNumPartitionsForFairCase());
        Assert.assertFalse((boolean)proto.hasGroupingFraction());
        this.conf.setInt("tez.cartesian-product.max-parallelism", 1000);
        this.conf.setLong("tez.cartesian-product.min-ops-per-worker", 1000000L);
        this.conf.setBoolean("tez.cartesian-product.disable-grouping", false);
        this.conf.setFloat("tez.cartesian-product.grouping-fraction", 0.75f);
        this.conf.setInt("tez.cartesian-product.num-partitions", 25);
        proto = config.toProto(this.conf);
        Assert.assertEquals((long)1000L, (long)proto.getMaxParallelism());
        Assert.assertEquals((long)1000000L, (long)proto.getMinOpsPerWorker());
        Assert.assertFalse((boolean)proto.getEnableGrouping());
        Assert.assertEquals((double)0.75, (double)proto.getGroupingFraction(), (double)0.01);
        Assert.assertEquals((long)25L, (long)proto.getNumPartitionsForFairCase());
    }
}

