/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.library.edgemanager.SilentEdgeManager;
import org.apache.tez.dag.library.vertexmanager.TestShuffleVertexManager;
import org.apache.tez.dag.library.vertexmanager.VertexManagerWithConcurrentInput;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestVertexManagerWithConcurrentInput {
    @Captor
    ArgumentCaptor<List<VertexManagerPluginContext.ScheduleTaskRequest>> requestCaptor;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeout=5000L)
    public void testBasicVertexWithConcurrentInput() throws Exception {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        int srcVertex1Parallelism = 2;
        EdgeProperty eProp1 = EdgeProperty.create((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)SilentEdgeManager.class.getName()), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.EPHEMERAL, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.CONCURRENT, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId2 = "Vertex2";
        int srcVertex2Parallelism = 3;
        EdgeProperty eProp2 = EdgeProperty.create((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)SilentEdgeManager.class.getName()), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.EPHEMERAL, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.CONCURRENT, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        int vertexParallelism = 2;
        VertexManagerWithConcurrentInput.ConcurrentInputVertexManagerConfigBuilder configurer = VertexManagerWithConcurrentInput.createConfigBuilder(null);
        VertexManagerPluginDescriptor pluginDesc = configurer.build();
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getUserPayload()).thenReturn((Object)pluginDesc.getUserPayload());
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)vertexParallelism);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)srcVertex1Parallelism);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId2)).thenReturn((Object)srcVertex2Parallelism);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        mockInputVertices.put(mockSrcVertexId2, eProp2);
        VertexManagerWithConcurrentInput manager = new VertexManagerWithConcurrentInput(mockContext);
        Mockito.when((Object)mockContext.getUserPayload()).thenReturn((Object)pluginDesc.getUserPayload());
        manager.initialize();
        Mockito.when((Object)mockContext.getUserPayload()).thenReturn((Object)pluginDesc.getUserPayload());
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId1, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onVertexStateUpdated(new VertexStateUpdate(mockSrcVertexId2, VertexState.CONFIGURED));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleTasks((List)this.requestCaptor.capture());
        manager.onVertexStarted(Collections.singletonList(TestShuffleVertexManager.createTaskAttemptIdentifier(mockSrcVertexId1, 0)));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)0L, (long)manager.completedUpstreamTasks);
    }
}

