/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl.dflt;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.Deflater;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.OutputStatisticsReporter;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestDefaultSorter {
    private static final int PORT = 80;
    private static final String UniqueID = "UUID";
    private static FileSystem localFs = null;
    private static Path workingDir = null;
    private Configuration conf;
    private LocalDirAllocator dirAllocator;

    @Before
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.conf.set("fs.permissions.umask-mode", "077");
        this.conf.set("tez.runtime.sorter.class", OrderedPartitionedKVOutputConfig.SorterImpl.LEGACY.name());
        this.conf.set("fs.defaultFS", "file:///");
        localFs = FileSystem.getLocal((Configuration)this.conf);
        workingDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestDefaultSorter.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
        String localDirs = workingDir.toString();
        this.conf.set("tez.runtime.key.class", Text.class.getName());
        this.conf.set("tez.runtime.value.class", Text.class.getName());
        this.conf.set("tez.runtime.partitioner.class", HashPartitioner.class.getName());
        this.conf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDirs});
        this.dirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
    }

    @AfterClass
    public static void cleanup() throws IOException {
        localFs.delete(workingDir, true);
    }

    @After
    public void reset() throws IOException {
        TestDefaultSorter.cleanup();
        localFs.mkdirs(workingDir);
    }

    @Test(timeout=5000L)
    public void testSortSpillPercent() throws Exception {
        OutputContext context = this.createTezOutputContext();
        this.conf.setFloat("tez.runtime.sort.spill.percent", 0.0f);
        try {
            new DefaultSorter(context, this.conf, 10, 0xA00000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("tez.runtime.sort.spill.percent"));
        }
        this.conf.setFloat("tez.runtime.sort.spill.percent", 1.1f);
        try {
            new DefaultSorter(context, this.conf, 10, 0xA00000L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("tez.runtime.sort.spill.percent"));
        }
    }

    @Test
    @Ignore
    public void testSortLimitsWithSmallRecord() throws IOException {
        this.conf.set("tez.runtime.key.class", Text.class.getName());
        this.conf.set("tez.runtime.value.class", NullWritable.class.getName());
        OutputContext context = this.createTezOutputContext();
        ((OutputContext)Mockito.doReturn((Object)0xAF000000L).when((Object)context)).getTotalMemoryAvailableToTask();
        this.conf.setInt("tez.runtime.io.sort.mb", 2047);
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)new MemoryUpdateCallbackHandler());
        DefaultSorter sorter = new DefaultSorter(context, this.conf, 2, 0x7FF00000L);
        this.conf.set("tez.runtime.key.class", Text.class.getName());
        this.conf.set("tez.runtime.value.class", Text.class.getName());
        int i = 0;
        while (true) {
            Text key = new Text(i + "");
            sorter.write((Object)key, (Object)NullWritable.get());
            i = (i + 1) % 10;
        }
    }

    @Test
    @Ignore
    public void testSortLimitsWithLargeRecords() throws IOException {
        OutputContext context = this.createTezOutputContext();
        ((OutputContext)Mockito.doReturn((Object)0xAF000000L).when((Object)context)).getTotalMemoryAvailableToTask();
        this.conf.setInt("tez.runtime.io.sort.mb", 2047);
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)new MemoryUpdateCallbackHandler());
        DefaultSorter sorter = new DefaultSorter(context, this.conf, 2, 0x7FF00000L);
        int i = 0;
        while (true) {
            Text key = new Text(i + "");
            int valSize = ThreadLocalRandom.current().nextInt(0x100000, 0x6400000);
            String val = StringInterner.weakIntern((String)StringUtils.repeat((String)"v", (int)valSize));
            sorter.write((Object)key, (Object)new Text(val));
            i = (i + 1) % 10;
        }
    }

    @Test(timeout=5000L)
    public void testSortMBLimits() throws Exception {
        Assert.assertTrue((String)"Expected 1800", (DefaultSorter.computeSortBufferSize((int)4096, (String)"") == 1800 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected 1800", (DefaultSorter.computeSortBufferSize((int)2047, (String)"") == 1800 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected 1024", (DefaultSorter.computeSortBufferSize((int)1024, (String)"") == 1024 ? 1 : 0) != 0);
        try {
            DefaultSorter.computeSortBufferSize((int)0, (String)"");
            Assert.fail((String)"Should have thrown error for setting buffer size to 0");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            DefaultSorter.computeSortBufferSize((int)-100, (String)"");
            Assert.fail((String)"Should have thrown error for setting buffer size to negative value");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void basicTest() throws IOException {
        OutputContext context = this.createTezOutputContext();
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        try {
            this.conf.setInt("tez.runtime.io.sort.mb", 300);
            context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)new MemoryUpdateCallbackHandler());
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("tez.runtime.io.sort.mb"));
        }
        this.conf.setLong("tez.runtime.io.sort.mb", 1L);
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, 5, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        try {
            Text[] keys = TestDefaultSorter.generateData(1000, 1000);
            Text[] values = TestDefaultSorter.generateData(1000, 1000);
            for (int i = 0; i < keys.length; ++i) {
                sorterWrapper.writeKeyValue(keys[i], values[i]);
            }
            sorterWrapper.close();
            Assert.assertTrue((sorter.getNumSpills() > 2 ? 1 : 0) != 0);
            this.verifyCounters(sorter, context);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        this.verifyOutputPermissions(context.getUniqueIdentifier());
    }

    @Test(timeout=30000L)
    public void testEmptyCaseFileLengths() throws IOException {
        this.testEmptyCaseFileLengthsHelper(50, new String[]{"a", "b"}, new String[]{"1", "2"});
        this.testEmptyCaseFileLengthsHelper(50, new String[]{"a", "a"}, new String[]{"1", "2"});
        this.testEmptyCaseFileLengthsHelper(50, new String[]{"aaa", "bbb", "aaa"}, new String[]{"1", "2", "3"});
        this.testEmptyCaseFileLengthsHelper(1, new String[]{"abcdefghij"}, new String[]{"1234567890"});
    }

    public void testEmptyCaseFileLengthsHelper(int numPartitions, String[] keys, String[] values) throws IOException {
        OutputContext context = this.createTezOutputContext();
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        this.conf.setInt("tez.runtime.io.sort.mb", 1);
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        String auxService = this.conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle");
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, numPartitions, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        Assert.assertEquals((String)"Key and Values must have the same number of elements", (long)keys.length, (long)values.length);
        BitSet keyRLEs = new BitSet(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            boolean isRLE = sorterWrapper.writeKeyValue(new Text(keys[i]), new Text(values[i]));
            keyRLEs.set(i, isRLE);
        }
        sorterWrapper.close();
        ArrayList events = new ArrayList();
        String pathComponent = context.getUniqueIdentifier() + "_" + 0;
        ShuffleUtils.generateEventOnSpill(events, (boolean)true, (boolean)true, (OutputContext)context, (int)0, (TezSpillRecord)((TezSpillRecord)sorter.indexCacheList.get(0)), (int)0, (boolean)true, (String)pathComponent, (long[])sorter.getPartitionStats(), (boolean)sorter.reportDetailedPartitionStats(), (String)auxService, (Deflater)TezCommonUtils.newBestCompressionDeflater());
        CompositeDataMovementEvent compositeDataMovementEvent = (CompositeDataMovementEvent)events.get(1);
        ByteBuffer bb = compositeDataMovementEvent.getUserPayload();
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)bb));
        if (shufflePayload.hasEmptyPartitions()) {
            byte[] emptyPartitionsBytesString = TezCommonUtils.decompressByteStringToByteArray((ByteString)shufflePayload.getEmptyPartitions());
            BitSet emptyPartitionBitSet = TezUtilsInternal.fromByteArray((byte[])emptyPartitionsBytesString);
            Assert.assertEquals((String)"Number of empty partitions did not match!", (long)emptyPartitionBitSet.cardinality(), (long)sorterWrapper.getEmptyPartitionsCount());
        } else {
            Assert.assertEquals((long)sorterWrapper.getEmptyPartitionsCount(), (long)0L);
        }
        int expectedFileOutLength = sorterWrapper.getNonEmptyPartitionsCount() * 10;
        for (int i = 0; i < keys.length; ++i) {
            expectedFileOutLength += keys[i].length() + 2;
            expectedFileOutLength += values[i].length() + 2;
        }
        Assert.assertEquals((String)"Unexpected Output File Size!", (long)localFs.getFileStatus(sorter.getFinalOutputFile()).getLen(), (long)expectedFileOutLength);
        Assert.assertEquals((long)sorter.getNumSpills(), (long)1L);
        this.verifyCounters(sorter, context);
    }

    @Test
    public void testWithEmptyData() throws IOException {
        OutputContext context = this.createTezOutputContext();
        this.conf.setLong("tez.runtime.io.sort.mb", 1L);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        DefaultSorter sorter = new DefaultSorter(context, this.conf, 1, handler.getMemoryAssigned());
        try {
            sorter.flush();
            sorter.close();
            Assert.assertTrue((boolean)sorter.isClosed());
            Assert.assertTrue((boolean)sorter.getFinalOutputFile().getParent().getName().equalsIgnoreCase(UniqueID));
            this.verifyCounters(sorter, context);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test(timeout=30000L)
    public void testWithEmptyDataWithFinalMergeDisabled() throws IOException {
        OutputContext context = this.createTezOutputContext();
        this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        this.conf.setLong("tez.runtime.io.sort.mb", 1L);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        DefaultSorter sorter = new DefaultSorter(context, this.conf, 5, handler.getMemoryAssigned());
        try {
            sorter.flush();
            sorter.close();
            Assert.assertTrue((boolean)sorter.isClosed());
            Assert.assertTrue((boolean)sorter.getFinalOutputFile().getParent().getName().equalsIgnoreCase("UUID_0"));
            this.verifyCounters(sorter, context);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testEmptyPartitions() throws Exception {
        this.testEmptyPartitionsHelper(2, false);
        this.testEmptyPartitionsHelper(2, true);
        this.testEmptyPartitionsHelper(0, true);
        this.testEmptyPartitionsHelper(0, true);
    }

    public void testEmptyPartitionsHelper(int numKeys, boolean sendEmptyPartitionDetails) throws IOException {
        TezIndexRecord tezIndexRecord;
        int i;
        OutputContext context = this.createTezOutputContext();
        this.conf.setBoolean("tez.runtime.empty.partitions.info-via-events.enabled", sendEmptyPartitionDetails);
        this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", true);
        this.conf.setLong("tez.runtime.io.sort.mb", 1L);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        int partitions = 50;
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, partitions, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        Text[] keys = TestDefaultSorter.generateData(numKeys, 1000000);
        Text[] values = TestDefaultSorter.generateData(numKeys, 1000000);
        for (i = 0; i < keys.length; ++i) {
            sorterWrapper.writeKeyValue(keys[i], values[i]);
        }
        sorterWrapper.close();
        if (numKeys == 0) {
            Assert.assertTrue((sorter.getNumSpills() == 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((sorter.getNumSpills() == numKeys ? 1 : 0) != 0);
        }
        this.verifyCounters(sorter, context);
        this.verifyOutputPermissions(context.getUniqueIdentifier());
        if (sorter.indexCacheList.size() != 0) {
            for (i = 0; i < sorter.getNumSpills(); ++i) {
                TezSpillRecord record = (TezSpillRecord)sorter.indexCacheList.get(i);
                for (int j = 0; j < partitions; ++j) {
                    tezIndexRecord = record.getIndex(j);
                    if (tezIndexRecord.hasData()) continue;
                    if (sendEmptyPartitionDetails) {
                        Assert.assertEquals((String)("Unexpected raw length for " + i + "th partition"), (long)0L, (long)tezIndexRecord.getRawLength());
                        continue;
                    }
                    Assert.assertEquals((String)"", (long)tezIndexRecord.getRawLength(), (long)6L);
                }
            }
        }
        Path indexFile = sorter.getFinalIndexFile();
        TezSpillRecord spillRecord = new TezSpillRecord(indexFile, this.conf);
        for (int i2 = 0; i2 < partitions; ++i2) {
            tezIndexRecord = spillRecord.getIndex(i2);
            if (tezIndexRecord.hasData()) continue;
            if (sendEmptyPartitionDetails) {
                Assert.assertEquals((String)("Unexpected raw length for " + i2 + "th partition"), (long)0L, (long)tezIndexRecord.getRawLength());
                continue;
            }
            Assert.assertEquals((String)("Unexpected raw length for " + i2 + "th partition"), (long)6L, (long)tezIndexRecord.getRawLength());
        }
    }

    void testPartitionStats(boolean withStats) throws IOException {
        this.conf.setBoolean("tez.runtime.report.partition.stats", withStats);
        OutputContext context = this.createTezOutputContext();
        this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        this.conf.setLong("tez.runtime.io.sort.mb", 4L);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, 1, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        Text[] keys = TestDefaultSorter.generateData(1000, 10);
        Text[] values = TestDefaultSorter.generateData(1000, 10);
        for (int i = 0; i < keys.length; ++i) {
            sorterWrapper.writeKeyValue(keys[i], values[i]);
        }
        sorterWrapper.close();
        Assert.assertTrue((sorter.getNumSpills() == 1 ? 1 : 0) != 0);
        this.verifyCounters(sorter, context);
        if (withStats) {
            Assert.assertTrue((sorter.getPartitionStats() != null ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((sorter.getPartitionStats() == null ? 1 : 0) != 0);
        }
    }

    @Test(timeout=60000L)
    public void testWithPartitionStats() throws IOException {
        this.testPartitionStats(true);
    }

    @Test(timeout=60000L)
    public void testWithoutPartitionStats() throws IOException {
        this.testPartitionStats(false);
    }

    @Test(timeout=60000L)
    public void testWithSingleSpillWithFinalMergeDisabled() throws IOException {
        OutputContext context = this.createTezOutputContext();
        this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        this.conf.setLong("tez.runtime.io.sort.mb", 4L);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, 1, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        Text[] keys = TestDefaultSorter.generateData(1000, 10);
        Text[] values = TestDefaultSorter.generateData(1000, 10);
        for (int i = 0; i < keys.length; ++i) {
            sorterWrapper.writeKeyValue(keys[i], values[i]);
        }
        sorterWrapper.close();
        Assert.assertTrue((sorter.getNumSpills() == 1 ? 1 : 0) != 0);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(List.class);
        ((OutputContext)Mockito.verify((Object)context, (VerificationMode)VerificationModeFactory.times((int)1))).sendEvents((List)eventCaptor.capture());
        List events = (List)eventCaptor.getValue();
        for (Event event : events) {
            if (!(event instanceof CompositeDataMovementEvent)) continue;
            CompositeDataMovementEvent cdme = (CompositeDataMovementEvent)event;
            ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)cdme.getUserPayload()));
            Assert.assertTrue((boolean)shufflePayload.getPathComponent().equalsIgnoreCase("UUID_0"));
            this.verifyOutputPermissions(shufflePayload.getPathComponent());
        }
        this.verifyCounters(sorter, context);
    }

    @Test(timeout=60000L)
    public void testWithMultipleSpillsWithFinalMergeDisabled() throws IOException {
        OutputContext context = this.createTezOutputContext();
        this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
        this.conf.setLong("tez.runtime.io.sort.mb", 4L);
        this.conf.setInt("tez.runtime.index.cache.memory.limit.bytes", 1);
        MemoryUpdateCallbackHandler handler = new MemoryUpdateCallbackHandler();
        context.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement((Configuration)this.conf, (long)context.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)handler);
        SorterWrapper sorterWrapper = new SorterWrapper(context, this.conf, 1, handler.getMemoryAssigned());
        DefaultSorter sorter = sorterWrapper.getSorter();
        Text[] keys = TestDefaultSorter.generateData(10000, 1000);
        Text[] values = TestDefaultSorter.generateData(10000, 1000);
        for (int i = 0; i < keys.length; ++i) {
            sorterWrapper.writeKeyValue(keys[i], values[i]);
        }
        sorterWrapper.close();
        int spillCount = sorter.getNumSpills();
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(List.class);
        ((OutputContext)Mockito.verify((Object)context, (VerificationMode)VerificationModeFactory.times((int)1))).sendEvents((List)eventCaptor.capture());
        List events = (List)eventCaptor.getValue();
        int spillIndex = 0;
        for (Event event : events) {
            if (!(event instanceof CompositeDataMovementEvent)) continue;
            CompositeDataMovementEvent cdme = (CompositeDataMovementEvent)event;
            ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)cdme.getUserPayload()));
            Assert.assertTrue((boolean)shufflePayload.getPathComponent().equalsIgnoreCase("UUID_" + spillIndex));
            this.verifyOutputPermissions(shufflePayload.getPathComponent());
            ++spillIndex;
        }
        Assert.assertTrue((spillIndex == spillCount ? 1 : 0) != 0);
        this.verifyCounters(sorter, context);
    }

    private void verifyOutputPermissions(String spillId) throws IOException {
        String subpath = "output/" + spillId + "/" + "file.out";
        Path outputPath = this.dirAllocator.getLocalPathToRead(subpath, this.conf);
        Path indexPath = this.dirAllocator.getLocalPathToRead(subpath + ".index", this.conf);
        Assert.assertEquals((String)"Incorrect output permissions", (long)416L, (long)localFs.getFileStatus(outputPath).getPermission().toShort());
        Assert.assertEquals((String)"Incorrect index permissions", (long)416L, (long)localFs.getFileStatus(indexPath).getPermission().toShort());
    }

    private void verifyCounters(DefaultSorter sorter, OutputContext context) {
        TezCounter finalOutputBytes;
        TezCounter numShuffleChunks = context.getCounters().findCounter((Enum)TaskCounter.SHUFFLE_CHUNK_COUNT);
        TezCounter additionalSpills = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILL_COUNT);
        TezCounter additionalSpillBytesWritten = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_WRITTEN);
        TezCounter additionalSpillBytesRead = context.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        if (sorter.isFinalMergeEnabled()) {
            Assert.assertTrue((additionalSpills.getValue() == (long)(sorter.getNumSpills() - 1) ? 1 : 0) != 0);
            Assert.assertTrue((1L == numShuffleChunks.getValue() ? 1 : 0) != 0);
            if (sorter.getNumSpills() > 1) {
                Assert.assertTrue((additionalSpillBytesRead.getValue() > 0L ? 1 : 0) != 0);
                Assert.assertTrue((additionalSpillBytesWritten.getValue() > 0L ? 1 : 0) != 0);
            }
        } else {
            Assert.assertTrue((0L == additionalSpills.getValue() ? 1 : 0) != 0);
            Assert.assertTrue(((long)sorter.getNumSpills() == numShuffleChunks.getValue() ? 1 : 0) != 0);
            Assert.assertTrue((additionalSpillBytesRead.getValue() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((additionalSpillBytesWritten.getValue() == 0L ? 1 : 0) != 0);
        }
        Assert.assertTrue(((finalOutputBytes = context.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL)).getValue() >= 0L ? 1 : 0) != 0);
        TezCounter outputBytesWithOverheadCounter = context.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_WITH_OVERHEAD);
        Assert.assertTrue((outputBytesWithOverheadCounter.getValue() >= 0L ? 1 : 0) != 0);
        ((OutputContext)Mockito.verify((Object)context, (VerificationMode)Mockito.atLeastOnce())).notifyProgress();
    }

    private static Text[] generateData(int numKeys, int keyLen) {
        Text[] ret = new Text[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            ret[i] = new Text(RandomStringUtils.randomAlphanumeric((int)keyLen));
        }
        return ret;
    }

    private OutputContext createTezOutputContext() throws IOException {
        String[] workingDirs = new String[]{workingDir.toString()};
        UserPayload payLoad = TezUtils.createUserPayloadFromConf((Configuration)this.conf);
        DataOutputBuffer serviceProviderMetaData = new DataOutputBuffer();
        serviceProviderMetaData.writeInt(80);
        TezCounters counters = new TezCounters();
        OutputContext context = (OutputContext)Mockito.mock(OutputContext.class);
        ExecutionContextImpl execContext = new ExecutionContextImpl("localhost");
        ((OutputContext)Mockito.doReturn((Object)Mockito.mock(OutputStatisticsReporter.class)).when((Object)context)).getStatisticsReporter();
        ((OutputContext)Mockito.doReturn((Object)execContext).when((Object)context)).getExecutionContext();
        ((OutputContext)Mockito.doReturn((Object)counters).when((Object)context)).getCounters();
        ((OutputContext)Mockito.doReturn((Object)workingDirs).when((Object)context)).getWorkDirs();
        ((OutputContext)Mockito.doReturn((Object)payLoad).when((Object)context)).getUserPayload();
        ((OutputContext)Mockito.doReturn((Object)0x500000L).when((Object)context)).getTotalMemoryAvailableToTask();
        ((OutputContext)Mockito.doReturn((Object)UniqueID).when((Object)context)).getUniqueIdentifier();
        ((OutputContext)Mockito.doReturn((Object)"v1").when((Object)context)).getDestinationVertexName();
        ((OutputContext)Mockito.doReturn((Object)ByteBuffer.wrap(serviceProviderMetaData.getData())).when((Object)context)).getServiceProviderMetaData(this.conf.get("tez.am.shuffle.auxiliary-service.id", "mapreduce_shuffle"));
        ((OutputContext)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                long requestedSize = (Long)invocation.getArguments()[0];
                MemoryUpdateCallbackHandler callback = (MemoryUpdateCallbackHandler)invocation.getArguments()[1];
                callback.memoryAssigned(requestedSize);
                return null;
            }
        }).when((Object)context)).requestInitialMemory(Matchers.anyLong(), (MemoryUpdateCallback)Matchers.any(MemoryUpdateCallback.class));
        return context;
    }

    private static class SorterWrapper {
        private final DefaultSorter sorter;
        private final Partitioner partitioner;
        private final BitSet nonEmptyPartitions;
        private final Object[] lastKeys;
        private final int numPartitions;

        public SorterWrapper(OutputContext context, Configuration conf, int numPartitions, long memoryAssigned) throws IOException {
            this.sorter = new DefaultSorter(context, conf, numPartitions, memoryAssigned);
            this.partitioner = TezRuntimeUtils.instantiatePartitioner((Configuration)conf);
            this.nonEmptyPartitions = new BitSet(numPartitions);
            this.lastKeys = new Object[numPartitions];
            this.numPartitions = numPartitions;
        }

        public boolean writeKeyValue(Object key, Object value) throws IOException {
            int partition = this.partitioner.getPartition(key, value, this.numPartitions);
            this.nonEmptyPartitions.set(partition);
            this.sorter.write(key, value);
            boolean isRLE = key.equals(this.lastKeys[partition]);
            this.lastKeys[partition] = key;
            return isRLE;
        }

        public int getNonEmptyPartitionsCount() {
            return this.nonEmptyPartitions.cardinality();
        }

        public int getEmptyPartitionsCount() {
            return this.numPartitions - this.nonEmptyPartitions.cardinality();
        }

        public void close() throws IOException {
            this.sorter.flush();
            this.sorter.close();
        }

        public DefaultSorter getSorter() {
            return this.sorter;
        }
    }
}

