/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.OutputContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMROutput {
    @Test(timeout=5000L)
    public void testNewAPI_TextOutputFormat() throws Exception {
        String outputPath = "/tmp/output";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", true);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, (String)outputPath).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload());
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.TextOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertNotNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testOldAPI_TextOutputFormat() throws Exception {
        String outputPath = "/tmp/output";
        Configuration conf = new Configuration();
        conf.setBoolean("tez.mapreduce.is_map_processor", false);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, TextOutputFormat.class, (String)outputPath).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload());
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.isMapperOutput);
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(TextOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertNotNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testNewAPI_SequenceFileOutputFormat() throws Exception {
        String outputPath = "/tmp/output";
        JobConf conf = new JobConf();
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat.class, (String)outputPath).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload());
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)true, (Object)output.useNewApi);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat.class, output.newOutputFormat.getClass());
        Assert.assertNull((Object)output.oldOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.newApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.newApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.oldApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.newRecordWriter);
        Assert.assertNull((Object)output.oldRecordWriter);
        Assert.assertEquals(org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.class, output.committer.getClass());
    }

    @Test(timeout=5000L)
    public void testOldAPI_SequenceFileOutputFormat() throws Exception {
        String outputPath = "/tmp/output";
        JobConf conf = new JobConf();
        conf.setOutputKeyClass(NullWritable.class);
        conf.setOutputValueClass(Text.class);
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)conf, SequenceFileOutputFormat.class, (String)outputPath).build();
        OutputContext outputContext = this.createMockOutputContext(dataSink.getOutputDescriptor().getUserPayload());
        MROutput output = new MROutput(outputContext, 2);
        output.initialize();
        Assert.assertEquals((Object)false, (Object)output.useNewApi);
        Assert.assertEquals(SequenceFileOutputFormat.class, output.oldOutputFormat.getClass());
        Assert.assertNull((Object)output.newOutputFormat);
        Assert.assertEquals(NullWritable.class, (Object)output.oldApiTaskAttemptContext.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)output.oldApiTaskAttemptContext.getOutputValueClass());
        Assert.assertNull((Object)output.newApiTaskAttemptContext);
        Assert.assertNotNull((Object)output.oldRecordWriter);
        Assert.assertNull((Object)output.newRecordWriter);
        Assert.assertEquals(FileOutputCommitter.class, output.committer.getClass());
    }

    private OutputContext createMockOutputContext(UserPayload payload) {
        OutputContext outputContext = (OutputContext)Mockito.mock(OutputContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Mockito.when((Object)outputContext.getUserPayload()).thenReturn((Object)payload);
        Mockito.when((Object)outputContext.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)outputContext.getTaskVertexIndex()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getTaskAttemptNumber()).thenReturn((Object)1);
        Mockito.when((Object)outputContext.getCounters()).thenReturn((Object)new TezCounters());
        return outputContext;
    }
}

