/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.output;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;

public class LocalOnFileSorterOutput
extends OrderedPartitionedKVOutput {
    private static final Log LOG = LogFactory.getLog(LocalOnFileSorterOutput.class);

    public LocalOnFileSorterOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public List<Event> close() throws IOException {
        LOG.debug((Object)"Closing LocalOnFileSorterOutput");
        super.close();
        TezTaskOutput mapOutputFile = this.sorter.getMapOutput();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        Path src = mapOutputFile.getOutputFile();
        Path dst = mapOutputFile.getInputFileForWrite(this.getContext().getTaskIndex(), localFs.getFileStatus(src).getLen());
        LOG.info((Object)("Renaming src = " + src + ", dst = " + dst));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming src = " + src + ", dst = " + dst));
        }
        localFs.rename(src, dst);
        return null;
    }

    protected List<Event> generateEventsOnClose() throws IOException {
        return null;
    }
}

