/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.hadoop.TestMRHelpers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRInputHelpers {
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static Path testFilePath;
    private static Path oldSplitsDir;
    private static Path newSplitsDir;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        YarnConfiguration testConf = new YarnConfiguration(dfsCluster.getFileSystem().getConf());
        FSDataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = remoteFs.create(new Path("/tmp/input/test.xml"), true);
            testConf.writeXml((OutputStream)dataOutputStream);
            dataOutputStream.hsync();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        remoteFs.mkdirs(new Path("/tmp/input/"));
        remoteFs.mkdirs(new Path("/tmp/splitsDirNew/"));
        remoteFs.mkdirs(new Path("/tmp/splitsDirOld/"));
        testFilePath = remoteFs.makeQualified(new Path("/tmp/input/test.xml"));
        FileStatus fsStatus = remoteFs.getFileStatus(testFilePath);
        Assert.assertTrue((fsStatus.getLen() > 0L ? 1 : 0) != 0);
        oldSplitsDir = remoteFs.makeQualified(new Path("/tmp/splitsDirOld/"));
        newSplitsDir = remoteFs.makeQualified(new Path("/tmp/splitsDirNew/"));
    }

    @Test
    public void testNewSplitsGen() throws Exception {
        DataSourceDescriptor dataSource = this.generateDataSourceDescriptorMapReduce(newSplitsDir);
        Assert.assertTrue((boolean)dataSource.getAdditionalLocalFiles().containsKey("job.split"));
        Assert.assertTrue((boolean)dataSource.getAdditionalLocalFiles().containsKey("job.splitmetainfo"));
        RemoteIterator files = remoteFs.listFiles(newSplitsDir, false);
        boolean foundSplitsFile = false;
        boolean foundMetaFile = false;
        int totalFilesFound = 0;
        while (files.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)files.next();
            String fName = status.getPath().getName();
            ++totalFilesFound;
            if (fName.equals("job.split")) {
                foundSplitsFile = true;
            } else if (fName.equals("job.splitmetainfo")) {
                foundMetaFile = true;
            } else {
                Assert.fail((String)("Found invalid file in splits dir, filename=" + fName));
            }
            Assert.assertTrue((status.getLen() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)totalFilesFound);
        Assert.assertTrue((boolean)foundSplitsFile);
        Assert.assertTrue((boolean)foundMetaFile);
        this.verifyLocationHints(newSplitsDir, dataSource.getLocationHint().getTaskLocationHints());
    }

    @Test
    public void testOldSplitsGen() throws Exception {
        DataSourceDescriptor dataSource = this.generateDataSourceDescriptorMapRed(oldSplitsDir);
        Assert.assertTrue((boolean)dataSource.getAdditionalLocalFiles().containsKey("job.split"));
        Assert.assertTrue((boolean)dataSource.getAdditionalLocalFiles().containsKey("job.splitmetainfo"));
        RemoteIterator files = remoteFs.listFiles(oldSplitsDir, false);
        boolean foundSplitsFile = false;
        boolean foundMetaFile = false;
        int totalFilesFound = 0;
        while (files.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)files.next();
            String fName = status.getPath().getName();
            ++totalFilesFound;
            if (fName.equals("job.split")) {
                foundSplitsFile = true;
            } else if (fName.equals("job.splitmetainfo")) {
                foundMetaFile = true;
            } else {
                Assert.fail((String)("Found invalid file in splits dir, filename=" + fName));
            }
            Assert.assertTrue((status.getLen() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)totalFilesFound);
        Assert.assertTrue((boolean)foundSplitsFile);
        Assert.assertTrue((boolean)foundMetaFile);
        this.verifyLocationHints(oldSplitsDir, dataSource.getLocationHint().getTaskLocationHints());
    }

    @Test
    public void testInputSplitLocalResourceCreation() throws Exception {
        DataSourceDescriptor dataSource = this.generateDataSourceDescriptorMapRed(oldSplitsDir);
        Map localResources = dataSource.getAdditionalLocalFiles();
        Assert.assertEquals((long)2L, (long)localResources.size());
        Assert.assertTrue((boolean)localResources.containsKey("job.split"));
        Assert.assertTrue((boolean)localResources.containsKey("job.splitmetainfo"));
    }

    private void verifyLocationHints(Path inputSplitsDir, List<TaskLocationHint> actual) throws Exception {
        JobID jobId = new JobID("dummy", 1);
        JobSplit.TaskSplitMetaInfo[] splitsInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)jobId, (FileSystem)remoteFs, (Configuration)conf, (Path)inputSplitsDir);
        int splitsCount = splitsInfo.length;
        ArrayList<TaskLocationHint> locationHints = new ArrayList<TaskLocationHint>(splitsCount);
        for (int i = 0; i < splitsCount; ++i) {
            locationHints.add(TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(splitsInfo[i].getLocations())), null));
        }
        Assert.assertEquals(locationHints, actual);
    }

    private DataSourceDescriptor generateDataSourceDescriptorMapReduce(Path inputSplitsDir) throws Exception {
        JobConf jobConf = new JobConf(dfsCluster.getFileSystem().getConf());
        jobConf.setUseNewMapper(true);
        jobConf.setClass("mapreduce.job.inputformat.class", org.apache.hadoop.mapreduce.lib.input.TextInputFormat.class, InputFormat.class);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", testFilePath.toString());
        return MRInputHelpers.configureMRInputWithLegacySplitGeneration((Configuration)jobConf, (Path)inputSplitsDir, (boolean)true);
    }

    private DataSourceDescriptor generateDataSourceDescriptorMapRed(Path inputSplitsDir) throws Exception {
        JobConf jobConf = new JobConf(dfsCluster.getFileSystem().getConf());
        jobConf.setUseNewMapper(false);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", testFilePath.toString());
        return MRInputHelpers.configureMRInputWithLegacySplitGeneration((Configuration)jobConf, (Path)inputSplitsDir, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testInputSplitLocalResourceCreationWithDifferentFS() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path LOCAL_TEST_ROOT_DIR = new Path("target/" + TestMRHelpers.class.getName() + "-localtmpDir");
        try {
            localFs.mkdirs(LOCAL_TEST_ROOT_DIR);
            Path splitsDir = localFs.resolvePath(LOCAL_TEST_ROOT_DIR);
            DataSourceDescriptor dataSource = this.generateDataSourceDescriptorMapRed(splitsDir);
            Map localResources = dataSource.getAdditionalLocalFiles();
            Assert.assertEquals((long)2L, (long)localResources.size());
            Assert.assertTrue((boolean)localResources.containsKey("job.split"));
            Assert.assertTrue((boolean)localResources.containsKey("job.splitmetainfo"));
            for (LocalResource lr : localResources.values()) {
                Assert.assertFalse((boolean)lr.getResource().getScheme().contains(remoteFs.getScheme()));
            }
        }
        finally {
            localFs.delete(LOCAL_TEST_ROOT_DIR, true);
        }
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestMRHelpers.class.getName() + "-tmpDir";
    }
}

