/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.ATSImportTool;
import org.apache.tez.history.parser.ATSFileParser;
import org.apache.tez.history.parser.SimpleHistoryParser;
import org.apache.tez.history.parser.datamodel.DagInfo;

public abstract class TezAnalyzerBase
extends Configured
implements Tool,
Analyzer {
    private static final String EVENT_FILE_NAME = "eventFileName";
    private static final String OUTPUT_DIR = "outputDir";
    private static final String SAVE_RESULTS = "saveResults";
    private static final String DAG_ID = "dagId";
    private static final String FROM_SIMPLE_HISTORY = "fromSimpleHistory";
    private static final String HELP = "help";
    private static final int SEPARATOR_WIDTH = 80;
    private static final int MIN_COL_WIDTH = 12;
    private String outputDir;
    private boolean saveResults = false;

    private static Options buildOptions() {
        OptionBuilder.withArgName((String)DAG_ID);
        OptionBuilder.withLongOpt((String)DAG_ID);
        OptionBuilder.withDescription((String)"DagId that needs to be analyzed");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        Option dagIdOption = OptionBuilder.create();
        OptionBuilder.withArgName((String)OUTPUT_DIR);
        OptionBuilder.withLongOpt((String)OUTPUT_DIR);
        OptionBuilder.withDescription((String)"Directory to write outputs to.");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        Option outputDirOption = OptionBuilder.create();
        OptionBuilder.withArgName((String)SAVE_RESULTS);
        OptionBuilder.withLongOpt((String)SAVE_RESULTS);
        OptionBuilder.withDescription((String)"Saves results to output directory (optional)");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        Option saveResults = OptionBuilder.create();
        OptionBuilder.withArgName((String)EVENT_FILE_NAME);
        OptionBuilder.withLongOpt((String)EVENT_FILE_NAME);
        OptionBuilder.withDescription((String)"File with event data for the DAG");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        Option eventFileNameOption = OptionBuilder.create();
        OptionBuilder.withArgName((String)FROM_SIMPLE_HISTORY);
        OptionBuilder.withLongOpt((String)FROM_SIMPLE_HISTORY);
        OptionBuilder.withDescription((String)"Event data from Simple History logging. Must also specify event file");
        OptionBuilder.isRequired((boolean)false);
        Option fromSimpleHistoryOption = OptionBuilder.create();
        OptionBuilder.withArgName((String)HELP);
        OptionBuilder.withLongOpt((String)HELP);
        OptionBuilder.withDescription((String)"print help");
        OptionBuilder.isRequired((boolean)false);
        Option help = OptionBuilder.create();
        Options opts = new Options();
        opts.addOption(dagIdOption);
        opts.addOption(outputDirOption);
        opts.addOption(saveResults);
        opts.addOption(eventFileNameOption);
        opts.addOption(fromSimpleHistoryOption);
        opts.addOption(help);
        return opts;
    }

    protected String getOutputDir() {
        return this.outputDir;
    }

    private void printUsage() {
        System.err.println("Analyzer base options are");
        Options options = TezAnalyzerBase.buildOptions();
        for (Object obj : options.getOptions()) {
            Option option = (Option)obj;
            System.err.println(option.getArgName() + " : " + option.getDescription());
        }
    }

    public int run(String[] args) throws Exception {
        ATSFileParser parser;
        CommandLine cmdLine = null;
        try {
            cmdLine = new GnuParser().parse(TezAnalyzerBase.buildOptions(), args);
        }
        catch (ParseException e) {
            System.err.println("Invalid options on command line");
            this.printUsage();
            return -1;
        }
        this.saveResults = cmdLine.hasOption(SAVE_RESULTS);
        if (cmdLine.hasOption(HELP)) {
            this.printUsage();
            return 0;
        }
        this.outputDir = cmdLine.getOptionValue(OUTPUT_DIR);
        if (this.outputDir == null) {
            this.outputDir = System.getProperty("user.dir");
        }
        File file = null;
        if (cmdLine.hasOption(EVENT_FILE_NAME)) {
            file = new File(cmdLine.getOptionValue(EVENT_FILE_NAME));
        }
        String dagId = cmdLine.getOptionValue(DAG_ID);
        DagInfo dagInfo = null;
        if (file == null) {
            if (cmdLine.hasOption(FROM_SIMPLE_HISTORY)) {
                System.err.println("Event file name must be specified when using simple history");
                this.printUsage();
                return -2;
            }
            String[] importArgs = new String[]{"--dagId=" + dagId, "--downloadDir=" + this.outputDir};
            int result = ATSImportTool.process((String[])importArgs);
            if (result != 0) {
                System.err.println("Error downloading data from ATS");
                return -3;
            }
            file = new File(this.outputDir + "/" + dagId + "/" + dagId + ".zip");
        }
        Preconditions.checkState((file != null ? 1 : 0) != 0);
        if (!cmdLine.hasOption(FROM_SIMPLE_HISTORY)) {
            parser = new ATSFileParser(file);
            dagInfo = parser.getDAGData(dagId);
        } else {
            parser = new SimpleHistoryParser(file);
            dagInfo = parser.getDAGData(dagId);
        }
        Preconditions.checkState((boolean)dagInfo.getDagId().equals(dagId));
        this.analyze(dagInfo);
        Result result = this.getResult();
        if (this.saveResults && result instanceof CSVResult) {
            String fileName = this.outputDir + File.separator + this.getClass().getName() + "_" + dagInfo.getDagId() + ".csv";
            ((CSVResult)result).dumpToFile(fileName);
            System.out.println("Saved results in " + fileName);
        }
        return 0;
    }

    public void printResults() throws TezException {
        Result result = this.getResult();
        if (result instanceof CSVResult) {
            Object[] headers = ((CSVResult)result).getHeaders();
            StringBuilder formatBuilder = new StringBuilder();
            int size = Math.max(12, 80 / headers.length);
            for (int i = 0; i < headers.length; ++i) {
                formatBuilder.append("%-").append(size).append("s ");
            }
            String format = formatBuilder.toString();
            StringBuilder separator = new StringBuilder();
            for (int i = 0; i < 80; ++i) {
                separator.append("-");
            }
            System.out.println(separator);
            System.out.println(String.format(format.toString(), headers));
            System.out.println(separator);
            Iterator<String[]> recordsIterator = ((CSVResult)result).getRecordsIterator();
            while (recordsIterator.hasNext()) {
                String line = String.format(format, recordsIterator.next());
                System.out.println(line);
            }
            System.out.println(separator);
        }
    }
}

