/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.recovery;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRecoveryService {
    private static String TEST_ROOT_DIR = "target/" + TestRecoveryService.class.getName() + "-tmpDir";
    private Configuration conf;

    @Before
    public void setUp() throws IllegalArgumentException, IOException {
        this.conf = new Configuration();
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)this.conf);
        localFS.delete(new Path(TEST_ROOT_DIR), true);
    }

    @Test(timeout=5000L)
    public void testDrainEvents() throws IOException {
        Configuration conf = new Configuration();
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(TEST_ROOT_DIR));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        MockRecoveryService recoveryService = new MockRecoveryService(appContext);
        conf.setBoolean("tez.test.recovery.drain_event", true);
        recoveryService.init(conf);
        recoveryService.start();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1);
        int randEventCount = new Random().nextInt(100) + 100;
        for (int i = 0; i < randEventCount; ++i) {
            recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)dagId, (int)1), (int)1), "v1", 0L, 0L)));
        }
        recoveryService.stop();
        Assert.assertEquals((long)randEventCount, (long)recoveryService.processedRecoveryEventCounter.get());
    }

    @Test(timeout=5000L)
    public void testMultipleDAGFinishedEvent() throws IOException {
        Configuration conf = new Configuration();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(TEST_ROOT_DIR));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        MockRecoveryService recoveryService = new MockRecoveryService(appContext);
        conf.setBoolean("tez.test.recovery.drain_event", true);
        recoveryService.init(conf);
        recoveryService.start();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1);
        int randEventCount = new Random().nextInt(100) + 100;
        for (int i = 0; i < randEventCount; ++i) {
            recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)dagId, (int)1), (int)1), "v1", 0L, 0L)));
        }
        recoveryService.await();
        Assert.assertTrue((boolean)recoveryService.outputStreamMap.containsKey(dagId));
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGFinishedEvent(dagId, 1L, 2L, DAGState.FAILED, "diag", null, "user", "dag1", null, appAttemptId, null)));
        Assert.assertFalse((boolean)recoveryService.outputStreamMap.containsKey(dagId));
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGFinishedEvent(dagId, 1L, 2L, DAGState.ERROR, "diag", null, "user", "dag1", null, appAttemptId, null)));
        Assert.assertEquals((long)recoveryService.outputStreamMap.size(), (long)0L);
        Assert.assertFalse((boolean)recoveryService.outputStreamMap.containsKey(dagId));
        recoveryService.stop();
    }

    @Test(timeout=5000L)
    public void testSummaryPathExisted() throws IOException {
        Configuration conf = new Configuration();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(TEST_ROOT_DIR));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        MockRecoveryService recoveryService = new MockRecoveryService(appContext);
        conf.setBoolean("tez.test.recovery.drain_event", true);
        recoveryService.init(conf);
        recoveryService.start();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1);
        Path dagRecoveryPath = TezCommonUtils.getSummaryRecoveryPath((Path)recoveryService.recoveryPath);
        this.touchFile(dagRecoveryPath);
        Assert.assertFalse((boolean)recoveryService.hasRecoveryFailed());
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGFinishedEvent(dagId, 1L, 2L, DAGState.ERROR, "diag", null, "user", "dag1", null, appAttemptId, null)));
        Assert.assertTrue((boolean)recoveryService.hasRecoveryFailed());
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new DAGFinishedEvent(dagId, 1L, 2L, DAGState.ERROR, "diag", null, "user", "dag1", null, appAttemptId, null)));
    }

    @Test(timeout=5000L)
    public void testRecoveryPathExisted() throws IOException {
        Configuration conf = new Configuration();
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getCurrentRecoveryDir()).thenReturn((Object)new Path(TEST_ROOT_DIR));
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)new SystemClock());
        Mockito.when((Object)appContext.getHadoopShim()).thenReturn((Object)new DefaultHadoopShim());
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)appId);
        MockRecoveryService recoveryService = new MockRecoveryService(appContext);
        conf.setBoolean("tez.test.recovery.drain_event", true);
        recoveryService.init(conf);
        recoveryService.start();
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1);
        Path dagRecoveryPath = TezCommonUtils.getDAGRecoveryPath((Path)recoveryService.recoveryPath, (String)dagId.toString());
        this.touchFile(dagRecoveryPath);
        Assert.assertFalse((boolean)recoveryService.hasRecoveryFailed());
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)dagId, (int)1), (int)1), "v1", 0L, 0L)));
        recoveryService.await();
        Assert.assertTrue((boolean)recoveryService.hasRecoveryFailed());
        recoveryService.handle(new DAGHistoryEvent(dagId, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)dagId, (int)1), (int)1), "v1", 0L, 0L)));
    }

    private void touchFile(Path path) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.create(path).close();
    }

    private static class MockRecoveryService
    extends RecoveryService {
        public AtomicInteger processedRecoveryEventCounter = new AtomicInteger(0);

        public MockRecoveryService(AppContext appContext) {
            super(appContext);
        }

        protected void handleRecoveryEvent(DAGHistoryEvent event) throws IOException {
            super.handleRecoveryEvent(event);
            this.processedRecoveryEventCounter.addAndGet(1);
        }
    }
}

