/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.web.AMWebController;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestAMWebController {
    AppContext mockAppContext;
    Controller.RequestContext mockRequestContext;
    HttpServletResponse mockResponse;
    HttpServletRequest mockRequest;
    String[] userGroups = new String[0];
    @Captor
    ArgumentCaptor<Map<String, AMWebController.ProgressInfo>> singleResultCaptor;
    @Captor
    ArgumentCaptor<Map<String, Object>> returnResultCaptor;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Configuration conf = new Configuration(false);
        conf.set("tez.tez-ui.history-url.base", "http://uihost:9001/foo");
        Mockito.when((Object)this.mockAppContext.getAMConf()).thenReturn((Object)conf);
        this.mockRequestContext = (Controller.RequestContext)Mockito.mock(Controller.RequestContext.class);
        this.mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    }

    @Test(timeout=5000L)
    public void testCorsHeadersAreSet() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        spy.setCorsHeaders();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Origin", "http://uihost:9001");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Credentials", "true");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Methods", "GET, HEAD");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader("Access-Control-Allow-Headers", "X-Requested-With,Content-Type,Accept,Origin");
    }

    @Test(timeout=5000L)
    public void sendErrorResponseIfNoAccess() throws Exception {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)false).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((AMWebController)Mockito.doReturn((Object)this.mockRequest).when((Object)spy)).request();
        ((HttpServletRequest)Mockito.doReturn((Object)"dummyuser").when((Object)this.mockRequest)).getRemoteUser();
        spy.getDagProgress();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
        Mockito.reset((Object[])new HttpServletResponse[]{this.mockResponse});
        spy.getVertexProgress();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
        Mockito.reset((Object[])new HttpServletResponse[]{this.mockResponse});
        spy.getVertexProgresses();
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).sendError(Matchers.eq((int)401), Matchers.anyString());
    }

    @Test(timeout=5000L)
    public void testDagProgressResponse() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        ((AMWebController)Mockito.doReturn((Object)"42").when((Object)spy)).$("dagID");
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        ((DAG)Mockito.doReturn((Object)Float.valueOf(66.0f)).when((Object)mockDAG)).getCompletedTaskProgress();
        ((AppContext)Mockito.doReturn((Object)mockDAG).when((Object)this.mockAppContext)).getCurrentDAG();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        spy.getDagProgress();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.singleResultCaptor.capture());
        Map result = (Map)this.singleResultCaptor.getValue();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("dagProgress"));
        AMWebController.ProgressInfo progressInfo = (AMWebController.ProgressInfo)result.get("dagProgress");
        Assert.assertTrue((boolean)"dag_1422960590892_0007_42".equals(progressInfo.getId()));
        Assert.assertEquals((double)66.0, (double)progressInfo.getProgress(), (double)0.1);
    }

    @Test(timeout=5000L)
    public void testVertexProgressResponse() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).hasAccess();
        ((AMWebController)Mockito.doReturn((Object)"42").when((Object)spy)).$("dagID");
        ((AMWebController)Mockito.doReturn((Object)"43").when((Object)spy)).$("vertexID");
        ((AMWebController)Mockito.doReturn((Object)this.mockResponse).when((Object)spy)).response();
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        ((AppContext)Mockito.doReturn((Object)mockDAG).when((Object)this.mockAppContext)).getCurrentDAG();
        ((DAG)Mockito.doReturn((Object)mockVertex).when((Object)mockDAG)).getVertex((TezVertexID)Matchers.any(TezVertexID.class));
        ((Vertex)Mockito.doReturn((Object)Float.valueOf(66.0f)).when((Object)mockVertex)).getCompletedTaskProgress();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        ((AMWebController)Mockito.doNothing().when((Object)spy)).setCorsHeaders();
        spy.getVertexProgress();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.singleResultCaptor.capture());
        Map result = (Map)this.singleResultCaptor.getValue();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("vertexProgress"));
        AMWebController.ProgressInfo progressInfo = (AMWebController.ProgressInfo)result.get("vertexProgress");
        Assert.assertTrue((boolean)"vertex_1422960590892_0007_42_43".equals(progressInfo.getId()));
        Assert.assertEquals((double)66.0, (double)progressInfo.getProgress(), (double)0.1);
    }

    @Test(timeout=5000L)
    public void testHasAccessWithAclsDisabled() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.am.acls.enabled", false);
        ACLManager aclManager = new ACLManager("amUser", conf);
        Mockito.when((Object)this.mockAppContext.getAMACLManager()).thenReturn((Object)aclManager);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess(null, (AppContext)this.mockAppContext));
        UserGroupInformation mockUser = UserGroupInformation.createUserForTesting((String)"mockUser", (String[])this.userGroups);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess((UserGroupInformation)mockUser, (AppContext)this.mockAppContext));
    }

    @Test(timeout=5000L)
    public void testHasAccess() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.am.acls.enabled", true);
        ACLManager aclManager = new ACLManager("amUser", conf);
        Mockito.when((Object)this.mockAppContext.getAMACLManager()).thenReturn((Object)aclManager);
        Assert.assertEquals((Object)false, (Object)AMWebController._hasAccess(null, (AppContext)this.mockAppContext));
        UserGroupInformation mockUser = UserGroupInformation.createUserForTesting((String)"mockUser", (String[])this.userGroups);
        Assert.assertEquals((Object)false, (Object)AMWebController._hasAccess((UserGroupInformation)mockUser, (AppContext)this.mockAppContext));
        UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)"amUser", (String[])this.userGroups);
        Assert.assertEquals((Object)true, (Object)AMWebController._hasAccess((UserGroupInformation)testUser, (AppContext)this.mockAppContext));
    }

    @Test(timeout=5000L)
    public void testGetDagInfo() {
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        ((DAG)Mockito.doReturn((Object)Float.valueOf(66.0f)).when((Object)mockDAG)).getCompletedTaskProgress();
        ((DAG)Mockito.doReturn((Object)DAGState.RUNNING).when((Object)mockDAG)).getState();
        TezCounters counters = new TezCounters();
        counters.addGroup("g1", "g1");
        counters.addGroup("g2", "g2");
        counters.addGroup("g3", "g3");
        counters.addGroup("g4", "g4");
        counters.findCounter("g1", "g1_c1").setValue(100L);
        counters.findCounter("g1", "g1_c2").setValue(100L);
        counters.findCounter("g2", "g2_c3").setValue(100L);
        counters.findCounter("g2", "g2_c4").setValue(100L);
        counters.findCounter("g3", "g3_c5").setValue(100L);
        counters.findCounter("g3", "g3_c6").setValue(100L);
        ((DAG)Mockito.doReturn((Object)counters).when((Object)mockDAG)).getAllCounters();
        ((DAG)Mockito.doReturn((Object)counters).when((Object)mockDAG)).getCachedCounters();
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).setupResponse();
        ((AMWebController)Mockito.doReturn((Object)mockDAG).when((Object)spy)).checkAndGetDAGFromRequest();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        HashMap<String, Object> counterNames = new HashMap<String, Object>();
        counterNames.put("*", null);
        ((AMWebController)Mockito.doReturn(counterNames).when((Object)spy)).getCounterListFromRequest();
        spy.getDagInfo();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.returnResultCaptor.capture());
        Map result = (Map)this.returnResultCaptor.getValue();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("dag"));
        Map dagInfo = (Map)result.get("dag");
        Assert.assertEquals((long)4L, (long)dagInfo.size());
        Assert.assertTrue((boolean)"dag_1422960590892_0007_42".equals(dagInfo.get("id")));
        Assert.assertEquals((Object)"66.0", dagInfo.get("progress"));
        Assert.assertEquals((Object)"RUNNING", dagInfo.get("status"));
        Assert.assertNotNull(dagInfo.get("counters"));
    }

    @Test(timeout=5000L)
    public void testGetVerticesInfoGetAll() {
        Vertex mockVertex1 = this.createMockVertex("vertex_1422960590892_0007_42_00", VertexState.RUNNING, 0.33f, 3);
        Vertex mockVertex2 = this.createMockVertex("vertex_1422960590892_0007_42_01", VertexState.SUCCEEDED, 1.0f, 5);
        Map<String, Object> result = this.getVerticesTestHelper(0, mockVertex1, mockVertex2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("vertices"));
        ArrayList verticesInfo = (ArrayList)result.get("vertices");
        Assert.assertEquals((long)2L, (long)verticesInfo.size());
        Map vertex1Result = (Map)verticesInfo.get(0);
        Map vertex2Result = (Map)verticesInfo.get(1);
        this.verifySingleVertexResult(mockVertex1, vertex1Result);
        this.verifySingleVertexResult(mockVertex2, vertex2Result);
    }

    @Test(timeout=5000L)
    public void testGetVerticesInfoGetPartial() {
        Vertex mockVertex1 = this.createMockVertex("vertex_1422960590892_0007_42_00", VertexState.RUNNING, 0.33f, 3);
        Vertex mockVertex2 = this.createMockVertex("vertex_1422960590892_0007_42_01", VertexState.SUCCEEDED, 1.0f, 5);
        Map<String, Object> result = this.getVerticesTestHelper(1, mockVertex1, mockVertex2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("vertices"));
        List verticesInfo = (List)result.get("vertices");
        Assert.assertEquals((long)1L, (long)verticesInfo.size());
        Map vertex1Result = (Map)verticesInfo.get(0);
        this.verifySingleVertexResult(mockVertex1, vertex1Result);
    }

    Map<String, Object> getVerticesTestHelper(int numVerticesRequested, Vertex mockVertex1, Vertex mockVertex2) {
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1422960590892_0007_42")).when((Object)mockDAG)).getID();
        TezVertexID vertexId1 = mockVertex1.getVertexId();
        ((DAG)Mockito.doReturn((Object)mockVertex1).when((Object)mockDAG)).getVertex(vertexId1);
        TezVertexID vertexId2 = mockVertex2.getVertexId();
        ((DAG)Mockito.doReturn((Object)mockVertex2).when((Object)mockDAG)).getVertex(vertexId2);
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((DAG)Mockito.doReturn((Object)ImmutableMap.of((Object)mockVertex1.getVertexId(), (Object)mockVertex1, (Object)mockVertex2.getVertexId(), (Object)mockVertex2)).when((Object)mockDAG)).getVertices();
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).setupResponse();
        ((AMWebController)Mockito.doReturn((Object)mockDAG).when((Object)spy)).checkAndGetDAGFromRequest();
        TreeMap counterList = new TreeMap();
        ((AMWebController)Mockito.doReturn(counterList).when((Object)spy)).getCounterListFromRequest();
        ImmutableList requested = numVerticesRequested == 0 ? ImmutableList.of() : ImmutableList.of((Object)mockVertex1.getVertexId().getId());
        ((AMWebController)Mockito.doReturn((Object)requested).when((Object)spy)).getVertexIDsFromRequest();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        spy.getVerticesInfo();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.returnResultCaptor.capture());
        return (Map)this.returnResultCaptor.getValue();
    }

    private Vertex createMockVertex(String vertexIDStr, VertexState status, float progress, int taskCounts) {
        ProgressBuilder pb = new ProgressBuilder();
        pb.setTotalTaskCount(taskCounts);
        pb.setSucceededTaskCount(taskCounts * 2);
        pb.setFailedTaskAttemptCount(taskCounts * 3);
        pb.setKilledTaskAttemptCount(taskCounts * 4);
        pb.setRunningTaskCount(taskCounts * 5);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)TezVertexID.fromString((String)vertexIDStr)).when((Object)mockVertex)).getVertexId();
        ((Vertex)Mockito.doReturn((Object)status).when((Object)mockVertex)).getState();
        ((Vertex)Mockito.doReturn((Object)Float.valueOf(progress)).when((Object)mockVertex)).getProgress();
        ((Vertex)Mockito.doReturn((Object)pb).when((Object)mockVertex)).getVertexProgress();
        ((Vertex)Mockito.doReturn((Object)1L).when((Object)mockVertex)).getInitTime();
        ((Vertex)Mockito.doReturn((Object)1L).when((Object)mockVertex)).getStartTime();
        ((Vertex)Mockito.doReturn((Object)2L).when((Object)mockVertex)).getFinishTime();
        ((Vertex)Mockito.doReturn((Object)1L).when((Object)mockVertex)).getFirstTaskStartTime();
        ((Vertex)Mockito.doReturn((Object)2L).when((Object)mockVertex)).getLastTaskFinishTime();
        TezCounters counters = new TezCounters();
        counters.addGroup("g1", "g1");
        counters.addGroup("g2", "g2");
        counters.addGroup("g3", "g3");
        counters.addGroup("g4", "g4");
        counters.findCounter("g1", "g1_c1").setValue(100L);
        counters.findCounter("g1", "g1_c2").setValue(100L);
        counters.findCounter("g2", "g2_c3").setValue(100L);
        counters.findCounter("g2", "g2_c4").setValue(100L);
        counters.findCounter("g3", "g3_c5").setValue(100L);
        counters.findCounter("g3", "g3_c6").setValue(100L);
        ((Vertex)Mockito.doReturn((Object)counters).when((Object)mockVertex)).getAllCounters();
        ((Vertex)Mockito.doReturn((Object)counters).when((Object)mockVertex)).getCachedCounters();
        return mockVertex;
    }

    private void verifySingleVertexResult(Vertex mockVertex2, Map<String, String> vertex2Result) {
        Assert.assertEquals((Object)mockVertex2.getVertexId().toString(), (Object)vertex2Result.get("id"));
        Assert.assertEquals((Object)mockVertex2.getState().toString(), (Object)vertex2Result.get("status"));
        Assert.assertEquals((Object)Float.toString(mockVertex2.getCompletedTaskProgress()), (Object)vertex2Result.get("progress"));
        ProgressBuilder progress = mockVertex2.getVertexProgress();
        Assert.assertEquals((Object)Integer.toString(progress.getTotalTaskCount()), (Object)vertex2Result.get("totalTasks"));
        Assert.assertEquals((Object)Integer.toString(progress.getRunningTaskCount()), (Object)vertex2Result.get("runningTasks"));
        Assert.assertEquals((Object)Integer.toString(progress.getSucceededTaskCount()), (Object)vertex2Result.get("succeededTasks"));
        Assert.assertEquals((Object)Integer.toString(progress.getKilledTaskAttemptCount()), (Object)vertex2Result.get("killedTaskAttempts"));
        Assert.assertEquals((Object)Integer.toString(progress.getFailedTaskAttemptCount()), (Object)vertex2Result.get("failedTaskAttempts"));
        String str0 = Long.toString(mockVertex2.getInitTime());
        String str1 = vertex2Result.get("initTime");
        Assert.assertEquals((Object)Long.toString(mockVertex2.getInitTime()), (Object)vertex2Result.get("initTime"));
        Assert.assertEquals((Object)Long.toString(mockVertex2.getStartTime()), (Object)vertex2Result.get("startTime"));
        Assert.assertEquals((Object)Long.toString(mockVertex2.getFinishTime()), (Object)vertex2Result.get("finishTime"));
        Assert.assertEquals((Object)Long.toString(mockVertex2.getFirstTaskStartTime()), (Object)vertex2Result.get("firstTaskStartTime"));
        Assert.assertEquals((Object)Long.toString(mockVertex2.getLastTaskFinishTime()), (Object)vertex2Result.get("lastTaskFinishTime"));
    }

    @Test(timeout=5000L)
    public void testGetTasksInfoWithTaskIds() {
        List<Task> tasks = this.createMockTasks();
        List<Object> vertexMinIds = Arrays.asList(new Object[0]);
        List<List<Integer>> taskMinIds = Arrays.asList(Arrays.asList(0, 0), Arrays.asList(0, 3), Arrays.asList(0, 1));
        Map<String, Object> result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 100);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        ArrayList tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)3L, (long)tasksInfo.size());
        this.verifySingleTaskResult(tasks.get(0), (Map)tasksInfo.get(0));
        this.verifySingleTaskResult(tasks.get(3), (Map)tasksInfo.get(1));
        this.verifySingleTaskResult(tasks.get(1), (Map)tasksInfo.get(2));
        result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)2L, (long)tasksInfo.size());
        this.verifySingleTaskResult(tasks.get(0), (Map)tasksInfo.get(0));
        this.verifySingleTaskResult(tasks.get(3), (Map)tasksInfo.get(1));
    }

    @Test(timeout=5000L)
    public void testGetTasksInfoGracefulTaskFetch() {
        List<Task> tasks = this.createMockTasks();
        List<Object> vertexMinIds = Arrays.asList(new Object[0]);
        List<List<Integer>> taskMinIds = Arrays.asList(Arrays.asList(0, 0), Arrays.asList(0, 6), Arrays.asList(0, 1));
        Map<String, Object> result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 100);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        ArrayList tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)2L, (long)tasksInfo.size());
        this.verifySingleTaskResult(tasks.get(0), (Map)tasksInfo.get(0));
        this.verifySingleTaskResult(tasks.get(1), (Map)tasksInfo.get(1));
    }

    @Test(timeout=5000L)
    public void testGetTasksInfoWithVertexId() {
        List<Task> tasks = this.createMockTasks();
        List<Integer> vertexMinIds = Arrays.asList(0);
        List<Object> taskMinIds = Arrays.asList(new Object[0]);
        Map<String, Object> result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 100);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        ArrayList tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)4L, (long)tasksInfo.size());
        this.sortMapList(tasksInfo, "id");
        this.verifySingleTaskResult(tasks.get(0), (Map)tasksInfo.get(0));
        this.verifySingleTaskResult(tasks.get(1), (Map)tasksInfo.get(1));
        this.verifySingleTaskResult(tasks.get(2), (Map)tasksInfo.get(2));
        this.verifySingleTaskResult(tasks.get(3), (Map)tasksInfo.get(3));
        result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)2L, (long)tasksInfo.size());
    }

    @Test(timeout=5000L)
    public void testGetTasksInfoWithJustDAGId() {
        List<Task> tasks = this.createMockTasks();
        List<Object> vertexMinIds = Arrays.asList(new Object[0]);
        List<Object> taskMinIds = Arrays.asList(new Object[0]);
        Map<String, Object> result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 100);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        ArrayList tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)4L, (long)tasksInfo.size());
        this.sortMapList(tasksInfo, "id");
        this.verifySingleTaskResult(tasks.get(0), (Map)tasksInfo.get(0));
        this.verifySingleTaskResult(tasks.get(1), (Map)tasksInfo.get(1));
        this.verifySingleTaskResult(tasks.get(2), (Map)tasksInfo.get(2));
        this.verifySingleTaskResult(tasks.get(3), (Map)tasksInfo.get(3));
        result = this.getTasksTestHelper(tasks, taskMinIds, vertexMinIds, 2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("tasks"));
        tasksInfo = (ArrayList)result.get("tasks");
        Assert.assertEquals((long)2L, (long)tasksInfo.size());
    }

    private void sortMapList(ArrayList<Map<String, String>> list, String propertyName) {
        class MapComparator
        implements Comparator<Map<String, String>> {
            private final String key;

            public MapComparator(String key) {
                this.key = key;
            }

            @Override
            public int compare(Map<String, String> first, Map<String, String> second) {
                String firstValue = first.get(this.key);
                String secondValue = second.get(this.key);
                return firstValue.compareTo(secondValue);
            }
        }
        Collections.sort(list, new MapComparator(propertyName));
    }

    Map<String, Object> getTasksTestHelper(List<Task> tasks, List<List<Integer>> taskMinIds, List<Integer> vertexMinIds, Integer limit) {
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1441301219877_0109_1")).when((Object)mockDAG)).getID();
        TezVertexID vertexID = TezVertexID.fromString((String)"vertex_1441301219877_0109_1_00");
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)vertexID).when((Object)mockVertex)).getVertexId();
        ((DAG)Mockito.doReturn((Object)mockVertex).when((Object)mockDAG)).getVertex(vertexID);
        ((DAG)Mockito.doReturn((Object)ImmutableMap.of((Object)vertexID, (Object)mockVertex)).when((Object)mockDAG)).getVertices();
        HashMap taskMap = Maps.newHashMap();
        for (Task task : tasks) {
            TezTaskID taskId = task.getTaskId();
            int taskIndex = taskId.getId();
            ((Vertex)Mockito.doReturn((Object)task).when((Object)mockVertex)).getTask(taskIndex);
            taskMap.put(taskId, task);
        }
        ((Vertex)Mockito.doReturn((Object)taskMap).when((Object)mockVertex)).getTasks();
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).setupResponse();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        ((AMWebController)Mockito.doReturn((Object)limit).when((Object)spy)).getQueryParamInt("limit");
        ((AMWebController)Mockito.doReturn(vertexMinIds).when((Object)spy)).getIntegersFromRequest("vertexID", limit);
        ((AMWebController)Mockito.doReturn(taskMinIds).when((Object)spy)).getIDsFromRequest("taskID", limit, Integer.valueOf(2));
        ((AMWebController)Mockito.doReturn((Object)mockDAG).when((Object)spy)).checkAndGetDAGFromRequest();
        TreeMap counterList = new TreeMap();
        ((AMWebController)Mockito.doReturn(counterList).when((Object)spy)).getCounterListFromRequest();
        spy.getTasksInfo();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.returnResultCaptor.capture());
        return (Map)this.returnResultCaptor.getValue();
    }

    private List<Task> createMockTasks() {
        Task mockTask1 = this.createMockTask("task_1441301219877_0109_1_00_000000", TaskState.RUNNING, 0.33f);
        Task mockTask2 = this.createMockTask("task_1441301219877_0109_1_00_000001", TaskState.SUCCEEDED, 1.0f);
        Task mockTask3 = this.createMockTask("task_1441301219877_0109_1_00_000002", TaskState.SUCCEEDED, 0.8f);
        Task mockTask4 = this.createMockTask("task_1441301219877_0109_1_00_000003", TaskState.SUCCEEDED, 0.8f);
        List<Task> tasks = Arrays.asList(mockTask1, mockTask2, mockTask3, mockTask4);
        return tasks;
    }

    private Task createMockTask(String taskIDStr, TaskState status, float progress) {
        Task mockTask = (Task)Mockito.mock(Task.class);
        ((Task)Mockito.doReturn((Object)TezTaskID.fromString((String)taskIDStr)).when((Object)mockTask)).getTaskId();
        ((Task)Mockito.doReturn((Object)status).when((Object)mockTask)).getState();
        ((Task)Mockito.doReturn((Object)Float.valueOf(progress)).when((Object)mockTask)).getProgress();
        TezCounters counters = new TezCounters();
        counters.addGroup("g1", "g1");
        counters.addGroup("g2", "g2");
        counters.addGroup("g3", "g3");
        counters.addGroup("g4", "g4");
        counters.findCounter("g1", "g1_c1").setValue(101L);
        counters.findCounter("g1", "g1_c2").setValue(102L);
        counters.findCounter("g2", "g2_c3").setValue(103L);
        counters.findCounter("g2", "g2_c4").setValue(104L);
        counters.findCounter("g3", "g3_c5").setValue(105L);
        counters.findCounter("g3", "g3_c6").setValue(106L);
        ((Task)Mockito.doReturn((Object)counters).when((Object)mockTask)).getCounters();
        return mockTask;
    }

    private void verifySingleTaskResult(Task mockTask, Map<String, String> taskResult) {
        Assert.assertEquals((long)3L, (long)taskResult.size());
        Assert.assertEquals((Object)mockTask.getTaskId().toString(), (Object)taskResult.get("id"));
        Assert.assertEquals((Object)mockTask.getState().toString(), (Object)taskResult.get("status"));
        Assert.assertEquals((Object)Float.toString(mockTask.getProgress()), (Object)taskResult.get("progress"));
    }

    @Test(timeout=5000L)
    public void testGetAttemptsInfoWithIds() {
        List<TaskAttempt> attempts = this.createMockAttempts();
        List<Object> vertexMinIds = Arrays.asList(new Object[0]);
        List<Object> taskMinIds = Arrays.asList(new Object[0]);
        List<List<Integer>> attemptMinIds = Arrays.asList(Arrays.asList(0, 0, 0), Arrays.asList(0, 0, 1), Arrays.asList(0, 0, 2), Arrays.asList(0, 0, 3));
        Map<String, Object> result = this.getAttemptsTestHelper(attempts, attemptMinIds, vertexMinIds, taskMinIds, 100);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("attempts"));
        ArrayList attemptsInfo = (ArrayList)result.get("attempts");
        Assert.assertEquals((long)4L, (long)attemptsInfo.size());
        this.verifySingleAttemptResult(attempts.get(0), (Map)attemptsInfo.get(0));
        this.verifySingleAttemptResult(attempts.get(1), (Map)attemptsInfo.get(1));
        this.verifySingleAttemptResult(attempts.get(2), (Map)attemptsInfo.get(2));
        this.verifySingleAttemptResult(attempts.get(3), (Map)attemptsInfo.get(3));
        result = this.getAttemptsTestHelper(attempts, attemptMinIds, vertexMinIds, taskMinIds, 2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey("attempts"));
        attemptsInfo = (ArrayList)result.get("attempts");
        Assert.assertEquals((long)2L, (long)attemptsInfo.size());
        this.verifySingleAttemptResult(attempts.get(0), (Map)attemptsInfo.get(0));
        this.verifySingleAttemptResult(attempts.get(1), (Map)attemptsInfo.get(1));
    }

    Map<String, Object> getAttemptsTestHelper(List<TaskAttempt> attempts, List<List<Integer>> attemptMinIds, List<Integer> vertexMinIds, List<Integer> taskMinIds, Integer limit) {
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)TezDAGID.fromString((String)"dag_1441301219877_0109_1")).when((Object)mockDAG)).getID();
        TezVertexID vertexID = TezVertexID.fromString((String)"vertex_1441301219877_0109_1_00");
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)vertexID).when((Object)mockVertex)).getVertexId();
        ((DAG)Mockito.doReturn((Object)mockVertex).when((Object)mockDAG)).getVertex(vertexID);
        ((DAG)Mockito.doReturn((Object)ImmutableMap.of((Object)vertexID, (Object)mockVertex)).when((Object)mockDAG)).getVertices();
        TezTaskID taskID = TezTaskID.fromString((String)"task_1441301219877_0109_1_00_000000");
        Task mockTask = (Task)Mockito.mock(Task.class);
        ((Task)Mockito.doReturn((Object)taskID).when((Object)mockTask)).getTaskId();
        int taskIndex = taskID.getId();
        ((Vertex)Mockito.doReturn((Object)mockTask).when((Object)mockVertex)).getTask(taskIndex);
        ((Vertex)Mockito.doReturn((Object)ImmutableMap.of((Object)taskID, (Object)mockTask)).when((Object)mockVertex)).getTasks();
        HashMap attemptsMap = Maps.newHashMap();
        for (TaskAttempt attempt : attempts) {
            TezTaskAttemptID attemptId = attempt.getID();
            ((Task)Mockito.doReturn((Object)attempt).when((Object)mockTask)).getAttempt(attemptId);
            attemptsMap.put(attemptId, attempt);
        }
        ((Task)Mockito.doReturn((Object)attemptsMap).when((Object)mockTask)).getAttempts();
        AMWebController amWebController = new AMWebController(this.mockRequestContext, this.mockAppContext, "TEST_HISTORY_URL");
        AMWebController spy = (AMWebController)Mockito.spy((Object)amWebController);
        ((AMWebController)Mockito.doReturn((Object)true).when((Object)spy)).setupResponse();
        ((AMWebController)Mockito.doNothing().when((Object)spy)).renderJSON(Matchers.any());
        ((AMWebController)Mockito.doReturn((Object)limit).when((Object)spy)).getQueryParamInt("limit");
        ((AMWebController)Mockito.doReturn(vertexMinIds).when((Object)spy)).getIntegersFromRequest("vertexID", limit);
        ((AMWebController)Mockito.doReturn(taskMinIds).when((Object)spy)).getIDsFromRequest("taskID", limit, Integer.valueOf(2));
        ((AMWebController)Mockito.doReturn(attemptMinIds).when((Object)spy)).getIDsFromRequest("attemptID", limit, Integer.valueOf(3));
        ((AMWebController)Mockito.doReturn((Object)mockDAG).when((Object)spy)).checkAndGetDAGFromRequest();
        TreeMap counterList = new TreeMap();
        ((AMWebController)Mockito.doReturn(counterList).when((Object)spy)).getCounterListFromRequest();
        spy.getAttemptsInfo();
        ((AMWebController)Mockito.verify((Object)spy)).renderJSON(this.returnResultCaptor.capture());
        return (Map)this.returnResultCaptor.getValue();
    }

    private List<TaskAttempt> createMockAttempts() {
        TaskAttempt mockAttempt1 = this.createMockAttempt("attempt_1441301219877_0109_1_00_000000_0", TaskAttemptState.RUNNING, 0.33f);
        TaskAttempt mockAttempt2 = this.createMockAttempt("attempt_1441301219877_0109_1_00_000000_1", TaskAttemptState.SUCCEEDED, 1.0f);
        TaskAttempt mockAttempt3 = this.createMockAttempt("attempt_1441301219877_0109_1_00_000000_2", TaskAttemptState.FAILED, 0.8f);
        TaskAttempt mockAttempt4 = this.createMockAttempt("attempt_1441301219877_0109_1_00_000000_3", TaskAttemptState.SUCCEEDED, 0.8f);
        List<TaskAttempt> attempts = Arrays.asList(mockAttempt1, mockAttempt2, mockAttempt3, mockAttempt4);
        return attempts;
    }

    private TaskAttempt createMockAttempt(String attemptIDStr, TaskAttemptState status, float progress) {
        TaskAttempt mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)TezTaskAttemptID.fromString((String)attemptIDStr)).when((Object)mockAttempt)).getID();
        ((TaskAttempt)Mockito.doReturn((Object)status).when((Object)mockAttempt)).getState();
        ((TaskAttempt)Mockito.doReturn((Object)Float.valueOf(progress)).when((Object)mockAttempt)).getProgress();
        TezCounters counters = new TezCounters();
        counters.addGroup("g1", "g1");
        counters.addGroup("g2", "g2");
        counters.addGroup("g3", "g3");
        counters.addGroup("g4", "g4");
        counters.findCounter("g1", "g1_c1").setValue(101L);
        counters.findCounter("g1", "g1_c2").setValue(102L);
        counters.findCounter("g2", "g2_c3").setValue(103L);
        counters.findCounter("g2", "g2_c4").setValue(104L);
        counters.findCounter("g3", "g3_c5").setValue(105L);
        counters.findCounter("g3", "g3_c6").setValue(106L);
        ((TaskAttempt)Mockito.doReturn((Object)counters).when((Object)mockAttempt)).getCounters();
        return mockAttempt;
    }

    private void verifySingleAttemptResult(TaskAttempt mockTask, Map<String, String> taskResult) {
        Assert.assertEquals((long)3L, (long)taskResult.size());
        Assert.assertEquals((Object)mockTask.getID().toString(), (Object)taskResult.get("id"));
        Assert.assertEquals((Object)mockTask.getState().toString(), (Object)taskResult.get("status"));
        Assert.assertEquals((Object)Float.toString(mockTask.getProgress()), (Object)taskResult.get("progress"));
    }
}

