/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.net.InetSocketAddress;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.serviceplugins.api.ServicePluginException;
import org.apache.tez.serviceplugins.api.TaskCommunicator;
import org.mockito.Mockito;

public class TestAMContainerMap {
    private ContainerHeartbeatHandler mockContainerHeartBeatHandler() {
        return (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class);
    }

    private TaskCommunicatorManagerInterface mockTaskAttemptListener() throws ServicePluginException {
        TaskCommunicatorManagerInterface tal = (TaskCommunicatorManagerInterface)Mockito.mock(TaskCommunicatorManagerInterface.class);
        TaskCommunicator taskComm = (TaskCommunicator)Mockito.mock(TaskCommunicator.class);
        ((TaskCommunicator)Mockito.doReturn((Object)new InetSocketAddress("localhost", 21000)).when((Object)taskComm)).getAddress();
        ((TaskCommunicatorManagerInterface)Mockito.doReturn((Object)taskComm).when((Object)tal)).getTaskCommunicator(0);
        return tal;
    }

    private AppContext mockAppContext() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        return appContext;
    }

    private ContainerId mockContainerId(int cId) {
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)cId);
        return containerId;
    }

    private Container mockContainer(ContainerId containerId) {
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)43255);
        Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)"localhost:33333", (Resource)Resource.newInstance((int)1024, (int)1), (Priority)Priority.newInstance((int)1), (Token)((Token)Mockito.mock(Token.class)));
        return container;
    }
}

